/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.fi.arapcommon.enums.InvoiceType;
import kd.fi.arapcommon.helper.InvoiceTypeHelper;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.util.StringUtils;

public class InvoiceSubmitValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas;
        for (ExtendedDataEntity data : datas = this.getDataEntities()) {
            String invoiceType;
            String currencyname;
            DynamicObject bd_accountbanks;
            DynamicObject invoice = data.getDataEntity();
            DynamicObject invoicetypef7 = invoice.getDynamicObject("invoicetypef7");
            String invoicetype = invoice.getString("invoicetype");
            if (ObjectUtils.isEmpty((Object)invoicetype) && ObjectUtils.isEmpty((Object)invoicetypef7)) {
                this.addErrorMessage(data, InvoiceTypeHelper.getValidateInfo());
            }
            if (invoice.getBigDecimal("recamount").compareTo(BigDecimal.ZERO) == 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u6574\u5355\u4ef7\u7a0e\u5408\u8ba1\u3002", (String)"InvoiceSubmitValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            }
            Object selleracct = invoice.get("selleracct");
            DynamicObject org = invoice.getDynamicObject("org");
            if (org == null) continue;
            QFilter qFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bd_accountbanks", (Long)org.getLong("id"));
            QFilter filter = new QFilter("bankaccountnumber", "=", selleracct);
            if (selleracct != null && !ObjectUtils.isEmpty((Object)(bd_accountbanks = BusinessDataServiceHelper.loadSingleFromCache((String)"bd_accountbanks", (String)"bankaccountnumber,currencyname", (QFilter[])new QFilter[]{qFilter, filter}))) && !(currencyname = bd_accountbanks.getString("currencyname")).contains(invoice.getString("currency.name"))) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u9500\u552e\u65b9\u4fe1\u606f\u4e2d\u7684\u94f6\u884c\u8d26\u53f7\u4e0d\u652f\u6301\u6b64\u7ed3\u7b97\u5e01\uff0c\u8bf7\u66f4\u6362\u94f6\u884c\u8d26\u53f7\u6216\u5207\u6362\u7ed3\u7b97\u5e01\u3002", (String)"InvoiceSubmitValidator_26", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            }
            if ("OTHER".equals(invoiceType = invoice.getString("invoicetype"))) {
                if (invoice.getDynamicObject("expense") == null) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u8d39\u7528\u9879\u76ee\u201d\u3002", (String)"InvoiceSubmitValidator_1", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                }
            } else {
                String invoiceTypeNumber;
                if (StringUtils.isEmpty((String)invoice.getString("sellername"))) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u9500\u552e\u65b9\u540d\u79f0\u4fe1\u606f\u3002", (String)"InvoiceSubmitValidator_2", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                }
                if (StringUtils.isEmpty((String)invoice.getString("sellertin"))) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u9500\u552e\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u3002", (String)"InvoiceSubmitValidator_3", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                }
                if (StringUtils.isEmpty((String)invoice.getString("buyername"))) {
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u8d2d\u4e70\u65b9\u540d\u79f0\u4fe1\u606f\u3002", (String)"InvoiceSubmitValidator_4", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                }
                if (!("26".equals(invoiceTypeNumber = invoice.getString("invoicetypef7.number")) || "27".equals(invoiceTypeNumber) || "28".equals(invoiceTypeNumber) || "29".equals(invoiceTypeNumber))) {
                    if (StringUtils.isEmpty((String)invoice.getString("selleraddr"))) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u9500\u552e\u65b9\u5730\u5740\u4fe1\u606f\u3002", (String)"InvoiceSubmitValidator_14", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                    }
                    if (StringUtils.isEmpty((String)invoice.getString("selleracct"))) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u9500\u552e\u65b9\u8d26\u53f7\u4fe1\u606f\u3002", (String)"InvoiceSubmitValidator_15", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                    }
                }
                if (this.isSpecialInvoice(invoiceType)) {
                    if (StringUtils.isEmpty((String)invoice.getString("buyeraddr"))) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u4e13\u7528\u53d1\u7968\u8d2d\u4e70\u65b9\u5730\u5740\u4fe1\u606f\u3002", (String)"InvoiceSubmitValidator_16", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                    }
                    if (StringUtils.isEmpty((String)invoice.getString("buyertin"))) {
                        this.addErrorMessage(data, ResManager.loadKDString((String)"\u8bf7\u8865\u5145\u4e13\u7528\u53d1\u7968\u8d2d\u4e70\u65b9\u7eb3\u7a0e\u4eba\u8bc6\u522b\u53f7\u3002", (String)"InvoiceSubmitValidator_25", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                    }
                }
            }
            Object bizType = invoice.get("biztype");
            DynamicObjectCollection coll = invoice.getDynamicObjectCollection("entry");
            if (bizType == null || "OTHER".equals(invoiceType)) continue;
            this.entryValidate(coll, data, "SAL".equals(bizType));
        }
    }

    private void entryValidate(DynamicObjectCollection coll, ExtendedDataEntity data, boolean flag) {
        ArrayList<String> rowTypeList;
        DynamicObject invoice = data.getDataEntity();
        String invoiceType = invoice.getString("invoicetype");
        String srcType = invoice.getString("sourcebilltype");
        boolean isSkipCheck = "false".equals(StdConfig.get((String)"INV_CHECK_MATEXP")) && (ObjectUtils.isEmpty((Object)srcType) || "ar_invoice".equals(srcType));
        int i = 1;
        HashMap nameMap = new HashMap(coll.size());
        BigDecimal recAmt = BigDecimal.ZERO;
        BigDecimal taxAmt = BigDecimal.ZERO;
        BigDecimal amount = BigDecimal.ZERO;
        BigDecimal localAmt = BigDecimal.ZERO;
        for (DynamicObject entry : coll) {
            recAmt = recAmt.add(entry.getBigDecimal("e_recamount"));
            taxAmt = taxAmt.add(entry.getBigDecimal("e_tax"));
            amount = amount.add(entry.getBigDecimal("e_amount"));
            localAmt = localAmt.add(entry.getBigDecimal("e_localamt"));
            if ("1".equals(entry.get("e_rowtype")) || "2".equals(entry.get("e_rowtype"))) {
                if (nameMap.get(entry.getString("e_itemname")) == null) {
                    rowTypeList = new ArrayList<String>(1);
                    rowTypeList.add(entry.getString("e_rowtype"));
                    nameMap.put(entry.getString("e_itemname"), rowTypeList);
                } else {
                    ((List)nameMap.get(entry.getString("e_itemname"))).add(entry.getString("e_rowtype"));
                }
            }
            if (!isSkipCheck) {
                if (flag) {
                    if (this.addErrMsg4Column(entry, data, i, "e_material", ResManager.loadKDString((String)"\u7269\u6599", (String)"InvoiceSubmitValidator_6", (String)"fi-ar-opplugin", (Object[])new Object[0]))) {
                        return;
                    }
                    if (this.addErrMsg4Column(entry, data, i, "e_measureunit", ResManager.loadKDString((String)"\u8ba1\u91cf\u5355\u4f4d", (String)"InvoiceSubmitValidator_7", (String)"fi-ar-opplugin", (Object[])new Object[0]))) {
                        return;
                    }
                } else if (this.addErrMsg4Column(entry, data, i, "e_expenseitem", ResManager.loadKDString((String)"\u8d39\u7528\u9879\u76ee", (String)"InvoiceSubmitValidator_8", (String)"fi-ar-opplugin", (Object[])new Object[0]))) {
                    return;
                }
            }
            if (this.isSpecialInvoice(invoiceType) && entry.getBigDecimal("e_taxrate").compareTo(BigDecimal.ZERO) == 0) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u4e13\u7528\u53d1\u7968\u4e0d\u652f\u6301\u5355\u636e\u4f53\u96f6\u7a0e\u7387\u884c\u5f00\u7968\uff0c\u8bf7\u586b\u5199\u7a0e\u7387\u6216\u4fee\u6539\u53d1\u7968\u7c7b\u578b\u3002", (String)"InvoiceSubmitValidator_13", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                return;
            }
            ++i;
        }
        if (amount.compareTo(invoice.getBigDecimal("amount")) != 0) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5206\u5f55\u6c47\u603b\u91d1\u989d\u4e0e\u8868\u5934\u91d1\u989d\u4e0d\u7b26\uff0c\u8bf7\u4fee\u6b63\u3002", (String)"InvoiceSubmitValidator_21", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            return;
        }
        if (taxAmt.compareTo(invoice.getBigDecimal("tax")) != 0) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5206\u5f55\u7684\u7a0e\u989d\u603b\u548c\u4e0e\u8868\u5934\u7684\u7a0e\u989d\u4e0d\u76f8\u7b49\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"InvoiceSubmitValidator_22", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            return;
        }
        if (recAmt.compareTo(invoice.getBigDecimal("recamount")) != 0) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5206\u5f55\u6c47\u603b\u4ef7\u7a0e\u5408\u8ba1\u4e0e\u8868\u5934\u4ef7\u7a0e\u5408\u8ba1\u4e0d\u7b26\uff0c\u8bf7\u4fee\u6b63\u3002", (String)"InvoiceSubmitValidator_23", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            return;
        }
        if (localAmt.compareTo(invoice.getBigDecimal("localamt")) != 0) {
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u5206\u5f55\u7684\u91d1\u989d(\u672c\u4f4d\u5e01)\u603b\u548c\u4e0e\u8868\u5934\u7684\u91d1\u989d(\u672c\u4f4d\u5e01)\u4e0d\u76f8\u7b49\uff0c\u8bf7\u4fee\u6b63\u3002", (String)"InvoiceSubmitValidator_24", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            return;
        }
        for (Map.Entry map : nameMap.entrySet()) {
            rowTypeList = (ArrayList<String>)map.getValue();
            if (rowTypeList.size() == 1) {
                this.addErrorMessage(data, ResManager.loadKDString((String)"\u6298\u6263\u884c\u4e0e\u88ab\u6298\u6263\u884c\u7684\u5f00\u7968\u540d\u79f0\u4e0d\u540c\uff0c\u8bf7\u4fee\u6b63\u3002", (String)"InvoiceSubmitValidator_19", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                return;
            }
            if (!"1".equals(rowTypeList.get(0))) continue;
            this.addErrorMessage(data, ResManager.loadKDString((String)"\u6298\u6263\u884c\u9700\u79fb\u81f3\u88ab\u6298\u6263\u884c\u4e4b\u540e\uff0c\u8bf7\u4fee\u6b63\u3002", (String)"InvoiceSubmitValidator_20", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            return;
        }
    }

    private boolean addErrMsg4Column(DynamicObject entry, ExtendedDataEntity data, int i, String key, String name) {
        Object object = entry.get(key);
        if (object == null || object.equals("")) {
            this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u660e\u7ec6\u201d\u7b2c%1$s\u884c\u201c%2$s\u201d\u5b57\u6bb5\u3002", (String)"InvoiceSubmitValidator_10", (String)"fi-ar-opplugin", (Object[])new Object[0]), i, name));
            return true;
        }
        return false;
    }

    private boolean isSpecialInvoice(String invoiceType) {
        return InvoiceType.SE.getValue().equals(invoiceType) || InvoiceType.SP.getValue().equals(invoiceType);
    }
}

