/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.util.ArrayList;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ar.errorcode.BaddebtErrorCode;

public class PolicyUniqueValidator
extends AbstractValidator {
    public void validate() {
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject info = dataEntity.getDataEntity();
            DynamicObject policyType = info.getDynamicObject("policytype");
            DynamicObjectCollection mulOrgs = info.getDynamicObjectCollection("orgs");
            if (ObjectUtils.isEmpty((Object)mulOrgs) || ObjectUtils.isEmpty((Object)policyType)) {
                return;
            }
            ArrayList<Long> orgPks = new ArrayList<Long>();
            for (DynamicObject mulOrg : mulOrgs) {
                orgPks.add(mulOrg.getLong("fbasedataid_id"));
            }
            QFilter qFilter = new QFilter("useorg", "in", orgPks);
            Map policyMap = BusinessDataServiceHelper.loadFromCache((String)"ar_policy", (String)"useorg.id, useorg.name, policytype.id, policytype.type", (QFilter[])new QFilter[]{qFilter});
            for (Map.Entry keySet : policyMap.entrySet()) {
                DynamicObject policy = (DynamicObject)keySet.getValue();
                DynamicObject q_org = policy.getDynamicObject("useorg");
                DynamicObject q_policyType = policy.getDynamicObject("policytype");
                for (Long orgPk : orgPks) {
                    if (!q_org.getPkValue().equals(orgPk) || ObjectUtils.isEmpty((Object)q_policyType) || !policyType.getPkValue().equals(q_policyType.getPkValue())) continue;
                    String msg = String.format(BaddebtErrorCode.POLICY_EXISTS_ORGPOLICYTYPE().getMessage(), q_org.getLocaleString("name").getLocaleValue(), policyType.getLocaleString("name").getLocaleValue());
                    this.addErrorMessage(dataEntity, msg);
                }
            }
        }
    }
}

