/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.text.SimpleDateFormat;
import java.util.Date;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.util.DateUtils;

public class ReceivedBillImportValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas;
        for (ExtendedDataEntity data : datas = this.dataEntities) {
            DynamicObject bill = data.getDataEntity();
            String billSrctype = bill.getString("billsrctype");
            if (!BillSrcTypeEnum.IMPORT.getValue().equals(billSrctype)) continue;
            DynamicObject org = bill.getDynamicObject("org");
            Long orgPk = org.getLong("id");
            InitHelper init = new InitHelper(orgPk.longValue(), "ar_init");
            if (init.isFinishInit()) {
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7ec4\u7ec7\u201c%s\u201d\u5df2\u7ecf\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u65e0\u6cd5\u5bfc\u5165\u3002", (String)"ReceivedBillImportValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[0]), org.getLocaleString("name").getLocaleValue()));
            }
            Date bizDate = bill.getDate("bizdate");
            Date startDate = init.getStartDate();
            Date perviousDayOfStartDate = DateUtils.getDataFormat((Date)DateUtils.getNextDay((Date)startDate, (int)-1), (boolean)false);
            SimpleDateFormat short_date = new SimpleDateFormat("yyyy-MM-dd");
            if (!ObjectUtils.isEmpty((Object)bizDate) && DateUtils.compareTo((Date)bizDate, (Date)perviousDayOfStartDate) > 0) {
                String message = String.format(ResManager.loadKDString((String)"\u4e1a\u52a1\u65e5\u671f\u201c%1$s\u201d\u5e94\u65e9\u4e8e\u6216\u7b49\u4e8e\u542f\u7528\u65e5\u671f\u201c%2$s\u201d\u7684\u524d\u4e00\u5929\u3002", (String)"ReceivedBillImportValidator_1", (String)"fi-ar-opplugin", (Object[])new Object[0]), short_date.format(bizDate), short_date.format(startDate));
                this.addErrorMessage(data, message);
            }
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
            for (int i = 0; i < entries.size(); ++i) {
                DynamicObject entry = (DynamicObject)entries.get(i);
                if (entry.get("e_material") == null || entry.get("e_expenseitem") == null) continue;
                this.addErrorMessage(data, String.format(ResManager.loadKDString((String)"\u7b2c%s\u884c\u5206\u5f55\uff0c\u7269\u6599\u4e0e\u8d39\u7528\u9879\u76ee\u4e0d\u80fd\u540c\u65f6\u5f55\u5165\u3002", (String)"ReceivedBillImportValidator_2", (String)"fi-ar-opplugin", (Object[])new Object[0]), i + 1));
            }
        }
    }
}

