/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.enums.BillSrcTypeEnum;
import kd.fi.arapcommon.util.EmptyUtils;

public class RevCfmBillImportValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] datas = this.dataEntities;
        ArrayList<Long> orgList = new ArrayList<Long>(8);
        HashMap<Long, ExtendedDataEntity> dataMap = new HashMap<Long, ExtendedDataEntity>();
        for (ExtendedDataEntity data : datas) {
            DynamicObject bill = data.getDataEntity();
            String billSrctype = bill.getString("billsrctype");
            if (!BillSrcTypeEnum.IMPORT.getValue().equals(billSrctype)) continue;
            DynamicObjectCollection entries = bill.getDynamicObjectCollection("entry");
            DynamicObject org = bill.getDynamicObject("org");
            Long id = bill.getLong("id");
            Long orgPk = (Long)org.getPkValue();
            orgList.add(orgPk);
            dataMap.put(id, data);
            for (int i = 0; i < entries.size(); ++i) {
                DynamicObject row = (DynamicObject)entries.get(i);
                DynamicObject material = row.getDynamicObject("e_material");
                if (material == null) continue;
                String configproperty = material.getString("configproperties");
                DynamicObject configuredcode = row.getDynamicObject("configuredcode");
                if ("2".equals(configproperty)) {
                    if (EmptyUtils.isNotEmpty((Object)configuredcode)) {
                        if (material.getString("number").equals(configuredcode.getString("material.number"))) continue;
                        this.addMessage(data, String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5bfc\u5165\u7684\u201c\u914d\u7f6e\u53f7\u201d\u4e0e\u7269\u6599\u4e0d\u5339\u914d\u3002", (String)"RevCfmBillImportValidator_1", (String)"fi-ar-opplugin", (Object[])new Object[0]), i + 1));
                        continue;
                    }
                    this.addMessage(data, String.format(ResManager.loadKDString((String)"\u660e\u7ec6\u7b2c%s\u884c\u201c\u914d\u7f6e\u53f7\u201d\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"RevCfmBillImportValidator_2", (String)"fi-ar-opplugin", (Object[])new Object[0]), i + 1));
                    continue;
                }
                if (!EmptyUtils.isNotEmpty((Object)configuredcode)) continue;
                row.set("configuredcode", null);
            }
        }
        Map orgDate = BusinessDataServiceHelper.loadFromCache((String)"ar_init", (String)"org,startdate,currentdate", (QFilter[])new QFilter[]{new QFilter("org", "in", orgList)});
        if (!ObjectUtils.isEmpty((Object)orgDate)) {
            HashMap<Long, DynamicObject> orgMap = new HashMap<Long, DynamicObject>();
            orgDate.forEach((key, value) -> {
                DynamicObject org = (DynamicObject)value.get("org");
                Long orgId = (Long)org.get("id");
                orgMap.put(orgId, (DynamicObject)value);
            });
            this.checkDate(dataMap, orgMap);
            this.checkBillType(this.entityKey, dataMap);
        }
    }

    protected void checkDate(Map<Long, ExtendedDataEntity> data, Map<Long, DynamicObject> orgMap) {
        data.forEach((key, value) -> {
            DynamicObject bill = value.getDataEntity();
            DynamicObject org = bill.getDynamicObject("org");
            Long orgId = org.getLong("id");
            Date valueDate = (Date)bill.get("bizdate");
            DynamicObject orgInfo = (DynamicObject)orgMap.get(orgId);
            Date currentdate = (Date)orgInfo.get("currentdate");
            if (ObjectUtils.isEmpty((Object)currentdate)) {
                currentdate = (Date)orgInfo.get("startdate");
            }
            if (currentdate != null && valueDate.compareTo(currentdate) < 0) {
                this.addMessage((ExtendedDataEntity)value, String.format(ResManager.loadKDString((String)"\u201c%1$s\u201d\u5e94\u665a\u4e8e\u6216\u7b49\u4e8e\u516c\u53f8\u5f53\u524d\u65e5\u671f\u201c%2$s\u201d\u3002", (String)"RevCfmBillImportValidator_3", (String)"fi-ar-opplugin", (Object[])new Object[0]), ResManager.loadKDString((String)"\u786e\u8ba4\u65e5\u671f", (String)"RevCfmBillImportValidator_4", (String)"fi-ar-opplugin", (Object[])new Object[0]), currentdate));
            }
        });
    }

    public void checkBillType(String entityKey, Map<Long, ExtendedDataEntity> dataMap) {
        QFilter filter = null;
        filter = new QFilter("billformid", "=", (Object)entityKey);
        Map rs = BusinessDataServiceHelper.loadFromCache((String)"bos_billtype", (String)"id,number,name", (QFilter[])filter.toArray());
        dataMap.forEach((key, value) -> {
            DynamicObject bill = value.getDataEntity();
            DynamicObject billType = bill.getDynamicObject("billtype");
            if (!ObjectUtils.isEmpty((Object)billType)) {
                Long billtypeId = (Long)billType.get("id");
                String number = (String)billType.get("number");
                if (!rs.containsKey(billtypeId)) {
                    this.addMessage((ExtendedDataEntity)value, String.format(ResManager.loadKDString((String)"\u6807\u8bc6\u5b9e\u4f53%1$s\u4e2d\u4e0d\u5305\u542b\u7f16\u7801\u4e3a:%2$s\u7684\u7c7b\u578b\u3002", (String)"RevCfmBillImportValidator_6", (String)"fi-ar-opplugin", (Object[])new Object[0]), entityKey, number));
                }
            } else {
                this.addMessage((ExtendedDataEntity)value, String.format(ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u5355\u636e\u7c7b\u578b\u3002", (String)"RevCfmBillImportValidator_7", (String)"fi-ar-opplugin", (Object[])new Object[0]), new Object[0]));
            }
        });
    }
}

