/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class RevCfmBillSubmitValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities = this.getDataEntities();
        Map<Long, Boolean> paramMap = this.prepareData(dataEntities);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            BigDecimal confirmrate;
            String confirmWay;
            DynamicObject bill = dataEntity.getDataEntity();
            String billtype = bill.getString("billtype.number");
            if (!"ar_revcfmbill_borrowar_BT_S".equals(billtype) && bill.getBigDecimal("confirmrate").abs().compareTo(new BigDecimal(100)) > 0) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8868\u5934\u7684\u6536\u5165\u786e\u8ba4\u6bd4\u4f8b(%)\u5fc5\u987b\u5927\u4e8e\u7b49\u4e8e-100\u5e76\u4e14\u5c0f\u4e8e\u7b49\u4e8e100\uff0c\u8bf7\u4fee\u6539\u3002", (String)"RevCfmBillSubmitValidator_1", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            }
            if ("ar_finarbill".equals(bill.getString("sourcebilltype")) || "ar_revcfmbill".equals(bill.getString("sourcebilltype"))) {
                Boolean srcIsBasedonAmt = paramMap.get(bill.getLong("sourcebillid"));
                if (srcIsBasedonAmt == null) continue;
                if (!bill.getBoolean("payproperty.isbasedonamt") == srcIsBasedonAmt) {
                    this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u5165\u786e\u8ba4\u5355.\u6b3e\u9879\u6027\u8d28.\u662f\u5426\u91d1\u989d\u57fa\u51c6\u9700\u4e0e\u4e0a\u6e38\u5355\u636e\u4fdd\u6301\u4e00\u81f4\uff0c\u8bf7\u4fee\u6539\u540e\u63d0\u4ea4\u3002", (String)"RevCfmBillSubmitValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                }
            }
            if (!"RATE".equals(confirmWay = bill.getString("confirmway")) || !EmptyUtils.isEmpty((Object)(confirmrate = bill.getBigDecimal("confirmrate")))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u586b\u5199\u201c\u6536\u5165\u786e\u8ba4\u6bd4\u4f8b(%)\u201d\u3002", (String)"RevCfmBillSubmitValidator_2", (String)"fi-ar-opplugin", (Object[])new Object[0]));
        }
    }

    private Map<Long, Boolean> prepareData(ExtendedDataEntity[] dataEntities) {
        List srcRevcfmIds;
        HashMap<Long, Boolean> paramMap = new HashMap<Long, Boolean>(8);
        List srcFinIds = Stream.of(dataEntities).filter(dataEntity -> "ar_finarbill".equals(dataEntity.getDataEntity().getString("sourcebilltype"))).map(dataEntity -> dataEntity.getDataEntity().getLong("sourcebillid")).collect(Collectors.toList());
        if (!srcFinIds.isEmpty()) {
            QFilter qf = new QFilter("id", "in", srcFinIds);
            DynamicObjectCollection finBillCollection = QueryServiceHelper.query((String)"ar_finarbill", (String)"id,payproperty.isbasedonamt", (QFilter[])new QFilter[]{qf});
            for (DynamicObject finBill : finBillCollection) {
                paramMap.put(finBill.getLong("id"), finBill.getBoolean("payproperty.isbasedonamt"));
            }
        }
        if (!(srcRevcfmIds = Stream.of(dataEntities).filter(dataEntity -> "ar_revcfmbill".equals(dataEntity.getDataEntity().getString("sourcebilltype"))).map(dataEntity -> dataEntity.getDataEntity().getLong("sourcebillid")).collect(Collectors.toList())).isEmpty()) {
            QFilter qf = new QFilter("id", "in", srcRevcfmIds);
            DynamicObjectCollection revcfmBillCollection = QueryServiceHelper.query((String)"ar_revcfmbill", (String)"id,payproperty.isbasedonamt", (QFilter[])new QFilter[]{qf});
            for (DynamicObject revcfmBill : revcfmBillCollection) {
                paramMap.put(revcfmBill.getLong("id"), revcfmBill.getBoolean("payproperty.isbasedonamt"));
            }
        }
        return paramMap;
    }
}

