/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.ar.mservice.helper.VerifyServiceHelper;
import kd.fi.arapcommon.helper.ArApXDBHelper;

public class RevInventoryCostCheckValidator
extends AbstractValidator {
    public void validate() {
        DynamicObject entity2;
        ExtendedDataEntity[] dataEntities = this.dataEntities;
        ArrayList<ExtendedDataEntity> checkCostEntities = new ArrayList<ExtendedDataEntity>(dataEntities.length);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            entity2 = dataEntity.getDataEntity();
            boolean hadWrittenOff = entity2.getBoolean("hadwrittenoff");
            boolean isWrittenOff = entity2.getBoolean("iswrittenoff");
            String verifyStatus = entity2.getString("verifystatus");
            if (isWrittenOff) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51b2\u9500\u7684\u6536\u5165\u786e\u8ba4\u5355\u65e0\u9700\u68c0\u67e5\u5b58\u8d27\u6210\u672c\u3002", (String)"RevInventoryCostCheckValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (hadWrittenOff) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u88ab\u51b2\u9500\u7684\u6536\u5165\u786e\u8ba4\u5355\u65e0\u9700\u68c0\u67e5\u5b58\u8d27\u6210\u672c\u3002", (String)"RevInventoryCostCheckValidator_1", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!"verified".equals(verifyStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u672a\u5168\u90e8\u6838\u9500\u7684\u6536\u5165\u786e\u8ba4\u5355\u65e0\u9700\u68c0\u67e5\u5b58\u8d27\u6210\u672c\u3002", (String)"RevInventoryCostCheckValidator_2", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                continue;
            }
            checkCostEntities.add(dataEntity);
        }
        if (ObjectUtils.isEmpty(checkCostEntities)) {
            return;
        }
        List<Long> revCfmIds = checkCostEntities.stream().map(ExtendedDataEntity::getDataEntity).map(entity -> entity.getLong("id")).collect(Collectors.toList());
        Map<Long, BigDecimal> actualCostforRow = this.getActualCost(revCfmIds);
        if (ObjectUtils.isEmpty(actualCostforRow)) {
            return;
        }
        for (ExtendedDataEntity checkCostEntity : checkCostEntities) {
            entity2 = checkCostEntity.getDataEntity();
            boolean voucher = entity2.getBoolean("isvoucher");
            DynamicObjectCollection entry = entity2.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                int seq = row.getInt("seq");
                if (this.sameInventoryCost(row, actualCostforRow)) continue;
                if (!voucher) {
                    this.addErrorMessage(checkCostEntity, ResManager.loadKDString((String)"\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5b58\u8d27\u6210\u672c\u4e0e\u5b58\u8d27\u6838\u7b97\u7684\u5b9e\u9645\u6210\u672c\u4e0d\u7b49\uff0c\u8bf7\u91cd\u65b0\u83b7\u53d6\u6210\u672c\u3002", (String)"RevInventoryCostCheckValidator_3", (String)"fi-ar-opplugin", (Object[])new Object[]{seq}));
                    continue;
                }
                this.addErrorMessage(checkCostEntity, ResManager.loadKDString((String)"\u660e\u7ec6\u7b2c%s\u884c\uff0c\u5b58\u8d27\u6210\u672c\u4e0e\u5b58\u8d27\u6838\u7b97\u7684\u5b9e\u9645\u6210\u672c\u4e0d\u7b49\uff0c\u4e14\u5355\u636e\u5df2\u751f\u6210\u51ed\u8bc1\uff0c1\uff09\u5982\u9700\u91cd\u65b0\u83b7\u53d6\uff0c\u8bf7\u5220\u9664\u51ed\u8bc1\u30022\uff09\u82e5\u65e0\u9700\u91cd\u65b0\u83b7\u53d6\uff0c\u8bf7\u5ffd\u7565\u3002", (String)"RevInventoryCostCheckValidator_4", (String)"fi-ar-opplugin", (Object[])new Object[]{seq}));
            }
        }
    }

    private boolean sameInventoryCost(DynamicObject row, Map<Long, BigDecimal> actualCostforRow) {
        boolean same = true;
        long id = row.getLong("id");
        BigDecimal rowInventoryCost = row.getBigDecimal("e_inventorycost");
        BigDecimal actualCost = actualCostforRow.get(id);
        if (actualCost == null) {
            return same;
        }
        if (actualCost.compareTo(rowInventoryCost) != 0) {
            same = false;
        }
        return same;
    }

    private Map<Long, BigDecimal> getActualCost(List<Long> revCfmIds) {
        QFilter revCfmIdFilter = new QFilter("entry.e_billid", "in", revCfmIds);
        QFilter billTypeFilter = new QFilter("entry.e_billtype", "=", (Object)"ar_revcfmbill");
        QFilter commonFilter = ArApXDBHelper.getVerifyRecordXDBFilter((String)"ar_revcfmbill", (Object[])revCfmIds.toArray(new Long[0]), (boolean)true);
        DynamicObject[] verifyRecords = BusinessDataServiceHelper.load((String)"ar_verifyrecord", (String)"id,billid,entry.e_billentryid", (QFilter[])new QFilter[]{revCfmIdFilter, billTypeFilter, commonFilter});
        ArrayList<Long> verifyRecordIds = new ArrayList<Long>(10);
        HashMap<Long, ArrayList<Long>> revCfmEntryMap = new HashMap<Long, ArrayList<Long>>(8);
        ArrayList<Long> mainBillIds = new ArrayList<Long>(8);
        for (DynamicObject verifyRecord : verifyRecords) {
            mainBillIds.add(verifyRecord.getLong("billid"));
            long id = verifyRecord.getLong("id");
            verifyRecordIds.add(id);
            for (DynamicObject row : verifyRecord.getDynamicObjectCollection("entry")) {
                ArrayList<Long> entryIds = (ArrayList<Long>)revCfmEntryMap.get(id);
                if (entryIds == null) {
                    entryIds = new ArrayList<Long>(2);
                }
                entryIds.add(row.getLong("e_billentryid"));
                revCfmEntryMap.put(id, entryIds);
            }
        }
        Map verifyRecordActualCost = VerifyServiceHelper.getCostRecordActualCost(verifyRecordIds, mainBillIds);
        HashMap<Long, BigDecimal> revCfmEntryCostMap = new HashMap<Long, BigDecimal>(8);
        for (Long verifyRecordId : verifyRecordIds) {
            Map costMap = (Map)verifyRecordActualCost.get(verifyRecordId);
            if (costMap == null) continue;
            BigDecimal actualCost = (BigDecimal)costMap.get("actualCost");
            List entryIds = (List)revCfmEntryMap.get(verifyRecordId);
            for (Long entryId : entryIds) {
                BigDecimal actualCostTemp = (BigDecimal)revCfmEntryCostMap.get(entryId);
                if (actualCostTemp == null) {
                    actualCostTemp = BigDecimal.ZERO;
                }
                revCfmEntryCostMap.put(entryId, actualCost.add(actualCostTemp));
            }
        }
        return revCfmEntryCostMap;
    }
}

