/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.mservice.helper.VerifyServiceHelper;
import kd.fi.arapcommon.helper.ArApXDBHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;

public class RevInventoryCostValidator
extends AbstractValidator {
    private static final String NONE = "none";
    private static final String PART = "part";
    private static final String COMPLETE = "complete";

    public void validate() {
        ExtendedDataEntity[] dataEntityArr = this.dataEntities;
        List<Long> revcfmIds = Arrays.asList(dataEntityArr).stream().map(ExtendedDataEntity::getDataEntity).map(entity -> entity.getLong("id")).collect(Collectors.toList());
        String inventoryCostWeakCheck = StdConfig.get((String)"inventoryCostWeakCheck");
        Map<Object, Object> inventoryResult = new HashMap(16);
        if (!"true".equals(inventoryCostWeakCheck)) {
            inventoryResult = this.revInventoryCostResult(revcfmIds);
        }
        for (ExtendedDataEntity dataEntity : dataEntityArr) {
            DynamicObject entity2 = dataEntity.getDataEntity();
            boolean voucher = entity2.getBoolean("isvoucher");
            boolean hadWrittenOff = entity2.getBoolean("hadwrittenoff");
            boolean isWrittenOff = entity2.getBoolean("iswrittenoff");
            String verifyStatus = entity2.getString("verifystatus");
            long id = entity2.getLong("id");
            if (hadWrittenOff) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u51b2\u9500\u7684\u6536\u5165\u786e\u8ba4\u5355\u4e0d\u5141\u8bb8\u83b7\u53d6\u6210\u672c\u3002", (String)"RevInventoryCostValidator_4", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (isWrittenOff) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u51b2\u9500\u7684\u6536\u5165\u786e\u8ba4\u5355\u4e0d\u5141\u8bb8\u83b7\u53d6\u6210\u672c\u3002", (String)"RevInventoryCostValidator_5", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (voucher) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5df2\u751f\u6210\u51ed\u8bc1\u7684\u6536\u5165\u786e\u8ba4\u5355\u65e0\u6cd5\u83b7\u53d6\u6210\u672c\u3002", (String)"RevInventoryCostValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                continue;
            }
            if ("unverify".equals(verifyStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u4e0d\u5b58\u5728\u6838\u9500\u8bb0\u5f55\uff0c\u65e0\u6cd5\u83b7\u53d6\u6210\u672c\u3002", (String)"RevInventoryCostValidator_1", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (!"verified".equals(verifyStatus)) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6536\u5165\u786e\u8ba4\u5355\u6838\u9500\u72b6\u6001\u672a\u5b8c\u5168\u6838\u9500\uff0c\u65e0\u6cd5\u83b7\u53d6\u6210\u672c\u3002", (String)"RevInventoryCostValidator_2", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                continue;
            }
            if ("true".equals(inventoryCostWeakCheck)) continue;
            if (NONE.equals(inventoryResult.get(id))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8fdb\u884c\u51fa\u5e93\u6838\u7b97\u540e\u518d\u5c1d\u8bd5\u83b7\u53d6\u6210\u672c\u3002", (String)"RevInventoryCostValidator_3", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            }
            if (!PART.equals(inventoryResult.get(id))) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6838\u7b97\u6210\u672c\u8bb0\u5f55\u6838\u9500\u62c6\u5355\u672a\u5b8c\u6210\uff0c\u83b7\u53d6\u6210\u672c\u5931\u8d25\uff0c\u8bf7\u7a0d\u540e\u91cd\u8bd5\u3002", (String)"RevInventoryCostValidator_6", (String)"fi-ar-opplugin", (Object[])new Object[0]));
        }
    }

    private Map<Long, String> revInventoryCostResult(List<Long> revcfmIds) {
        QFilter filter = new QFilter("entry.e_billid", "in", revcfmIds);
        filter.and(new QFilter("entry.e_billtype", "=", (Object)"ar_revcfmbill"));
        filter.and(new QFilter("billtype", "=", (Object)"im_saloutbill"));
        filter.and(new QFilter("producttype", "!=", (Object)"kitparent"));
        QFilter commonFilter = ArApXDBHelper.getVerifyRecordXDBFilter((String)"ar_revcfmbill", (Object[])revcfmIds.toArray(), (boolean)true);
        filter.and(commonFilter);
        DynamicObjectCollection dataList = QueryServiceHelper.query((String)"cal_salwfrecord", (String)"id as verifyId,billdate,entry.e_billid as revcfmId,billid as mainBillId", (QFilter[])new QFilter[]{filter});
        HashMap<Long, HashSet<Long>> revcfmToVerifyMap = new HashMap<Long, HashSet<Long>>(16);
        HashMap<Long, ArrayList<Long>> mainId2VrIdMap = new HashMap<Long, ArrayList<Long>>(16);
        HashMap<Long, Date> mainBizDateMap = new HashMap<Long, Date>(16);
        for (DynamicObject entity : dataList) {
            long verifyId = entity.getLong("verifyId");
            long revcfmId = entity.getLong("revcfmId");
            Long mainBillId = entity.getLong("mainBillId");
            mainBizDateMap.put(mainBillId, entity.getDate("billdate"));
            ArrayList<Long> verifyRds = (ArrayList<Long>)mainId2VrIdMap.get(mainBillId);
            if (verifyRds == null) {
                verifyRds = new ArrayList<Long>(16);
                verifyRds.add(verifyId);
                mainId2VrIdMap.put(mainBillId, verifyRds);
            } else {
                verifyRds.add(verifyId);
            }
            HashSet<Long> verifyIdList = (HashSet<Long>)revcfmToVerifyMap.get(revcfmId);
            if (EmptyUtils.isEmpty((Object)verifyIdList)) {
                verifyIdList = new HashSet<Long>(16);
            }
            verifyIdList.add(verifyId);
            revcfmToVerifyMap.put(revcfmId, verifyIdList);
        }
        Map verifyBaseUnitCost = VerifyServiceHelper.getBaseUnitActualCostByBatch(mainId2VrIdMap, mainBizDateMap);
        HashMap<Long, String> costResult = new HashMap<Long, String>(16);
        for (Long revcfmId : revcfmIds) {
            Set verifyIds = (Set)revcfmToVerifyMap.get(revcfmId);
            String containsCost = this.containsVerifyCost(verifyIds, verifyBaseUnitCost);
            costResult.put(revcfmId, containsCost);
        }
        return costResult;
    }

    private String containsVerifyCost(Set<Long> verifyIds, Map<Long, BigDecimal> verifyCostMap) {
        if (EmptyUtils.isEmpty(verifyIds)) {
            return NONE;
        }
        HashSet<Long> hadCost = new HashSet<Long>(16);
        for (Long verifyId : verifyIds) {
            BigDecimal inventoryCost = verifyCostMap.get(verifyId);
            if (inventoryCost == null) continue;
            hadCost.add(verifyId);
        }
        if (hadCost.size() == 0) {
            return NONE;
        }
        if (hadCost.size() < verifyIds.size()) {
            return PART;
        }
        return COMPLETE;
    }
}

