/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.util.ArrayList;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;

public class RevcfmBillWriteOffValidator
extends AbstractValidator {
    public void validate() {
        HashMap<Long, String> nonAuditSrcBillNos = new HashMap<Long, String>(16);
        HashMap<Long, String> hadWriteOffSrcBillNos = new HashMap<Long, String>(16);
        ArrayList<Long> srcBillIds = new ArrayList<Long>(16);
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            boolean iswrittenoff = bill.getBoolean("iswrittenoff");
            if (!iswrittenoff) continue;
            srcBillIds.add(bill.getLong("sourcebillid"));
        }
        if (srcBillIds.size() == 0) {
            return;
        }
        DynamicObjectCollection srcBills = QueryServiceHelper.query((String)"ar_revcfmbill", (String)"id,billno,billstatus,hadwrittenoff", (QFilter[])new QFilter[]{new QFilter("id", "in", srcBillIds)});
        for (DynamicObject srcBill : srcBills) {
            String billNo = srcBill.getString("billno");
            if (!"C".equals(srcBill.getString("billstatus"))) {
                nonAuditSrcBillNos.put(srcBill.getLong("id"), billNo);
                continue;
            }
            if (!srcBill.getBoolean("hadwrittenoff")) continue;
            hadWriteOffSrcBillNos.put(srcBill.getLong("id"), billNo);
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject bill = dataEntity.getDataEntity();
            Long srcId = bill.getLong("sourcebillid");
            boolean iswrittenoff = bill.getBoolean("iswrittenoff");
            if (!iswrittenoff) continue;
            if (nonAuditSrcBillNos.get(srcId) != null) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u88ab\u51b2\u9500\u7684\u5355\u636e%s\u4e0d\u662f\u5ba1\u6838\u6001\uff0c\u4e0d\u80fd\u51b2\u9500\u3002", (String)"RevcfmBillWriteOffValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[]{nonAuditSrcBillNos.get(srcId)}));
                continue;
            }
            if (hadWriteOffSrcBillNos.get(srcId) == null) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u5355\u636e%s\u5df2\u88ab\u51b2\u9500\uff0c\u4e0d\u80fd\u91cd\u590d\u51b2\u9500\u3002", (String)"RevcfmBillWriteOffValidator_1", (String)"fi-ar-opplugin", (Object[])new Object[]{hadWriteOffSrcBillNos.get(srcId)}));
        }
    }
}

