/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.util.HashMap;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.coderule.CodeRuleServiceHelper;
import kd.fi.ar.helper.SystemParameterHelper;

public class SaleInvoiceAuditValidator
extends AbstractValidator {
    private Map<String, Boolean> hasNumberMap = new HashMap<String, Boolean>();

    public void validate() {
        ExtendedDataEntity[] datas = this.getDataEntities();
        HashMap<Long, Boolean> paramMap = new HashMap<Long, Boolean>(8);
        for (ExtendedDataEntity data : datas) {
            long orgId;
            boolean autopush;
            DynamicObject finBill = data.getDataEntity();
            String sourceBillType = finBill.getString("sourcebilltype");
            if ("ar_finarbill".equals(sourceBillType) || "ar_invoice".equals(sourceBillType) || !(autopush = paramMap.computeIfAbsent(orgId = finBill.getLong("org.id"), e -> SystemParameterHelper.getParameterBoolean((long)orgId, (String)"ar_001")).booleanValue()) || this.hasNumber("ar_finarbill", orgId)) continue;
            this.addMessage(data, ResManager.loadKDString((String)"\u4e0b\u6e38\u5355\u636e\u6ca1\u6709\u7f16\u7801\u89c4\u5219\uff0c\u65e0\u6cd5\u751f\u6210\u76f8\u5e94\u5355\u636e\u3002", (String)"SaleInvoiceAuditValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
        }
    }

    private boolean hasNumber(String entityKey, long orgPk) {
        String key = entityKey + "-" + orgPk;
        if (this.hasNumberMap.get(key) != null) {
            return this.hasNumberMap.get(key);
        }
        DynamicObject newBill = BusinessDataServiceHelper.newDynamicObject((String)entityKey);
        boolean hasNumber = CodeRuleServiceHelper.isExist((String)entityKey, (DynamicObject)newBill, (String)String.valueOf(orgPk));
        this.hasNumberMap.put(key, hasNumber);
        return hasNumber;
    }
}

