/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.enums.SettleBillTypeEnum;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.util.StdConfig;

public class UnSettleValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] entities = this.getDataEntities();
        if (entities.length > 1) {
            for (ExtendedDataEntity entity : entities) {
                DynamicObject settleRecord = entity.getDataEntity();
                if (!settleRecord.getBoolean("iswrittenoff")) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u7ea2\u51b2\u751f\u6210\u7684\u7ed3\u7b97\u8bb0\u5f55\u4e0d\u5141\u8bb8\u6279\u91cf\u53cd\u7ed3\u7b97\u3002", (String)"UnSettleValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            }
        }
        HashMap<String, Set<Long>> billIdInfoMap = new HashMap<String, Set<Long>>(3);
        for (ExtendedDataEntity entity : entities) {
            DynamicObject settleRecord = entity.getDataEntity();
            this.setIdMapInfo(billIdInfoMap, settleRecord.getString("billentity"), settleRecord.getLong("mainbillid"));
            for (DynamicObject row : settleRecord.getDynamicObjectCollection("entry")) {
                this.setIdMapInfo(billIdInfoMap, row.getString("e_billentity"), row.getLong("billid"));
            }
        }
        Set<Long> existIds = this.getExistIds(billIdInfoMap);
        if (ObjectUtils.isEmpty(existIds)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6240\u9009\u7ed3\u7b97\u8bb0\u5f55\u7684\u4e3b\u8f85\u65b9\u5355\u636e\u5747\u88ab\u5220\u9664\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u7b97\u3002", (String)"UnSettleValidator_1", (String)"fi-ar-opplugin", (Object[])new Object[0]));
        }
        for (ExtendedDataEntity dataEntity : this.dataEntities) {
            DynamicObject settleRecord = dataEntity.getDataEntity();
            if (!existIds.contains(settleRecord.getLong("mainbillid"))) {
                String billNo = settleRecord.getString("billno");
                String message = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a%s\u7684\u5355\u636e\u5df2\u5220\u9664\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u7b97\u76f8\u5173\u7ed3\u7b97\u8bb0\u5f55\u3002", (String)"UnSettleValidator_2", (String)"fi-ar-opplugin", (Object[])new Object[0]), billNo);
                this.addErrorMessage(dataEntity, message);
            }
            DynamicObjectCollection entry = settleRecord.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                if (existIds.contains(row.getLong("billid"))) continue;
                String billNo = row.getString("billnum");
                String message = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e3a%s\u7684\u5355\u636e\u5df2\u5220\u9664\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u7b97\u76f8\u5173\u7ed3\u7b97\u8bb0\u5f55\u3002", (String)"UnSettleValidator_2", (String)"fi-ar-opplugin", (Object[])new Object[0]), billNo);
                this.addErrorMessage(dataEntity, message);
            }
        }
        HashSet<Long> billIdSet = new HashSet<Long>(8);
        HashSet<Long> billEntryIdSet = new HashSet<Long>(8);
        for (ExtendedDataEntity dataEntity : entities) {
            DynamicObject entity = dataEntity.getDataEntity();
            if (!SettleRelationEnum.PAYRECSETTLE.getValue().equals(entity.getString("settlerelation")) || !"cas_paybill".equals(entity.getString("billentity"))) continue;
            billIdSet.add(entity.getLong("mainbillid"));
            billEntryIdSet.add(entity.getLong("mainbillentryid"));
        }
        Map<Long, List<Long>> payBillFinApMap = new HashMap<Long, List<Long>>(8);
        if (billIdSet.size() > 0) {
            payBillFinApMap = BOTPHelper.loadNearUpBillIds((String)"cas_paybill", (String)"entry", (Long[])billIdSet.toArray(new Long[0]), (Long[])billEntryIdSet.toArray(new Long[0]), (String)"ap_finapbill");
        }
        Map<Long, DynamicObject> refundRecordMap = this.getRefundRecordMap(payBillFinApMap);
        for (ExtendedDataEntity entity : entities) {
            DynamicObject object = entity.getDataEntity();
            if ("fromeas".equals(object.getString("settletype"))) {
                this.addMessage(entity, ResManager.loadKDString((String)"\u7ed3\u7b97\u8bb0\u5f55\u4e3aEAS\u96c6\u6210\u7684\u6570\u636e\uff0c\u4e3a\u4fdd\u8bc1\u6570\u636e\u4e00\u81f4\u6027\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u7b97\u3002", (String)"UnSettleValidator_23", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                continue;
            }
            DynamicObjectCollection entry = object.getDynamicObjectCollection("entry");
            String settlerelation = object.getString("settlerelation");
            String autoSettleType = object.getString("autosettletype");
            if (!"true".equals(StdConfig.get((String)"allowBotpUsettle")) && "1".equals(autoSettleType)) {
                if (SettleRelationEnum.RECSETTLE.getValue().equals(settlerelation)) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7ed3\u7b97\u5173\u7cfb\u4e3a\u201c\u5e94\u6536\u6536\u6b3e\u201d\u5e76\u4e14\u4e3b\u8f85\u65b9\u5355\u636e\u5b58\u5728\u5173\u8054\u5173\u7cfb\u7684\u7ed3\u7b97\u8bb0\u5f55\uff0c\u53ea\u80fd\u901a\u8fc7\u5bf9\u6536\u6b3e\u5355\u53d6\u6d88\u6536\u6b3e\u8fdb\u884c\u53cd\u7ed3\u7b97\u3002", (String)"UnSettleValidator_16", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                    continue;
                }
                if (SettleRelationEnum.ARPAYSETTLE.getValue().equals(settlerelation)) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7ed3\u7b97\u5173\u7cfb\u4e3a\u201c\u5e94\u6536\u9000\u6b3e\u201d\u5e76\u4e14\u4e3b\u8f85\u65b9\u5355\u636e\u5b58\u5728\u5173\u8054\u5173\u7cfb\u7684\u7ed3\u7b97\u8bb0\u5f55\uff0c\u53ea\u80fd\u901a\u8fc7\u5bf9\u4ed8\u6b3e\u5355\u53d6\u6d88\u4ed8\u6b3e\u8fdb\u884c\u53cd\u7ed3\u7b97\u3002", (String)"UnSettleValidator_17", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                    continue;
                }
            }
            if ("5".equals(autoSettleType)) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7ed3\u7b97\u5173\u7cfb\u4e3a\u201c\u5e94\u6536\u6536\u6b3e\u201d\u4e14\u8f85\u65b9\u5355\u636e\u7ecf\u6536\u6b3e\u8ba4\u9886\u6309\u6838\u5fc3\u5355\u636e\u81ea\u52a8\u7ed3\u7b97\u7684\u7ed3\u7b97\u8bb0\u5f55\uff0c\u53ea\u80fd\u901a\u8fc7\u5bf9\u6536\u6b3e\u5355\u53d6\u6d88\u6536\u6b3e\u8fdb\u884c\u53cd\u7ed3\u7b97\u3002", (String)"UnSettleValidator_20", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                continue;
            }
            if (SettleRelationEnum.PAYRECSETTLE.getValue().equals(settlerelation)) {
                Long mainBillId = object.getLong("mainbillid");
                List<Long> finApBillIds = payBillFinApMap.get(mainBillId);
                if (finApBillIds != null && finApBillIds.size() > 0) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7ed3\u7b97\u5173\u7cfb\u4e3a\u201c\u4ed8\u6b3e\u51b2\u6536\u6b3e\u201d\u5e76\u4e14\u4ed8\u6b3e\u5355\u4e0a\u6e38\u5b58\u5728\u8d22\u52a1\u5e94\u4ed8\u5355\u7684\u9000\u6b3e\u9000\u7968\u4e1a\u52a1\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u7b97\u3002", (String)"UnSettleValidator_19", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                    continue;
                }
                boolean hasRefundRecord = false;
                for (DynamicObject asstEntry : entry) {
                    if (ObjectUtils.isEmpty((Object)refundRecordMap.get(asstEntry.getLong("billid")))) continue;
                    hasRefundRecord = true;
                    break;
                }
                String settleType = object.getString("settletype");
                if (hasRefundRecord || "auto".equals(settleType)) {
                    this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7ed3\u7b97\u5173\u7cfb\u4e3a\u201c\u4ed8\u6b3e\u51b2\u6536\u6b3e\u201d\u5e76\u4e14\u7ed3\u7b97\u8bb0\u5f55\u4e3a\u9000\u6b3e\u9000\u7968\u4e1a\u52a1\u751f\u6210\u7684\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u7b97\u3002", (String)"UnSettleValidator_22", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                    continue;
                }
            }
            if (!ObjectUtils.isEmpty((Object)object) && Objects.equals(object.getString("settlerelation"), SettleRelationEnum.ARWRITEOFF.getValue())) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7ed3\u7b97\u5173\u7cfb\u4e3a\u201c\u5e94\u6536\u7ea2\u84dd\u51b2\u9500\u201d\u7684\u7ed3\u7b97\u8bb0\u5f55\uff0c\u53ea\u80fd\u901a\u8fc7\u53cd\u5ba1\u6838\u8f85\u65b9\u5355\u636e\u53cd\u7ed3\u7b97\u3002", (String)"UnSettleValidator_6", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            }
            if (Objects.equals(object.getString("settlerelation"), SettleRelationEnum.BADDEBTLOSS.getValue())) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7ed3\u7b97\u5173\u7cfb\u4e3a\u201c\u574f\u8d26\u635f\u5931\u201d\u7684\u7ed3\u7b97\u8bb0\u5f55\uff0c\u53ea\u80fd\u901a\u8fc7\u53cd\u5ba1\u6838\u8f85\u65b9\u5355\u636e\u53cd\u7ed3\u7b97\u3002", (String)"UnSettleValidator_7", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            }
            if (!ObjectUtils.isEmpty((Object)object) && Objects.equals(object.getString("settlerelation"), SettleRelationEnum.ARTRANSFER.getValue())) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7ed3\u7b97\u5173\u7cfb\u4e3a\u201c\u503a\u6743\u8f6c\u79fb\u201d\u7684\u7ed3\u7b97\u8bb0\u5f55\uff0c\u53ea\u80fd\u901a\u8fc7\u53cd\u5ba1\u6838\u8f85\u65b9\u5355\u636e\u53cd\u7ed3\u7b97\u3002", (String)"UnSettleValidator_8", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            }
            if (Objects.equals(object.getString("settlerelation"), SettleRelationEnum.ARPREMSETTLE.getValue())) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7ed3\u7b97\u5173\u7cfb\u4e3a\u201c\u8f6c\u51fa\u8d28\u4fdd\u91d1\u201d\u7684\u7ed3\u7b97\u8bb0\u5f55\uff0c\u53ea\u80fd\u901a\u8fc7\u53cd\u5ba1\u6838\u8f85\u65b9\u5355\u636e\u53cd\u7ed3\u7b97\u3002", (String)"UnSettleValidator_21", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                continue;
            }
            for (DynamicObject row : entry) {
                String billType = row.getString("billtype");
                if (!SettleBillTypeEnum.LIQUIDATION.getValue().equals(billType)) continue;
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u201c\u672a\u6e05\u9879\u6e05\u7406\u5355\u201d\u751f\u6210\u7684\u7ed3\u7b97\u8bb0\u5f55\u53ea\u80fd\u901a\u8fc7\u201c\u53cd\u5ba1\u6838\u201d\u6765\u53cd\u7ed3\u7b97\u3002", (String)"UnSettleValidator_15", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                break;
            }
            if (object.getBoolean("iswrittenoff")) {
                BigDecimal mainTotalSettleaAmt;
                BigDecimal mainBillUnamount;
                Object row2;
                QFilter mainIdFilter;
                long mainBillId = object.getLong("mainbillid");
                String mainBillEntity = object.getString("billentity");
                DynamicObject mainBillStatus = QueryServiceHelper.queryOne((String)mainBillEntity, (String)"billstatus", (QFilter[])new QFilter[]{mainIdFilter = new QFilter("id", "=", (Object)mainBillId)});
                if (ObjectUtils.isEmpty((Object)mainBillStatus)) continue;
                if (!("C".equals(mainBillStatus.getString("billstatus")) || "cas_paybill".equals(mainBillEntity) || "cas_recbill".equals(mainBillEntity))) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e3b\u65b9\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u5df2\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u7b97\u3002", (String)"UnSettleValidator_3", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                }
                if (!"D".equals(mainBillStatus.getString("billstatus")) && "cas_recbill".equals(mainBillEntity)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e3b\u65b9\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u5df2\u6536\u6b3e\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u7b97\u3002", (String)"UnSettleValidator_13", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                }
                if (!"D".equals(mainBillStatus.getString("billstatus")) && "cas_paybill".equals(mainBillEntity)) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e3b\u65b9\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u5df2\u4ed8\u6b3e\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u7b97\u3002", (String)"UnSettleValidator_14", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                }
                HashMap<String, Set<Long>> entryIdMap = new HashMap<String, Set<Long>>(entry.size());
                for (Object row2 : entry) {
                    String billEntity = row2.getString("e_billentity");
                    long billId = row2.getLong("billid");
                    this.setIdMapInfo(entryIdMap, billEntity, billId);
                }
                Set entryIdEntries = entryIdMap.entrySet();
                row2 = entryIdEntries.iterator();
                while (row2.hasNext()) {
                    Map.Entry entryIdEntry = (Map.Entry)row2.next();
                    String key = (String)entryIdEntry.getKey();
                    Set value = (Set)entryIdEntry.getValue();
                    QFilter idFilter = new QFilter("id", "in", (Object)value);
                    DynamicObjectCollection billStatusList = this.getBillFields(key, "billstatus", idFilter);
                    for (DynamicObject billStatus : billStatusList) {
                        if (!("C".equals(billStatus.getString("billstatus")) || "cas_paybill".equals(key) || "cas_recbill".equals(key))) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u8f85\u65b9\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u5df2\u5ba1\u6838\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u7b97\u3002", (String)"UnSettleValidator_4", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                        }
                        if (!"D".equals(billStatus.getString("billstatus")) && "cas_recbill".equals(key)) {
                            throw new KDBizException(ResManager.loadKDString((String)"\u8f85\u65b9\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u5df2\u6536\u6b3e\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u7b97\u3002", (String)"UnSettleValidator_9", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                        }
                        if ("D".equals(billStatus.getString("billstatus")) || !"cas_paybill".equals(key)) continue;
                        throw new KDBizException(ResManager.loadKDString((String)"\u8f85\u65b9\u5355\u636e\u72b6\u6001\u4e0d\u7b49\u4e8e\u5df2\u4ed8\u6b3e\uff0c\u4e0d\u5141\u8bb8\u53cd\u7ed3\u7b97\u3002", (String)"UnSettleValidator_10", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                    }
                }
                String mainSettleEntry = object.getString("settleentry");
                long mainBillEntryId = object.getLong("mainbillentryid");
                String mainEntryEntityKey = this.getEntryEntityKey(mainBillEntity, mainSettleEntry);
                String mainEntryAmountField = this.getEntryAmountField(mainBillEntity, mainSettleEntry);
                QFilter mainEntryFilter = new QFilter(mainEntryEntityKey + ".id", "=", (Object)mainBillEntryId);
                DynamicObject mainBill = QueryServiceHelper.queryOne((String)mainBillEntity, (String)(mainEntryEntityKey + "." + mainEntryAmountField), (QFilter[])new QFilter[]{mainEntryFilter});
                if (ObjectUtils.isEmpty((Object)mainBill)) continue;
                BigDecimal mainAmount = object.getBigDecimal("mainpayableamt");
                if (this.isOverQuota(mainAmount, mainBillUnamount = mainBill.getBigDecimal(mainEntryEntityKey + "." + mainEntryAmountField), mainTotalSettleaAmt = object.getBigDecimal("totalsettleamt").negate())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4e3b\u65b9\u5355\u636e\u5df2\u7ed3\u7b97\u91d1\u989d\u9700\u5c0f\u4e8e\u7b49\u4e8e\u5355\u636e\u5e94\u6536\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u540e\u64cd\u4f5c\u3002", (String)"UnSettleValidator_11", (String)"fi-ap-opplugin", (Object[])new Object[0]));
                }
                HashMap<String, Set<Long>> billEntryIdMap = new HashMap<String, Set<Long>>(entry.size());
                HashMap<String, String> settleMap = new HashMap<String, String>(2);
                for (DynamicObject row3 : entry) {
                    String billEntity = row3.getString("e_billentity");
                    long billId = row3.getLong("billentryid");
                    this.setIdMapInfo(billEntryIdMap, billEntity, billId);
                    settleMap.put(billEntity, row3.getString("e_settleentry"));
                }
                Set billEntryIdEntries = billEntryIdMap.entrySet();
                for (Map.Entry billEntryIdEntry : billEntryIdEntries) {
                    String key = (String)billEntryIdEntry.getKey();
                    Set value = (Set)billEntryIdEntry.getValue();
                    String sellteEntry = (String)settleMap.get(key);
                    String entryEntityKey = this.getEntryEntityKey(key, sellteEntry);
                    String entryAmountField = this.getEntryAmountField(key, sellteEntry);
                    QFilter entryFilter = new QFilter(entryEntityKey + ".id", "in", (Object)value);
                    DynamicObjectCollection bills = this.getBillFields(key, entryEntityKey + ".id," + entryEntityKey + "." + entryAmountField, entryFilter);
                    for (DynamicObject bill : bills) {
                        for (DynamicObject row4 : entry) {
                            BigDecimal amount = row4.getBigDecimal("payableamt");
                            BigDecimal billUnamount = bill.getBigDecimal(entryEntityKey + "." + entryAmountField);
                            BigDecimal totalSettleaAmt = row4.getBigDecimal("settleamt").negate();
                            if (bill.getLong(entryEntityKey + ".id") != row4.getLong("billentryid") || !this.isOverQuota(amount, billUnamount, totalSettleaAmt)) continue;
                            throw new KDBizException(ResManager.loadKDString((String)"\u8f85\u65b9\u5355\u636e\u5df2\u7ed3\u7b97\u91d1\u989d\u9700\u5c0f\u4e8e\u7b49\u4e8e\u5355\u636e\u5e94\u6536\u91d1\u989d\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u540e\u64cd\u4f5c\u3002", (String)"UnSettleValidator_12", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                        }
                    }
                }
            }
            if (object.getBoolean("hadwrittenoff")) {
                this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7ed3\u7b97\u8bb0\u5f55\u5df2\u88ab\u7ea2\u51b2\uff0c\u65e0\u6cd5\u53cd\u7ed3\u7b97\u3002", (String)"UnSettleValidator_5", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                continue;
            }
            boolean result = false;
            if (entry.size() <= 1) continue;
            for (DynamicObject entry0 : entry) {
                boolean hadWriteOff = entry0.getBoolean("e_hadwrittenoff");
                if (!hadWriteOff) continue;
                result = true;
                break;
            }
            if (!result) continue;
            this.addErrorMessage(entity, ResManager.loadKDString((String)"\u7ed3\u7b97\u8bb0\u5f55\u7684\u8f85\u65b9\u5b58\u5728\u88ab\u7ea2\u51b2\u548c\u9700\u8981\u53cd\u7ed3\u7b97\u7684\u6570\u636e\uff0c\u4e0d\u5141\u8bb8\u7ed3\u7b97\u8bb0\u5f55\u53cd\u7ed3\u7b97\uff0c\u8bf7\u53cd\u64cd\u4f5c\u9700\u8981\u53cd\u7ed3\u7b97\u7684\u8f85\u65b9\u5355\u636e\u3002", (String)"UnSettleValidator_18", (String)"fi-ar-opplugin", (Object[])new Object[0]));
        }
    }

    private Map<Long, DynamicObject> getRefundRecordMap(Map<Long, List<Long>> payBillFinApMap) {
        HashSet<Long> recBillIds = new HashSet<Long>(8);
        for (ExtendedDataEntity entity : this.dataEntities) {
            DynamicObject bill = entity.getDataEntity();
            Long mainBillId = bill.getLong("mainbillid");
            String settlerelation = bill.getString("settlerelation");
            if (!SettleRelationEnum.PAYRECSETTLE.getValue().equals(settlerelation) || !ObjectUtils.isEmpty(payBillFinApMap.get(mainBillId))) continue;
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject asstEntry : entry) {
                recBillIds.add(asstEntry.getLong("billid"));
            }
        }
        HashMap<Long, DynamicObject> refundRecordMap = new HashMap<Long, DynamicObject>(8);
        if (!recBillIds.isEmpty()) {
            DynamicObject[] refundRecords;
            for (DynamicObject refundRecord : refundRecords = BusinessDataServiceHelper.load((String)"ap_refundrenote_record", (String)"id,recbillid", (QFilter[])new QFilter[]{new QFilter("recbillid", "in", recBillIds)})) {
                refundRecordMap.put(refundRecord.getLong("recbillid"), refundRecord);
            }
        }
        return refundRecordMap;
    }

    private boolean isOverQuota(BigDecimal priceandTaxTotal, BigDecimal billUnamount, BigDecimal totalSettleaAmt) {
        return priceandTaxTotal.multiply(billUnamount.subtract(totalSettleaAmt)).compareTo(BigDecimal.ZERO) < 0;
    }

    private Set<Long> getExistIds(Map<String, Set<Long>> map) {
        HashSet<Long> existIds = new HashSet<Long>(10);
        Set<Map.Entry<String, Set<Long>>> entries = map.entrySet();
        for (Map.Entry<String, Set<Long>> entry : entries) {
            String key = entry.getKey();
            Set<Long> value = entry.getValue();
            QFilter idFilter = new QFilter("id", "in", value);
            DynamicObjectCollection bills = QueryServiceHelper.query((String)key, (String)"id", (QFilter[])new QFilter[]{idFilter});
            if (bills.isEmpty()) continue;
            for (DynamicObject bill : bills) {
                existIds.add(bill.getLong("id"));
            }
        }
        return existIds;
    }

    private void setIdMapInfo(Map<String, Set<Long>> map, String entity, long id) {
        Set<Long> ids = map.get(entity);
        if (ids != null) {
            ids.add(id);
        } else {
            HashSet<Long> idSet = new HashSet<Long>(10);
            idSet.add(id);
            map.put(entity, idSet);
        }
    }

    private String getEntryEntityKey(String entity, String settleEntry) {
        if ("1".equals(settleEntry)) {
            if ("ar_finarbill".equals(entity)) {
                return "entry";
            }
            if ("ap_finapbill".equals(entity)) {
                return "detailentry";
            }
            if ("cas_recbill".equals(entity) || "cas_paybill".equals(entity) || "ar_receivedbill".equals(entity) || "ap_paidbill".equals(entity)) {
                return "entry";
            }
            if ("ar_baddebtlossbill".equals(entity)) {
                return "planentry";
            }
            if ("ar_liquidation".equals(entity)) {
                return "entryentity";
            }
        } else if ("ap_finapbill".equals(entity) || "ar_finarbill".equals(entity) || "ar_baddebtlossbill".equals(entity)) {
            return "planentity";
        }
        return "";
    }

    private String getEntryAmountField(String entity, String settleEntry) {
        if ("1".equals(settleEntry)) {
            if ("ar_finarbill".equals(entity)) {
                return "e_unlockamt";
            }
            if ("ap_finapbill".equals(entity)) {
                return "unlockamt";
            }
            if ("cas_recbill".equals(entity) || "cas_paybill".equals(entity) || "ar_receivedbill".equals(entity) || "ap_paidbill".equals(entity)) {
                return "e_unsettledamt";
            }
            if ("ar_baddebtlossbill".equals(entity)) {
                return "e_unlockamt";
            }
            if ("ar_liquidation".equals(entity)) {
                return "unsettleamt";
            }
        } else {
            if ("ap_finapbill".equals(entity) || "ar_finarbill".equals(entity)) {
                return "unplanlockamt";
            }
            if ("ar_baddebtlossbill".equals(entity)) {
                return "p_unlockamt";
            }
        }
        return "";
    }

    private DynamicObjectCollection getBillFields(String entity, String selectedFields, QFilter filter) {
        return QueryServiceHelper.query((String)entity, (String)selectedFields, (QFilter[])new QFilter[]{filter});
    }
}

