/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.fi.ar.mservice.helper.VerifyServiceHelper;

public class VerifyInventoryCostValidator
extends AbstractValidator {
    public void validate() {
        ExtendedDataEntity[] dataEntities;
        for (ExtendedDataEntity dataEntity : dataEntities = this.dataEntities) {
            String verifyRelation;
            DynamicObject entity2 = dataEntity.getDataEntity();
            boolean voucher = entity2.getBoolean("isvoucher");
            if (voucher) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6838\u9500\u8bb0\u5f55\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u65e0\u6cd5\u83b7\u53d6\u6210\u672c\u3002", (String)"VerifyInventoryCostValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            }
            if ("salself".equals(verifyRelation = entity2.getString("verifyrelation"))) {
                this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6838\u9500\u5173\u7cfb\u4e3a\u51fa\u5e93\u7ea2\u51b2\u7684\u6838\u9500\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u83b7\u53d6\u6210\u672c\u3002", (String)"VerifyInventoryCostValidator_1", (String)"fi-ar-opplugin", (Object[])new Object[0]));
            }
            if (!"arfinself".equals(verifyRelation)) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u6838\u9500\u5173\u7cfb\u4e3a\u6536\u5165\u786e\u8ba4\u7ea2\u51b2\u7684\u6838\u9500\u8bb0\u5f55\uff0c\u4e0d\u5141\u8bb8\u83b7\u53d6\u6210\u672c\u3002", (String)"VerifyInventoryCostValidator_2", (String)"fi-ar-opplugin", (Object[])new Object[0]));
        }
        List verifyRecordIds = Arrays.asList(this.getDataEntities()).stream().map(ExtendedDataEntity::getDataEntity).map(entity -> entity.getLong("id")).collect(Collectors.toList());
        List mainBillIds = Arrays.asList(this.getDataEntities()).stream().map(ExtendedDataEntity::getDataEntity).map(entity -> entity.getLong("billid")).collect(Collectors.toList());
        Map costMap = VerifyServiceHelper.getBaseUnitActualCost(verifyRecordIds, mainBillIds);
        for (ExtendedDataEntity dataEntity : dataEntities) {
            BigDecimal inventoryCost;
            DynamicObject entity3 = dataEntity.getDataEntity();
            long verifyRecordId = entity3.getLong("id");
            if (entity3.containsProperty("producttype") && "kitparent".equals(entity3.getString("producttype")) || (inventoryCost = (BigDecimal)costMap.get(verifyRecordId)) != null) continue;
            this.addErrorMessage(dataEntity, ResManager.loadKDString((String)"\u8bf7\u8fdb\u884c\u51fa\u5e93\u6838\u7b97\u540e\u518d\u5c1d\u8bd5\u83b7\u53d6\u6210\u672c\u3002", (String)"VerifyInventoryCostValidator_3", (String)"fi-ar-opplugin", (Object[])new Object[0]));
        }
    }
}

