/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.ExtendedDataEntity;
import kd.bos.entity.validate.AbstractValidator;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.validator.validatorService.ArValidatorService;
import kd.fi.arapcommon.service.buswoff.BusWrittenOffWoffFromFinar;
import kd.fi.arapcommon.util.StdConfig;

public class WrittenOffBillUnAuditValidator
extends AbstractValidator {
    public void validate() {
        Set<String> verifyRelations;
        long billId;
        ExtendedDataEntity[] datas = this.getDataEntities();
        HashMap<Long, Object> srcBillIdMap = new HashMap<Long, Object>(8);
        HashMap<Long, Long> srcFinIdToWrittenOff = new HashMap<Long, Long>(2);
        ArrayList<ExtendedDataEntity> writtenOffDatas = new ArrayList<ExtendedDataEntity>(datas.length);
        HashSet<Long> orgIds = new HashSet<Long>(2);
        for (ExtendedDataEntity data : datas) {
            DynamicObject dynamicObject = data.getDataEntity();
            if (!dynamicObject.getBoolean("iswrittenoff")) continue;
            writtenOffDatas.add(data);
            orgIds.add(dynamicObject.getLong("org.id"));
            String srcBillId = dynamicObject.getString("sourcebillid");
            long srcBillID = Long.parseLong(srcBillId);
            srcBillIdMap.put(srcBillID, data);
            srcFinIdToWrittenOff.put(srcBillID, dynamicObject.getLong("id"));
        }
        if (ObjectUtils.isEmpty(srcBillIdMap)) {
            return;
        }
        Set<Long> finArBillids = srcBillIdMap.keySet();
        BusWrittenOffWoffFromFinar writtenOffWoff = new BusWrittenOffWoffFromFinar();
        Map overfullSrcFinBillnoMap = writtenOffWoff.unAuditValidate(srcFinIdToWrittenOff);
        for (Map.Entry entry : overfullSrcFinBillnoMap.entrySet()) {
            this.addErrorMessage((ExtendedDataEntity)srcBillIdMap.get(entry.getKey()), String.format(ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u4f1a\u91cd\u65b0\u5360\u7528\u6682\u4f30\u5e94\u6536\u5355\u201c%1$s\u201d\u7684\u672a\u51b2\u56de\u6570\u91cf\u4e0e\u91d1\u989d\u3001\u672a\u786e\u8ba4\u5e94\u6536\u6570\u91cf\u4e0e\u91d1\u989d\uff0c\u989d\u5ea6\u4e0d\u8db3\uff0c\u53cd\u5ba1\u6838\u5931\u8d25\u3002", (String)"WrittenOffBillUnAuditValidator_3", (String)"fi-ar-opplugin", (Object[])new Object[0]), String.join((CharSequence)",", (Iterable)entry.getValue())));
        }
        this.arRevUnVerifyValidator(writtenOffDatas, finArBillids);
        QFilter revcfmFilter = new QFilter("org", "in", orgIds);
        revcfmFilter.and(new QFilter("sourcebillid", "in", finArBillids));
        DynamicObjectCollection dynamicObjectCollection = QueryServiceHelper.query((String)"ar_revcfmbill", (String)"id,sourcebillid", (QFilter[])revcfmFilter.toArray());
        if (ObjectUtils.isEmpty((Object)dynamicObjectCollection)) {
            return;
        }
        HashMap<Long, Long> revcfmIdMap = new HashMap<Long, Long>();
        HashSet<Long> revcfmBillIds = new HashSet<Long>(dynamicObjectCollection.size());
        for (DynamicObject revcfmBill : dynamicObjectCollection) {
            revcfmIdMap.put(revcfmBill.getLong("sourcebillid"), revcfmBill.getLong("id"));
            revcfmBillIds.add(revcfmBill.getLong("id"));
        }
        QFilter filterByMain = new QFilter("org", "in", orgIds);
        filterByMain.and(new QFilter("billid", "in", revcfmBillIds));
        DynamicObjectCollection verifyRecordsByMain = QueryServiceHelper.query((String)"ar_verifyrecord", (String)"verifyrelation,billid", (QFilter[])filterByMain.toArray());
        QFilter filterByAsst = new QFilter("org", "in", orgIds);
        filterByAsst.and(new QFilter("entry.e_billid", "in", revcfmBillIds));
        DynamicObjectCollection verifyRecordsByAsst = QueryServiceHelper.query((String)"ar_verifyrecord", (String)"verifyrelation,entry.e_billid", (QFilter[])filterByAsst.toArray());
        HashMap<Long, HashSet<String>> verifyRelationMap = new HashMap<Long, HashSet<String>>();
        if (ObjectUtils.isEmpty((Object)verifyRecordsByMain) && ObjectUtils.isEmpty((Object)verifyRecordsByAsst)) {
            return;
        }
        for (DynamicObject verifyRecord : verifyRecordsByMain) {
            billId = verifyRecord.getLong("billid");
            verifyRelations = (HashSet<String>)verifyRelationMap.get(billId);
            if (ObjectUtils.isEmpty((Object)verifyRelations)) {
                verifyRelations = new HashSet<String>();
            }
            verifyRelations.add(verifyRecord.getString("verifyrelation"));
            verifyRelationMap.put(billId, (HashSet<String>)verifyRelations);
        }
        for (DynamicObject verifyRecord : verifyRecordsByAsst) {
            billId = verifyRecord.getLong("entry.e_billid");
            verifyRelations = (Set)verifyRelationMap.get(billId);
            if (ObjectUtils.isEmpty(verifyRelations)) {
                verifyRelations = new HashSet();
            }
            verifyRelations.add(verifyRecord.getString("verifyrelation"));
            verifyRelationMap.put(billId, (HashSet<String>)verifyRelations);
        }
        for (ExtendedDataEntity writtenOffData : writtenOffDatas) {
            DynamicObject bill = writtenOffData.getDataEntity();
            String srcBillId = bill.getString("sourcebillid");
            Set verifyRelation = (Set)verifyRelationMap.get(revcfmIdMap.get(Long.parseLong(srcBillId)));
            if (ObjectUtils.isEmpty((Object)verifyRelation) || verifyRelation.size() <= 1) continue;
            this.addErrorMessage(writtenOffData, ResManager.loadKDString((String)"\u53c2\u4e0e\u6838\u9500\u5355\u636e\u7684\u51b2\u9500\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"WrittenOffBillUnAuditValidator_0", (String)"fi-ar-opplugin", (Object[])new Object[]{bill.getString("billno")}));
        }
    }

    private void arRevUnVerifyValidator(List<ExtendedDataEntity> datas, Set<Long> billPks) {
        block10: {
            DynamicObject[] records;
            ArValidatorService vService;
            block9: {
                vService = new ArValidatorService();
                records = BusinessDataServiceHelper.load((String)"ar_revcrm_verifyrecord", (String)"id,isvoucher,entry.billid,entry.assbillid,entry.revbillid,entry.e_hadwrittenoff,entry.e_iswrittenoff", (QFilter[])new QFilter[]{new QFilter("entry.billid", "in", billPks), new QFilter("entry.e_iswrittenoff", "=", (Object)Boolean.TRUE)});
                if ("true".equals(StdConfig.get((String)"allowArRevWrittenoffUnAudit"))) break block9;
                Set existArRevVrIds = Arrays.stream(records).map(record -> record.getDynamicObjectCollection("entry")).flatMap(Collection::stream).map(entry -> entry.getLong("billid")).collect(Collectors.toSet());
                for (ExtendedDataEntity data : datas) {
                    DynamicObject bill = data.getDataEntity();
                    long srcBillId = bill.getLong("sourcebillid");
                    if (!existArRevVrIds.contains(srcBillId)) continue;
                    this.addErrorMessage(data, ResManager.loadKDString((String)"\u53c2\u4e0e\u5e94\u6536\u6536\u5165\u6838\u9500\u5355\u636e\u7684\u51b2\u9500\u5355\u4e0d\u5141\u8bb8\u53cd\u5ba1\u6838\u3002", (String)"WrittenOffBillUnAuditValidator_2", (String)"fi-ar-opplugin", (Object[])new Object[0]));
                }
                break block10;
            }
            HashSet<Long> errBillIds = new HashSet<Long>(8);
            for (DynamicObject record2 : records) {
                if (!record2.getBoolean("isvoucher")) continue;
                DynamicObjectCollection entrys = record2.getDynamicObjectCollection("entry");
                for (Object entry2 : entrys) {
                    errBillIds.add(entry2.getLong("billid"));
                }
            }
            Set revAdjustBillIds = Arrays.stream(records).map(record -> record.getDynamicObjectCollection("entry")).flatMap(Collection::stream).filter(entry -> entry.getLong("revbillid") != 0L).map(entry -> entry.getLong("revbillid")).collect(Collectors.toSet());
            DynamicObjectCollection revAdjustBills = QueryServiceHelper.query((String)"ar_revcfmbill", (String)"id,bookdate,org.id,isvoucher", (QFilter[])new QFilter[]{new QFilter("id", "in", revAdjustBillIds)});
            HashSet<Long> errRevAdjustBillIds = new HashSet<Long>(8);
            for (DynamicObject revAdjustBill : revAdjustBills) {
                String errorMessage = vService.closeAccountValidate(revAdjustBill, "ar_revcfmbill", "bookdate");
                if (!revAdjustBill.getBoolean("isvoucher") && "".equals(errorMessage)) continue;
                errRevAdjustBillIds.add(revAdjustBill.getLong("id"));
            }
            HashSet<Long> errAsstBillIds = new HashSet<Long>(8);
            Set asstBillIds = Arrays.stream(records).map(record -> record.getDynamicObjectCollection("entry")).flatMap(Collection::stream).filter(entry -> entry.getLong("assbillid") != 0L).map(entry -> entry.getLong("assbillid")).collect(Collectors.toSet());
            DynamicObjectCollection assBills = QueryServiceHelper.query((String)"ar_revcfmbill", (String)"id,hadwrittenoff", (QFilter[])new QFilter[]{new QFilter("id", "in", asstBillIds)});
            for (DynamicObject assBill : assBills) {
                if (!assBill.getBoolean("hadwrittenoff")) continue;
                errAsstBillIds.add(assBill.getLong("id"));
            }
            for (DynamicObject record3 : records) {
                DynamicObjectCollection entrys = record3.getDynamicObjectCollection("entry");
                for (DynamicObject entry3 : entrys) {
                    if (errRevAdjustBillIds.contains(entry3.getLong("revbillid"))) {
                        errBillIds.add(entry3.getLong("billid"));
                    }
                    if (!errAsstBillIds.contains(entry3.getLong("assbillid"))) continue;
                    errBillIds.add(entry3.getLong("billid"));
                }
            }
            if (errBillIds.size() <= 0) break block10;
            String errMessage = ResManager.loadKDString((String)"\u53cd\u5ba1\u6838\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u4ee5\u4e0b\u5185\u5bb9\uff1a1.\u51b2\u9500\u5355\u4e0a\u6e38\u5355\u636e\u6240\u5173\u8054\u7684\u5e94\u6536\u6536\u5165\u6838\u9500\u8bb0\u5f55\u6240\u5bf9\u5e94\u7684\u51b2\u9500\u7684\u6838\u9500\u8bb0\u5f55\u672a\u751f\u6210\u51ed\u8bc1\uff1b2.\u51b2\u9500\u7684\u6838\u9500\u8bb0\u5f55\u751f\u6210\u7684\u6536\u5165\u786e\u8ba4\u8c03\u6574\u5355\u7684\u51b2\u9500\u5355\u672a\u751f\u6210\u51ed\u8bc1\uff1b3.\u51b2\u9500\u7684\u6838\u9500\u8bb0\u5f55\u751f\u6210\u7684\u6536\u5165\u786e\u8ba4\u8c03\u6574\u5355\u7684\u51b2\u9500\u5355\u7684\u8bb0\u8d26\u65e5\u671f\u6240\u5728\u671f\u95f4\u672a\u5173\u8d26\u30024.\u51b2\u9500\u5355\u4e0a\u6e38\u5355\u636e\u6240\u5173\u8054\u7684\u5e94\u6536\u6536\u5165\u6838\u9500\u8bb0\u5f55\u6240\u5bf9\u5e94\u7684\u6536\u5165\u786e\u8ba4\u5355\u4e0d\u4e3a\u5df2\u88ab\u51b2\u9500\u72b6\u6001\u3002", (String)"WrittenOffBillUnAuditValidator_1", (String)"fi-ar-opplugin", (Object[])new Object[0]);
            for (ExtendedDataEntity data : datas) {
                DynamicObject bill = data.getDataEntity();
                String srcBillId = bill.getString("sourcebillid");
                if (!errBillIds.contains(Long.parseLong(srcBillId))) continue;
                this.addErrorMessage(data, errMessage);
            }
        }
    }
}

