/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.validator.info;

import java.util.ArrayList;
import java.util.List;
import kd.fi.ar.validator.info.IntervalInfo;

public class IntervalComparator {
    public static void getIntersection(List<IntervalInfo> entries, List<IntervalInfo> intersections) {
        ArrayList<IntervalInfo> merge = new ArrayList<IntervalInfo>();
        int count = entries.size();
        for (int i = 0; i < count; ++i) {
            IntervalInfo c = entries.get(i);
            for (int j = i + 1; j < count && i < j; ++j) {
                IntervalInfo n = entries.get(j);
                IntervalInfo m = IntervalComparator.intersect(c, n);
                if (m == null || merge.contains(m)) continue;
                if (merge.isEmpty()) {
                    merge.add(m);
                    intersections.add(m);
                    continue;
                }
                ArrayList<IntervalInfo> sub = new ArrayList<IntervalInfo>();
                for (IntervalInfo p : merge) {
                    IntervalInfo dup = IntervalComparator.intersect(p, m);
                    if (dup != null) {
                        if (!merge.contains(dup) && !IntervalComparator.contains(merge, dup)) {
                            sub.add(dup);
                        }
                        if (sub.contains(m)) continue;
                        sub.add(m);
                        intersections.add(m);
                        continue;
                    }
                    if (intersections.contains(m)) continue;
                    sub.add(m);
                    intersections.add(m);
                }
                if (sub.isEmpty()) continue;
                merge.addAll(sub);
            }
        }
        if (!merge.isEmpty()) {
            IntervalComparator.getIntersection(merge, intersections);
        }
    }

    private static boolean contains(List<IntervalInfo> merge, IntervalInfo range) {
        boolean contains = false;
        if (!merge.isEmpty()) {
            for (IntervalInfo interval : merge) {
                if (!interval.equals(range)) continue;
                contains = true;
                break;
            }
        }
        return contains;
    }

    public static IntervalInfo intersect(IntervalInfo range1, IntervalInfo range2) {
        int x;
        int start;
        IntervalInfo merge = null;
        if (!range1.isIsabove() && !range2.isIsabove()) {
            int end;
            start = Math.max(range1.getStart(), range2.getStart());
            if (start < (end = Math.min(range1.getEnd(), range2.getEnd()))) {
                merge = new IntervalInfo(start, end, false);
            } else if (start == end) {
                merge = new IntervalInfo(range1.getStart(), end, false);
            }
        }
        if (!range1.isIsabove() && range2.isIsabove()) {
            x = range2.getStart();
            if (x > range1.getStart() && x < range1.getEnd()) {
                merge = new IntervalInfo(x, range1.getEnd(), false);
            } else if (x < range1.getStart() || x == range1.getStart()) {
                merge = new IntervalInfo(range1.getStart(), range1.getEnd(), false);
            } else if (x > range1.getStart() && x == range1.getEnd()) {
                merge = new IntervalInfo(range1.getStart(), x, false);
            }
        }
        if (range1.isIsabove() && !range2.isIsabove()) {
            x = range1.getStart();
            if (x > range2.getStart() && x < range2.getEnd()) {
                merge = new IntervalInfo(x, range2.getEnd(), false);
            } else if (x < range2.getStart()) {
                merge = new IntervalInfo(range2.getStart(), range2.getEnd(), false);
            } else if (x > range2.getStart() && x == range2.getEnd()) {
                merge = new IntervalInfo(range2.getStart(), range2.getEnd(), false);
            }
        }
        if (range1.isIsabove() && range2.isIsabove()) {
            start = Math.max(range1.getStart(), range2.getStart());
            merge = new IntervalInfo(start, 0, true);
        }
        return merge;
    }

    public static boolean contain(IntervalInfo range1, IntervalInfo range2) {
        boolean contain = false;
        int s1 = range1.getStart();
        int e1 = range1.getEnd();
        int s2 = range2.getStart();
        int e2 = range2.getEnd();
        if (!range1.isIsabove() && !range2.isIsabove()) {
            boolean bl = contain = e2 > s1 && e2 <= e1 && s2 >= s1 && s2 < e1;
        }
        if (range1.isIsabove() && !range2.isIsabove()) {
            if (s1 > s2) {
                contain = s1 <= e2;
            } else {
                boolean bl = contain = s1 <= s2;
            }
        }
        if (range1.isIsabove() && range2.isIsabove()) {
            contain = s1 <= s2;
        }
        return contain;
    }
}

