/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.report.acctage;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.util.DateUtils;
import kd.fi.arapcommon.consts.BillTypeConsts;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.report.BcmFormula;
import kd.fi.arapcommon.report.BcmFormulaExecutor;
import kd.fi.arapcommon.report.SumParam;
import kd.fi.arapcommon.report.acctage.AcctageAmtReverser;
import kd.fi.arapcommon.report.acctage.AcctageBusAmtReverser;
import kd.fi.arapcommon.report.acctage.AcctageFinAmtReverser;
import kd.fi.arapcommon.report.acctage.AcctageGroup;
import kd.fi.arapcommon.report.acctage.AcctageHelper;
import kd.fi.arapcommon.report.acctage.AcctageRptParam;
import kd.fi.arapcommon.report.acctage.ArapAcctageDataProvider;
import kd.fi.arapcommon.util.DataSetUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.util.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class AbstractArBcmFormulaExecutor
implements BcmFormulaExecutor {
    private static final Log logger = LogFactory.getLog(AbstractArBcmFormulaExecutor.class);
    protected boolean isShowLocalAmt;
    protected boolean isOnlyContainsAmount;
    private String balanceFieldName;

    public AbstractArBcmFormulaExecutor(boolean isShowLocalAmt) {
        this.isShowLocalAmt = isShowLocalAmt;
        this.balanceFieldName = isShowLocalAmt ? "localbalance" : "balance";
    }

    public AbstractArBcmFormulaExecutor(boolean isShowLocalAmt, boolean isOnlyContainsAmount) {
        this.isOnlyContainsAmount = isOnlyContainsAmount;
        this.isShowLocalAmt = isShowLocalAmt;
        this.balanceFieldName = isShowLocalAmt ? "localbalance" : "balance";
    }

    public void execute(BcmFormula bcmFormula) {
        for (String formulaId : bcmFormula.formulaIdSet()) {
            try {
                AcctageRptParam acctageRptParam;
                String dataScope = bcmFormula.getString(formulaId, "datascope");
                DataSet dataSet = null;
                String amountFieldName = this.balanceFieldName;
                String valueType = bcmFormula.getString(formulaId, "valuetype");
                if ("ALL".equals(dataScope)) {
                    AcctageRptParam finAcctageRptParam = this.getAcctageParam(formulaId, bcmFormula, "ar_finarbill");
                    AcctageRptParam busAcctageRptParam = this.getAcctageParam(formulaId, bcmFormula, "ar_busbill");
                    dataSet = this.queryAll(finAcctageRptParam, busAcctageRptParam);
                    if ("groupbalance".equals(valueType)) {
                        amountFieldName = AcctageHelper.getAmountFieldName((AcctageGroup)((AcctageGroup)finAcctageRptParam.getGroups().get(0)), (String)this.balanceFieldName);
                    }
                } else if ("ar_finarbill".equals(dataScope)) {
                    acctageRptParam = this.getAcctageParam(formulaId, bcmFormula, dataScope);
                    dataSet = this.queryFinData(acctageRptParam, false);
                    if ("groupbalance".equals(valueType)) {
                        amountFieldName = AcctageHelper.getAmountFieldName((AcctageGroup)((AcctageGroup)acctageRptParam.getGroups().get(0)), (String)this.balanceFieldName);
                    }
                } else if ("ar_busbill".equals(dataScope)) {
                    acctageRptParam = this.getAcctageParam(formulaId, bcmFormula, dataScope);
                    dataSet = this.queryBusData(acctageRptParam, false);
                    if ("groupbalance".equals(valueType)) {
                        amountFieldName = AcctageHelper.getAmountFieldName((AcctageGroup)((AcctageGroup)acctageRptParam.getGroups().get(0)), (String)this.balanceFieldName);
                    }
                }
                if (dataSet != null && dataSet.hasNext()) {
                    BigDecimal vSum = BigDecimal.ZERO;
                    while (dataSet.hasNext()) {
                        Row next = dataSet.next();
                        BigDecimal v = next.getBigDecimal(amountFieldName);
                        vSum = vSum.add(v);
                    }
                    bcmFormula.putResult(formulaId, vSum);
                    continue;
                }
                bcmFormula.putResult(formulaId, BigDecimal.ZERO);
            }
            catch (Exception e) {
                bcmFormula.putResult(formulaId, e);
            }
        }
    }

    private AcctageRptParam getAcctageParam(String formulaId, BcmFormula bcmFormula, String dataScope) {
        AcctageRptParam acctageRptParam = new AcctageRptParam();
        acctageRptParam.setEntity(dataScope);
        long orgId = bcmFormula.getOrgId(formulaId);
        long currencyId = bcmFormula.getBasedataId(formulaId, "currency", "bd_currency");
        Date queryDate = bcmFormula.getDate(formulaId, "querydate");
        if (queryDate == null) {
            queryDate = bcmFormula.getLastDayOfMonth();
        }
        queryDate = DateUtils.getDataFormat((Date)queryDate, (boolean)false);
        ArrayList<AcctageGroup> groups = new ArrayList<AcctageGroup>(5);
        String compareDateFieldKey = bcmFormula.getString(formulaId, "comparedatefield");
        String valueType = bcmFormula.getString(formulaId, "valuetype");
        if (!"balance".equals(valueType)) {
            Integer beginDay = bcmFormula.getInt(formulaId, "groupbeginday");
            Integer endDay = bcmFormula.getInt(formulaId, "groupendday");
            if (beginDay > 0 && endDay == 0) {
                endDay = null;
            }
            AcctageGroup acctageGroup = new AcctageGroup("", beginDay, endDay);
            groups.add(acctageGroup);
        }
        acctageRptParam.setOrgIds(Collections.singletonList(orgId));
        String asstactType = bcmFormula.getString(formulaId, "asstacttype");
        acctageRptParam.setAsstactType(asstactType);
        if (!EmptyUtils.isEmpty((Object)asstactType)) {
            List asstactIds = bcmFormula.getBasedataIds(formulaId, "asstact", asstactType);
            acctageRptParam.setAsstactPks(asstactIds);
            acctageRptParam.addStatisticalDimention("asstacttype", "asstacttype");
            acctageRptParam.addStatisticalDimention("asstact", "asstact");
            if (this.isShowLocalAmt) {
                acctageRptParam.addStatisticalDimention("currency", "currency");
                acctageRptParam.addStatisticalDimention("basecurrency", "basecurrency");
            }
        }
        acctageRptParam.setCurrencyIds(Collections.singletonList(currencyId));
        acctageRptParam.setQueryDate(queryDate);
        acctageRptParam.setRecoverHistoryData(true);
        acctageRptParam.setGroups(groups);
        acctageRptParam.setCompareDateField(compareDateFieldKey, StringUtils.removePrefix((String)compareDateFieldKey));
        List<QFilter> baseFilters = this.getBaseFilters(acctageRptParam, false);
        acctageRptParam.getFilters().addAll(baseFilters);
        this.handleCustomDimensions(formulaId, bcmFormula, acctageRptParam);
        return acctageRptParam;
    }

    private void handleCustomDimensions(String formulaId, BcmFormula bcmFormula, AcctageRptParam acctageRptParam) {
        for (int i = 1; i < 3; ++i) {
            String customDimension;
            if (!bcmFormula.existsParam("customdimension" + i) || EmptyUtils.isEmpty((Object)(customDimension = bcmFormula.getString(formulaId, "customdimension" + i)))) continue;
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)acctageRptParam.getEntity());
            DynamicProperty property = EntityMetadataUtils.getProperty((MainEntityType)entityType, (String)customDimension);
            if (property instanceof BasedataProp) {
                QFilter filter;
                String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                List customDimensionValueIds = bcmFormula.getBasedataIds(formulaId, "customdimensionvalue" + i, baseEntityId);
                if (!customDimensionValueIds.isEmpty()) {
                    filter = new QFilter(customDimension, "in", (Object)customDimensionValueIds);
                    acctageRptParam.getFilters().add(filter);
                    acctageRptParam.addStatisticalDimentions(new String[]{customDimension});
                    continue;
                }
                filter = new QFilter("id", "=", (Object)0);
                acctageRptParam.getFilters().add(filter);
                continue;
            }
            if (property == null) {
                throw new IllegalArgumentException(String.format("property %s is not found in %s", customDimension, acctageRptParam.getEntity()));
            }
            throw new IllegalArgumentException(String.format("property %s must be a basedata property.", customDimension, acctageRptParam.getEntity()));
        }
    }

    protected DataSet queryFinData(AcctageRptParam finQueryParam, boolean autoSum) {
        List currencyIds;
        logger.info("queryFinData : Start query processing the ar_finarbill .");
        this.setFinQueryInfo(finQueryParam);
        finQueryParam.setAutoSum(autoSum);
        finQueryParam.setRecoverHistoryData(true);
        LinkedList<String> settleRecordBillTypes = new LinkedList<String>();
        List billTypes = finQueryParam.getBillTypes();
        if (!ObjectUtils.isEmpty((Object)billTypes)) {
            for (DynamicObject billType : billTypes) {
                long billTypeId = billType.getLong("id");
                String settleRecordBillType = BillTypeConsts.getBillTypeMap().getOrDefault(billTypeId, billType.getString("number"));
                settleRecordBillTypes.add(settleRecordBillType);
            }
        }
        Date compareDate = DateUtils.getDataFormat((Date)finQueryParam.getQueryDate(), (boolean)false);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("settledate", ">", (Object)compareDate));
        List orgIds = finQueryParam.getOrgIds();
        if (!orgIds.isEmpty()) {
            filters.add(new QFilter("org", "in", (Object)orgIds));
        }
        if (!(currencyIds = finQueryParam.getCurrencyIds()).isEmpty()) {
            filters.add(new QFilter("maincurrency", "in", (Object)currencyIds));
        }
        ArrayList<QFilter> mainSettleRecordFilters = new ArrayList<QFilter>(filters);
        String asstactType = finQueryParam.getAsstactType();
        if (!ObjectUtils.isEmpty((Object)asstactType)) {
            mainSettleRecordFilters.add(new QFilter("mainasstacttype", "=", (Object)asstactType));
        }
        mainSettleRecordFilters.add(new QFilter("billentity", "=", (Object)"ar_finarbill"));
        if (!settleRecordBillTypes.isEmpty()) {
            mainSettleRecordFilters.add(new QFilter("mainbilltype", "in", settleRecordBillTypes));
        }
        StringBuilder logBuilder = new StringBuilder(" ");
        for (QFilter f : mainSettleRecordFilters) {
            logBuilder.append(f);
            logBuilder.append(';');
        }
        logBuilder.append("queryFinData : the mainSettleRecordFilters is ");
        logger.info(logBuilder.toString());
        DataSet mainSettleRecords = QueryServiceHelper.queryDataSet((String)"commonquery", (String)"ar_settlerecord", (String)"mainbillid,totalsettleamt,localtotalsettleamt", (QFilter[])mainSettleRecordFilters.toArray(new QFilter[0]), null);
        ArrayList<QFilter> asstSettleRecordFilters = new ArrayList<QFilter>(filters);
        if (!ObjectUtils.isEmpty((Object)asstactType)) {
            asstSettleRecordFilters.add(new QFilter("entry.asstacttype", "=", (Object)asstactType));
        }
        if (!settleRecordBillTypes.isEmpty()) {
            asstSettleRecordFilters.add(new QFilter("entry.billtype", "in", settleRecordBillTypes));
        }
        asstSettleRecordFilters.add(new QFilter("entry.e_billentity", "=", (Object)"ar_finarbill"));
        asstSettleRecordFilters.add(new QFilter("settlerelation", "in", (Object)new String[]{SettleRelationEnum.APARSETTLE.getValue(), SettleRelationEnum.ARSELF.getValue()}));
        logBuilder = new StringBuilder(" ");
        for (QFilter f : mainSettleRecordFilters) {
            logBuilder.append(f);
            logBuilder.append(';');
        }
        logBuilder.append("queryFinData :  the asstSettleRecordFilters is ");
        logger.info(logBuilder.toString());
        DataSet asstSettleRecords = QueryServiceHelper.queryDataSet((String)"commonquery", (String)"ap_settlerecord", (String)"entry.billid as mainbillid,entry.settleamt as totalsettleamt,entry.localsettleamt as localtotalsettleamt", (QFilter[])asstSettleRecordFilters.toArray(new QFilter[0]), null);
        DataSet settleRecords = mainSettleRecords.union(asstSettleRecords);
        mainSettleRecords.close();
        asstSettleRecords.close();
        DataSet groupBySettleRecords = settleRecords.groupBy(new String[]{"mainbillid"}).sum("totalsettleamt").sum("localtotalsettleamt").finish();
        settleRecords.close();
        DataSet copyOfSettleRecords = groupBySettleRecords.copy();
        HashSet<Long> reverseableBusIds = new HashSet<Long>();
        for (Row row : copyOfSettleRecords) {
            reverseableBusIds.add(row.getLong("mainbillid"));
        }
        copyOfSettleRecords.close();
        List baseFilters = finQueryParam.getFilters();
        baseFilters.add(new QFilter("bizdate", "<=", (Object)compareDate));
        baseFilters.add(new QFilter("iswrittenoff", "=", (Object)Boolean.FALSE));
        baseFilters.add(new QFilter("settlestatus", "in", (Object)new String[]{"unsettle", "partsettle"}).or(new QFilter("id", "in", reverseableBusIds)));
        AcctageFinAmtReverser acctageFinAmtReverser = new AcctageFinAmtReverser(groupBySettleRecords, finQueryParam);
        return new ArapAcctageDataProvider(finQueryParam, (AcctageAmtReverser)acctageFinAmtReverser).query();
    }

    private void setFinQueryInfo(AcctageRptParam param) {
        MutablePair balanceField = new MutablePair((Object)"unsettleamount", (Object)"balance");
        if (this.isShowLocalAmt) {
            MutablePair localBalanceField = new MutablePair((Object)"unsettlelocalamt", (Object)"localbalance");
            param.setAnalysisAmtFields(new Pair[]{balanceField, localBalanceField});
        } else {
            param.setAnalysisAmtFields(new Pair[]{balanceField});
        }
        for (Pair anlaysisField : param.getAnalysisAmtFields()) {
            param.addStatisticalAmtField((String)anlaysisField.getKey(), (String)anlaysisField.getValue(), true);
        }
        param.addStatisticalAmtField("recamount", "recamt", true);
        if (this.isShowLocalAmt) {
            param.addStatisticalAmtField("reclocalamt", "localrecamt", true);
        }
        for (Pair anlaysisField : param.getAnalysisAmtFields()) {
            for (AcctageGroup group : param.getGroups()) {
                param.addStatisticalAmtField("", AcctageHelper.getAmountFieldName((AcctageGroup)group, (String)((String)anlaysisField.getValue())), false);
            }
        }
    }

    public DataSet queryBusData(AcctageRptParam busQueryParam, boolean autoSum) {
        logger.info("queryBusData : Start query processing the ar_busbill .");
        this.setBusQueryInfo(busQueryParam);
        busQueryParam.setAutoSum(autoSum);
        busQueryParam.setRecoverHistoryData(true);
        List<QFilter> arBusFilters = this.getWoffBusFilters(busQueryParam);
        logger.info("\u67e5\u8be2\u51b2\u56de\u5355\u6761\u4ef6\uff1a" + arBusFilters);
        DataSet adjustBusBillBAndC = this.isOnlyContainsAmount ? QueryServiceHelper.queryDataSet((String)"commonquery", (String)"ar_busbill", (String)"-1 * entry.e_amount e_recamount,-1 * entry.e_localamt e_reclocalamt,entry.e_srcbillid e_srcbillid1", (QFilter[])arBusFilters.toArray(new QFilter[0]), null) : QueryServiceHelper.queryDataSet((String)"commonquery", (String)"ar_busbill", (String)"-1 * entry.e_recamount e_recamount,-1 * entry.e_reclocalamt e_reclocalamt,entry.e_srcbillid e_srcbillid1", (QFilter[])arBusFilters.toArray(new QFilter[0]), null);
        DataSet copyOfBusBills = adjustBusBillBAndC.copy();
        HashSet<Long> reverseableBusIds = new HashSet<Long>(16);
        for (Object row : copyOfBusBills) {
            reverseableBusIds.add(row.getLong("e_srcbillid1"));
        }
        copyOfBusBills.close();
        DataSet adjustBusBillsB = QueryServiceHelper.queryDataSet((String)"commonquery", (String)"ar_busbill", (String)"id,entry.e_srcbillid e_srcbillid2", (QFilter[])new QFilter[]{new QFilter("id", "in", reverseableBusIds), new QFilter("isadjust", "=", (Object)Boolean.TRUE)}, null);
        copyOfBusBills = adjustBusBillsB.copy();
        for (Row row : copyOfBusBills) {
            reverseableBusIds.remove(row.getLong("id"));
        }
        copyOfBusBills.close();
        JoinDataSet joinDataSet = adjustBusBillBAndC.join(adjustBusBillsB, JoinType.LEFT).on("e_srcbillid1", "id");
        LinkedList<String> selectedFields = new LinkedList<String>();
        selectedFields.add("e_recamount");
        selectedFields.add("e_reclocalamt");
        selectedFields.add("case when e_srcbillid2>0 then e_srcbillid2 else e_srcbillid1 end as e_srcbillid");
        adjustBusBillBAndC = joinDataSet.select(selectedFields.toArray(new String[0])).finish();
        List filters = busQueryParam.getFilters();
        filters.add(new QFilter("isadjust", "=", (Object)Boolean.FALSE));
        filters.add(new QFilter("bizdate", "<=", (Object)busQueryParam.getQueryDate()));
        if (this.isOnlyContainsAmount) {
            filters.add(new QFilter("unwoffnotaxamt", "<>", (Object)0));
        } else {
            filters.add(new QFilter("unwoffamt", "<>", (Object)0));
        }
        logger.info("\u67e5\u8be2\u84dd\u5b57\u6682\u4f30\u5355\u6761\u4ef6\uff1a" + filters);
        DataSet busBillForIds = QueryServiceHelper.queryDataSet((String)"commonquery", (String)"ar_busbill", (String)"id", (QFilter[])filters.toArray(new QFilter[0]), null);
        HashSet<Long> busBillIds = new HashSet<Long>();
        for (Row row : busBillForIds) {
            busBillIds.add(row.getLong("id"));
        }
        busBillIds.addAll(reverseableBusIds);
        busQueryParam.setFilters(Arrays.asList(new QFilter("id", "in", busBillIds), new QFilter("bizdate", "<=", (Object)busQueryParam.getQueryDate())));
        AcctageBusAmtReverser arAcctageAmtReverser = new AcctageBusAmtReverser(busQueryParam, adjustBusBillBAndC);
        DataSet busData = new ArapAcctageDataProvider(busQueryParam, (AcctageAmtReverser)arAcctageAmtReverser).query();
        return busData;
    }

    public DataSet queryBusData2(AcctageRptParam busQueryParam, boolean autoSum) {
        this.setBusQueryInfo(busQueryParam);
        busQueryParam.setAutoSum(autoSum);
        busQueryParam.setRecoverHistoryData(true);
        List<QFilter> filters = this.getWoffBusFilters(busQueryParam);
        ArrayList<QFilter> woffFilters = new ArrayList<QFilter>(8);
        woffFilters.addAll(filters);
        woffFilters.add(new QFilter("entry.e_srcbillid", "<>", (Object)0));
        woffFilters.add(new QFilter("entry.e_mostsrcbusbillid", "=", (Object)0));
        logger.info("\u67e5\u8be2\u51b2\u56de\u5355\u6761\u4ef6woffFilters\uff1a" + woffFilters);
        DataSet woffDataSet = QueryServiceHelper.queryDataSet((String)"queryWoffBill", (String)"ar_busbill", (String)"entry.e_srcbillid e_srcbillid, entry.e_recamount e_recamount, entry.e_reclocalamt e_reclocalamt", (QFilter[])woffFilters.toArray(new QFilter[0]), null);
        ArrayList<QFilter> writeoffFilters = new ArrayList<QFilter>(8);
        writeoffFilters.addAll(filters);
        writeoffFilters.add(new QFilter("entry.e_srcbillid", "<>", (Object)0));
        writeoffFilters.add(new QFilter("entry.e_mostsrcbusbillid", "<>", (Object)0));
        logger.info("\u67e5\u8be2\u51b2\u56de\u51b2\u9500\u5355\u6761\u4ef6writeoffFilters\uff1a" + writeoffFilters);
        DataSet writeoffDataSet = QueryServiceHelper.queryDataSet((String)"queryWriteoffBill", (String)"ar_busbill", (String)"entry.e_mostsrcbusbillid e_srcbillid, entry.e_recamount e_recamount, entry.e_reclocalamt e_reclocalamt", (QFilter[])writeoffFilters.toArray(new QFilter[0]), null);
        DataSet woffBills = woffDataSet.union(writeoffDataSet);
        woffDataSet.close();
        writeoffDataSet.close();
        DataSet groupByWoffBills = woffBills.groupBy(new String[]{"e_srcbillid"}).sum("e_recamount").sum("e_reclocalamt").finish();
        woffBills.close();
        DataSet copyOfWoffBills = groupByWoffBills.copy();
        HashSet<Long> reverseBillIds = new HashSet<Long>(8);
        for (Row row : copyOfWoffBills) {
            reverseBillIds.add(row.getLong("e_srcbillid"));
        }
        copyOfWoffBills.close();
        List busFilters = busQueryParam.getFilters();
        busFilters.add(new QFilter("bizdate", "<=", (Object)busQueryParam.getQueryDate()));
        busFilters.add(new QFilter("isadjust", "=", (Object)Boolean.FALSE));
        busFilters.add(new QFilter("unwoffamt", "<>", (Object)0).or(new QFilter("id", "in", reverseBillIds)));
        AcctageBusAmtReverser arAcctageAmtReverser = new AcctageBusAmtReverser(busQueryParam, groupByWoffBills);
        DataSet busData = new ArapAcctageDataProvider(busQueryParam, (AcctageAmtReverser)arAcctageAmtReverser).query();
        return busData;
    }

    private List<QFilter> getWoffBusFilters(AcctageRptParam param) {
        Date queryDate = DateUtils.getDataFormat((Date)param.getQueryDate(), (boolean)false);
        LinkedList<QFilter> woffFilters = new LinkedList<QFilter>(param.getFilters());
        woffFilters.add(new QFilter("bizdate", ">", (Object)queryDate));
        woffFilters.add(new QFilter("isadjust", "=", (Object)Boolean.TRUE));
        return woffFilters;
    }

    private void setBusQueryInfo(AcctageRptParam param) {
        String balance = this.isOnlyContainsAmount ? "unwoffnotaxamt" : "unwoffamt";
        String localbalance = this.isOnlyContainsAmount ? "unwoffnotaxlocamt" : "unwofflocamt";
        MutablePair balanceField = new MutablePair((Object)balance, (Object)"balance");
        if (this.isShowLocalAmt) {
            Pair[] localBalanceField = new MutablePair((Object)localbalance, (Object)"localbalance");
            param.setAnalysisAmtFields(new Pair[]{balanceField, localBalanceField});
        } else {
            param.setAnalysisAmtFields(new Pair[]{balanceField});
        }
        for (Pair anlaysisField : param.getAnalysisAmtFields()) {
            param.addStatisticalAmtField((String)anlaysisField.getKey(), (String)anlaysisField.getValue(), true);
        }
        String recamt = this.isOnlyContainsAmount ? "amount" : "recamount";
        String localrecamt = this.isOnlyContainsAmount ? "localamt" : "reclocalamt";
        param.addStatisticalAmtField(recamt, "recamt", true);
        param.addStatisticalAmtField(localrecamt, "localrecamt", true);
        for (Pair anlaysisField : param.getAnalysisAmtFields()) {
            for (AcctageGroup group : param.getGroups()) {
                param.addStatisticalAmtField("", AcctageHelper.getAmountFieldName((AcctageGroup)group, (String)((String)anlaysisField.getValue())), false);
            }
        }
    }

    protected DataSet queryAll(AcctageRptParam finQueryParam, AcctageRptParam busQueryParam) {
        logger.info("queryAll : Start query processing ar_finarbill and ar_finbusbill.");
        DataSet finData = this.queryFinData(finQueryParam, false);
        DataSet busData = this.queryBusData2(busQueryParam, false);
        logger.info("queryAll : end query processing ar_finarbill and ar_finbusbill , and begin to union dataSet.");
        List busSelectedFields = DataSetUtils.getSelectedFields((DataSet)busData, (String[])new String[0]);
        HashSet hashSet = new HashSet(DataSetUtils.getSelectedFields((DataSet)finData, (String[])new String[0]));
        ArrayList<String> busSelectedFields2 = new ArrayList<String>();
        for (String f : busSelectedFields) {
            if (!hashSet.contains(f)) continue;
            busSelectedFields2.add(f);
        }
        busData = busData.select(busSelectedFields2.toArray(new String[0]));
        DataSet unionData = DataSetUtils.union((DataSet)finData, (DataSet)busData);
        SumParam statisticalSumParam = finQueryParam.getStatisticalSumParam();
        DataSet groupByUnionData = DataSetUtils.sum((DataSet)unionData, (SumParam)statisticalSumParam);
        SumParam sumParam = finQueryParam.getSumParam();
        SumParam totalSumParam = finQueryParam.getTotalSumParam();
        return DataSetUtils.sum((DataSet)groupByUnionData, Arrays.asList(sumParam, totalSumParam));
    }

    public List<QFilter> getBaseFilters(AcctageRptParam param, boolean containsUnaudit) {
        String asstactType;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        List orgIds = param.getOrgIds();
        if (!orgIds.isEmpty()) {
            filters.add(new QFilter("org", "in", (Object)orgIds));
        }
        if (!ObjectUtils.isEmpty((Object)(asstactType = param.getAsstactType()))) {
            filters.add(new QFilter("asstacttype", "=", (Object)asstactType));
            List asstactPks = param.getAsstactPks();
            if (!ObjectUtils.isEmpty((Object)asstactPks)) {
                filters.add(new QFilter("asstact", "in", (Object)asstactPks));
            }
        } else {
            filters.add(new QFilter("asstacttype", "in", Arrays.asList("bd_supplier", "bd_customer", "bos_user")));
        }
        List currencyIds = param.getCurrencyIds();
        if (currencyIds != null && !currencyIds.isEmpty()) {
            filters.add(new QFilter("currency", "in", (Object)currencyIds));
        }
        if (containsUnaudit) {
            filters.add(new QFilter("billstatus", "in", (Object)new String[]{"B", "C"}));
        } else {
            filters.add(new QFilter("billstatus", "=", (Object)"C"));
        }
        List billTypes = param.getBillTypes();
        if (!ObjectUtils.isEmpty((Object)billTypes)) {
            List billTypeIds = DynamicObjectHelper.getIdList((Collection)billTypes);
            filters.add(new QFilter("billtype", "in", (Object)billTypeIds));
        }
        return filters;
    }
}

