/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.report.acctage;

import java.util.Collection;
import java.util.Date;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntryType;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.fi.ar.report.acctage.impl.ArAcctageQuerier;
import kd.fi.ar.util.DateUtils;
import kd.fi.arapcommon.dev.BeanFactory;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.report.ReportHelper;
import kd.fi.arapcommon.report.acctage.AcctageCustomizer;
import kd.fi.arapcommon.report.acctage.AcctageRptParam;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.util.StringUtils;

public class ArAcctageListDataRpt
extends AbstractReportListDataPlugin {
    private static final Log logger = LogFactory.getLog(ArAcctageListDataRpt.class);

    public DataSet query(ReportQueryParam queryParam, Object selectedObj) throws Throwable {
        try {
            DataSet result = this.queryData(queryParam);
            logger.info("ending query dataSet .");
            return result;
        }
        catch (Exception e) {
            logger.error((Throwable)e);
            throw e;
        }
    }

    private DataSet queryData(ReportQueryParam queryParam) throws Exception {
        String entity = (String)queryParam.getFilter().getFilterItem("sourceentity").getValue();
        FilterInfo filterInfo = queryParam.getFilter();
        boolean isShowLocalAmt = filterInfo.getBoolean("showlocalamt");
        boolean isOnlyContainsAmount = filterInfo.getBoolean("onlycontainsamount");
        ArAcctageQuerier arAcctageQuerier = new ArAcctageQuerier(isShowLocalAmt, isOnlyContainsAmount);
        if ("ar_finarbill".equals(entity)) {
            AcctageRptParam finQueryParam = this.setCommonParam(queryParam, "ar_finarbill");
            return arAcctageQuerier.queryFinData(finQueryParam, true, isShowLocalAmt);
        }
        if ("ar_busbill".equals(entity)) {
            AcctageRptParam busQueryParam = this.setCommonParam(queryParam, "ar_busbill");
            return arAcctageQuerier.queryBusData2(busQueryParam, true);
        }
        if ("ALL".equals(entity)) {
            AcctageRptParam finQueryParam = this.setCommonParam(queryParam, "ar_finarbill");
            AcctageRptParam busQueryParam = this.setCommonParam(queryParam, "ar_busbill");
            return arAcctageQuerier.queryAll(finQueryParam, busQueryParam, isShowLocalAmt);
        }
        throw new RuntimeException("Not supported yet");
    }

    private AcctageRptParam setCommonParam(ReportQueryParam queryParam, String entityKey) {
        Date queryDate;
        FilterInfo filterInfo = queryParam.getFilter();
        AcctageRptParam param = new AcctageRptParam();
        DynamicObjectCollection billTypes = queryParam.getFilter().getDynamicObjectCollection("billtypes");
        param.setBillTypes((List)billTypes);
        param.setEntity(entityKey);
        param.setOrgIds(DynamicObjectHelper.getIdList((Collection)filterInfo.getDynamicObjectCollection("orgs")));
        param.setCurrencyIds(DynamicObjectHelper.getIdList((Collection)filterInfo.getDynamicObjectCollection("q_currency")));
        String asstactType = filterInfo.getString("q_asstacttype");
        if (!ObjectUtils.isEmpty((Object)asstactType)) {
            param.setAsstactType(asstactType);
            DynamicObjectCollection acctacts = filterInfo.getDynamicObjectCollection(param.getAsstactType());
            param.setAsstactPks(ReportHelper.getBasedataIds((List)acctacts));
        }
        if ((queryDate = filterInfo.getDate("date")) != null) {
            queryDate = DateUtils.getDataFormat((Date)queryDate, (boolean)false);
        }
        param.setQueryDate(queryDate);
        param.setRecoverHistoryData(true);
        param.setGroups((List)filterInfo.getFilterItem("groups").getValue());
        String compareDateFieldKey = filterInfo.getString("standard");
        param.setCompareDateField(compareDateFieldKey, StringUtils.removePrefix((String)compareDateFieldKey));
        param.setIsHyperLinkClick(filterInfo.getBoolean("isHyperLinkClickByGroup"));
        DynamicProperty property = EntityMetadataUtils.getProperty((String)entityKey, (String)StringUtils.removePrefix((String)compareDateFieldKey));
        IDataEntityType parent = property.getParent();
        if (parent instanceof EntryType) {
            param.setEntryName(parent.getName());
        }
        boolean containsUnaudit = queryParam.getFilter().getBoolean("containsunaudit");
        List<QFilter> baseFilters = new ArAcctageQuerier().getBaseFilters(param, containsUnaudit);
        param.getFilters().addAll(baseFilters);
        AcctageCustomizer acctageCustomSettingHelper = (AcctageCustomizer)BeanFactory.getBean(AcctageCustomizer.class, (Object[])new Object[]{queryParam});
        acctageCustomSettingHelper.customize(param);
        return param;
    }
}

