/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.report.acctage;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.property.BasedataProp;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.ar.util.DateUtils;
import kd.fi.arapcommon.consts.BillTypeConsts;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.report.BcmFormula;
import kd.fi.arapcommon.report.BcmFormulaExecutor;
import kd.fi.arapcommon.report.SumParam;
import kd.fi.arapcommon.report.acctage.AcctageAmtReverser;
import kd.fi.arapcommon.report.acctage.AcctageBusWoffAmtReverser;
import kd.fi.arapcommon.report.acctage.AcctageFinAmtReverser;
import kd.fi.arapcommon.report.acctage.AcctageGroup;
import kd.fi.arapcommon.report.acctage.AcctageHelper;
import kd.fi.arapcommon.report.acctage.AcctageRptParam;
import kd.fi.arapcommon.report.acctage.ArapAcctageDataProvider;
import kd.fi.arapcommon.util.DataSetUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.util.StringUtils;
import org.apache.commons.lang3.tuple.MutablePair;
import org.apache.commons.lang3.tuple.Pair;

public class ArAcctageQuerierExt
implements BcmFormulaExecutor {
    public void execute(BcmFormula bcmFormula) {
        for (String formulaId : bcmFormula.formulaIdSet()) {
            try {
                AcctageRptParam acctageRptParam;
                String dataScope = bcmFormula.getString(formulaId, "datascope");
                DataSet dataSet = null;
                String amountFieldName = "balance";
                String valueType = bcmFormula.getString(formulaId, "valuetype");
                if ("ALL".equals(dataScope)) {
                    AcctageRptParam finAcctageRptParam = this.getAcctageParam(formulaId, bcmFormula, "ar_finarbill");
                    AcctageRptParam busAcctageRptParam = this.getAcctageParam(formulaId, bcmFormula, "ar_busbill");
                    dataSet = this.queryAll(finAcctageRptParam, busAcctageRptParam, false);
                    if ("groupbalance".equals(valueType)) {
                        amountFieldName = AcctageHelper.getAmountFieldName((AcctageGroup)((AcctageGroup)finAcctageRptParam.getGroups().get(0)), (String)"balance");
                    }
                } else if ("ar_finarbill".equals(dataScope)) {
                    acctageRptParam = this.getAcctageParam(formulaId, bcmFormula, dataScope);
                    dataSet = this.queryFinData(acctageRptParam, false, false);
                    if ("groupbalance".equals(valueType)) {
                        amountFieldName = AcctageHelper.getAmountFieldName((AcctageGroup)((AcctageGroup)acctageRptParam.getGroups().get(0)), (String)"balance");
                    }
                } else if ("ar_busbill".equals(dataScope)) {
                    acctageRptParam = this.getAcctageParam(formulaId, bcmFormula, dataScope);
                    dataSet = this.queryBusData(acctageRptParam, false);
                    if ("groupbalance".equals(valueType)) {
                        amountFieldName = AcctageHelper.getAmountFieldName((AcctageGroup)((AcctageGroup)acctageRptParam.getGroups().get(0)), (String)"balance");
                    }
                }
                if (dataSet != null && dataSet.hasNext()) {
                    Row next = dataSet.next();
                    BigDecimal v = next.getBigDecimal(amountFieldName);
                    bcmFormula.putResult(formulaId, v);
                    continue;
                }
                bcmFormula.putResult(formulaId, BigDecimal.ZERO);
            }
            catch (Exception e) {
                bcmFormula.putResult(formulaId, e);
            }
        }
    }

    private AcctageRptParam getAcctageParam(String formulaId, BcmFormula bcmFormula, String dataScope) {
        List asstactPks;
        AcctageRptParam acctageRptParam = new AcctageRptParam();
        acctageRptParam.setEntity(dataScope);
        long orgId = bcmFormula.getOrgId(formulaId);
        long currencyId = bcmFormula.getBasedataId(formulaId, "currency", "bd_currency");
        Date queryDate = bcmFormula.getDate(formulaId, "querydate");
        if (queryDate == null) {
            queryDate = bcmFormula.getLastDayOfMonth();
        }
        queryDate = DateUtils.getDataFormat((Date)queryDate, (boolean)false);
        ArrayList<AcctageGroup> groups = new ArrayList<AcctageGroup>(5);
        String compareDateFieldKey = bcmFormula.getString(formulaId, "comparedatefield");
        String valueType = bcmFormula.getString(formulaId, "valuetype");
        if (!"balance".equals(valueType)) {
            Integer beginDay = bcmFormula.getInt(formulaId, "groupbeginday");
            Integer endDay = bcmFormula.getInt(formulaId, "groupendday");
            if (beginDay > 0 && endDay == 0) {
                endDay = null;
            }
            AcctageGroup acctageGroup = new AcctageGroup("", beginDay, endDay);
            groups.add(acctageGroup);
        }
        acctageRptParam.setOrgIds(Collections.singletonList(orgId));
        String asstactType = bcmFormula.getString(formulaId, "asstacttype");
        acctageRptParam.setAsstactType(asstactType);
        if (!EmptyUtils.isEmpty((Object)asstactType)) {
            List asstactIds = bcmFormula.getBasedataIds(formulaId, "asstact", asstactType);
            acctageRptParam.setAsstactPks(asstactIds);
            acctageRptParam.addStatisticalDimention("asstacttype", "asstacttype");
            acctageRptParam.addStatisticalDimention("asstact", "asstact");
        }
        acctageRptParam.setCurrencyIds(Collections.singletonList(currencyId));
        acctageRptParam.setQueryDate(queryDate);
        acctageRptParam.setRecoverHistoryData(true);
        acctageRptParam.setGroups(groups);
        acctageRptParam.setCompareDateField(compareDateFieldKey, StringUtils.removePrefix((String)compareDateFieldKey));
        List<QFilter> baseFilters = this.getBaseFilters(acctageRptParam, false);
        if (!ObjectUtils.isEmpty((Object)asstactType) && ObjectUtils.isEmpty((Object)(asstactPks = acctageRptParam.getAsstactPks()))) {
            baseFilters.add(new QFilter("id", "=", (Object)0));
        }
        acctageRptParam.getFilters().addAll(baseFilters);
        this.handleCustomDimensions(formulaId, bcmFormula, acctageRptParam);
        return acctageRptParam;
    }

    private void handleCustomDimensions(String formulaId, BcmFormula bcmFormula, AcctageRptParam acctageRptParam) {
        for (int i = 1; i < 3; ++i) {
            String customDimension;
            if (!bcmFormula.existsParam("customdimension" + i) || EmptyUtils.isEmpty((Object)(customDimension = bcmFormula.getString(formulaId, "customdimension" + i)))) continue;
            MainEntityType entityType = MetadataServiceHelper.getDataEntityType((String)acctageRptParam.getEntity());
            DynamicProperty property = EntityMetadataUtils.getProperty((MainEntityType)entityType, (String)customDimension);
            if (property instanceof BasedataProp) {
                QFilter filter;
                String baseEntityId = ((BasedataProp)property).getBaseEntityId();
                List customDimensionValueIds = bcmFormula.getBasedataIds(formulaId, "customdimensionvalue" + i, baseEntityId);
                if (!customDimensionValueIds.isEmpty()) {
                    filter = new QFilter(customDimension, "in", (Object)customDimensionValueIds);
                    acctageRptParam.getFilters().add(filter);
                    acctageRptParam.addStatisticalDimentions(new String[]{customDimension});
                    continue;
                }
                filter = new QFilter("id", "=", (Object)0);
                acctageRptParam.getFilters().add(filter);
                continue;
            }
            if (property == null) {
                throw new IllegalArgumentException(String.format("property %s is not found in %s", customDimension, acctageRptParam.getEntity()));
            }
            throw new IllegalArgumentException(String.format("property %s must be a basedata property.", customDimension, acctageRptParam.getEntity()));
        }
    }

    public DataSet queryFinData(AcctageRptParam finQueryParam, boolean autoSum, boolean isShowLocalAmt) {
        List currencyIds;
        String asstactType;
        this.setFinQueryInfo(isShowLocalAmt, finQueryParam);
        finQueryParam.setAutoSum(autoSum);
        finQueryParam.setRecoverHistoryData(true);
        LinkedList<String> settleRecordBillTypes = new LinkedList<String>();
        List billTypes = finQueryParam.getBillTypes();
        if (!ObjectUtils.isEmpty((Object)billTypes)) {
            for (DynamicObject billType : billTypes) {
                long billTypeId = billType.getLong("id");
                String settleRecordBillType = BillTypeConsts.getBillTypeMap().getOrDefault(billTypeId, billType.getString("number"));
                settleRecordBillTypes.add(settleRecordBillType);
            }
        }
        Date compareDate = DateUtils.getDataFormat((Date)finQueryParam.getQueryDate(), (boolean)false);
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        filters.add(new QFilter("settledate", ">", (Object)compareDate));
        List orgIds = finQueryParam.getOrgIds();
        if (!orgIds.isEmpty()) {
            filters.add(new QFilter("org", "in", (Object)orgIds));
        }
        if (!ObjectUtils.isEmpty((Object)(asstactType = finQueryParam.getAsstactType()))) {
            filters.add(new QFilter("mainasstacttype", "=", (Object)asstactType));
        }
        if (!(currencyIds = finQueryParam.getCurrencyIds()).isEmpty()) {
            filters.add(new QFilter("maincurrency", "in", (Object)currencyIds));
        }
        ArrayList<QFilter> mainSettleRecordFilters = new ArrayList<QFilter>();
        mainSettleRecordFilters.addAll(filters);
        mainSettleRecordFilters.add(new QFilter("billentity", "=", (Object)"ar_finarbill"));
        if (!settleRecordBillTypes.isEmpty()) {
            mainSettleRecordFilters.add(new QFilter("mainbilltype", "in", settleRecordBillTypes));
        }
        DataSet mainSettleRecords = QueryServiceHelper.queryDataSet((String)"commonquery", (String)"ar_settlerecord", (String)"mainbillid,totalsettleamt,localtotalsettleamt", (QFilter[])mainSettleRecordFilters.toArray(new QFilter[0]), null);
        ArrayList<QFilter> asstSettleRecordFilters = new ArrayList<QFilter>();
        asstSettleRecordFilters.addAll(filters);
        if (!settleRecordBillTypes.isEmpty()) {
            asstSettleRecordFilters.add(new QFilter("entry.billtype", "in", settleRecordBillTypes));
        }
        asstSettleRecordFilters.add(new QFilter("entry.e_billentity", "=", (Object)"ar_finarbill"));
        asstSettleRecordFilters.add(new QFilter("settlerelation", "in", (Object)new String[]{SettleRelationEnum.APARSETTLE.getValue(), SettleRelationEnum.ARSELF.getValue()}));
        DataSet asstSettleRecords = QueryServiceHelper.queryDataSet((String)"commonquery", (String)"ap_settlerecord", (String)"entry.billid as mainbillid,entry.settleamt as totalsettleamt,entry.localsettleamt as localtotalsettleamt", (QFilter[])asstSettleRecordFilters.toArray(new QFilter[0]), null);
        DataSet settleRecords = mainSettleRecords.union(asstSettleRecords);
        mainSettleRecords.close();
        asstSettleRecords.close();
        DataSet groupBySettleRecords = settleRecords.groupBy(new String[]{"mainbillid"}).sum("totalsettleamt").sum("localtotalsettleamt").finish();
        settleRecords.close();
        DataSet copyOfSettleRecords = groupBySettleRecords.copy();
        HashSet<Long> reverseableBusIds = new HashSet<Long>();
        for (Row row : copyOfSettleRecords) {
            reverseableBusIds.add(row.getLong("mainbillid"));
        }
        copyOfSettleRecords.close();
        List baseFilters = finQueryParam.getFilters();
        baseFilters.add(new QFilter("bizdate", "<=", (Object)compareDate));
        baseFilters.add(new QFilter("iswrittenoff", "=", (Object)Boolean.FALSE));
        baseFilters.add(new QFilter("settlestatus", "in", (Object)new String[]{"unsettle", "partsettle"}).or(new QFilter("id", "in", reverseableBusIds)));
        AcctageFinAmtReverser acctageFinAmtReverser = new AcctageFinAmtReverser(groupBySettleRecords, finQueryParam);
        return new ArapAcctageDataProvider(finQueryParam, (AcctageAmtReverser)acctageFinAmtReverser).query();
    }

    private void setFinQueryInfo(boolean isShowLocalAmt, AcctageRptParam param) {
        MutablePair balanceField = new MutablePair((Object)"unsettleamount", (Object)"balance");
        if (isShowLocalAmt) {
            MutablePair localBalanceField = new MutablePair((Object)"unsettlelocalamt", (Object)"localbalance");
            param.setAnalysisAmtFields(new Pair[]{balanceField, localBalanceField});
        } else {
            param.setAnalysisAmtFields(new Pair[]{balanceField});
        }
        for (Pair anlaysisField : param.getAnalysisAmtFields()) {
            param.addStatisticalAmtField((String)anlaysisField.getKey(), (String)anlaysisField.getValue(), true);
        }
        param.addStatisticalAmtField("recamount", "recamt", true);
        if (isShowLocalAmt) {
            param.addStatisticalAmtField("reclocalamt", "localrecamt", true);
        }
        for (Pair anlaysisField : param.getAnalysisAmtFields()) {
            for (AcctageGroup group : param.getGroups()) {
                param.addStatisticalAmtField("", AcctageHelper.getAmountFieldName((AcctageGroup)group, (String)((String)anlaysisField.getValue())), false);
            }
        }
    }

    public DataSet queryBusData(AcctageRptParam busQueryParam, boolean autoSum) {
        this.setBusQueryInfo(busQueryParam);
        busQueryParam.setAutoSum(autoSum);
        busQueryParam.setRecoverHistoryData(true);
        Date queryDate = DateUtils.getDataFormat((Date)busQueryParam.getQueryDate(), (boolean)false);
        List filters = busQueryParam.getFilters();
        filters.add(new QFilter("bizdate", "<=", (Object)queryDate));
        filters.add(new QFilter("isadjust", "=", (Object)Boolean.FALSE));
        AcctageBusWoffAmtReverser apAcctageAmtReverser = new AcctageBusWoffAmtReverser(busQueryParam);
        DataSet busData = new ArapAcctageDataProvider(busQueryParam, (AcctageAmtReverser)apAcctageAmtReverser).query();
        return busData;
    }

    private void setBusQueryInfo(AcctageRptParam param) {
        MutablePair balanceField = new MutablePair((Object)"recamount", (Object)"balance");
        MutablePair localBalanceField = new MutablePair((Object)"reclocalamt", (Object)"localbalance");
        param.setAnalysisAmtFields(new Pair[]{balanceField, localBalanceField});
        for (Pair anlaysisField : param.getAnalysisAmtFields()) {
            param.addStatisticalAmtField((String)anlaysisField.getKey(), (String)anlaysisField.getValue(), true);
        }
        param.addStatisticalAmtField("recamount", "recamt", true);
        param.addStatisticalAmtField("reclocalamt", "localrecamt", true);
        for (Pair anlaysisField : param.getAnalysisAmtFields()) {
            for (AcctageGroup group : param.getGroups()) {
                param.addStatisticalAmtField("", AcctageHelper.getAmountFieldName((AcctageGroup)group, (String)((String)anlaysisField.getValue())), false);
            }
        }
    }

    public DataSet queryAll(AcctageRptParam finQueryParam, AcctageRptParam busQueryParam, boolean isShowLocalAmt) {
        boolean showByBill = finQueryParam.getStatisticalSumParam().getGroupByFields().contains("id");
        DataSet finData = this.queryFinData(finQueryParam, false, isShowLocalAmt);
        DataSet busData = this.queryBusData(busQueryParam, false);
        List busSelectedFields = DataSetUtils.getSelectedFields((DataSet)busData, (String[])new String[0]);
        HashSet hashSet = new HashSet(DataSetUtils.getSelectedFields((DataSet)finData, (String[])new String[0]));
        ArrayList<String> busSelectedFields2 = new ArrayList<String>();
        for (String f : busSelectedFields) {
            if (!hashSet.contains(f)) continue;
            if (showByBill) {
                busSelectedFields2.add(f);
                continue;
            }
            if ("recamt".equalsIgnoreCase(f)) {
                busSelectedFields2.add("balance recamt");
                continue;
            }
            if ("localrecamt".equalsIgnoreCase(f)) {
                busSelectedFields2.add("localbalance localrecamt");
                continue;
            }
            busSelectedFields2.add(f);
        }
        busData = busData.select(busSelectedFields2.toArray(new String[0]));
        DataSet unionData = DataSetUtils.union((DataSet)finData, (DataSet)busData);
        SumParam statisticalSumParam = finQueryParam.getStatisticalSumParam();
        DataSet groupByUnionData = DataSetUtils.sum((DataSet)unionData, (SumParam)statisticalSumParam);
        SumParam sumParam = finQueryParam.getSumParam();
        SumParam totalSumParam = finQueryParam.getTotalSumParam();
        return DataSetUtils.sum((DataSet)groupByUnionData, Arrays.asList(sumParam, totalSumParam));
    }

    public List<QFilter> getBaseFilters(AcctageRptParam param, boolean containsUnaudit) {
        List currencyIds;
        String asstactType;
        ArrayList<QFilter> filters = new ArrayList<QFilter>();
        List orgIds = param.getOrgIds();
        if (!orgIds.isEmpty()) {
            filters.add(new QFilter("org", "in", (Object)orgIds));
        }
        if (!ObjectUtils.isEmpty((Object)(asstactType = param.getAsstactType()))) {
            filters.add(new QFilter("asstacttype", "=", (Object)asstactType));
            List asstactPks = param.getAsstactPks();
            if (!ObjectUtils.isEmpty((Object)asstactPks)) {
                filters.add(new QFilter("asstact", "in", (Object)asstactPks));
            }
        }
        if ((currencyIds = param.getCurrencyIds()) != null && !currencyIds.isEmpty()) {
            filters.add(new QFilter("currency", "in", (Object)currencyIds));
        }
        if (containsUnaudit) {
            filters.add(new QFilter("billstatus", "in", (Object)new String[]{"B", "C"}));
        } else {
            filters.add(new QFilter("billstatus", "=", (Object)"C"));
        }
        List billTypes = param.getBillTypes();
        if (!ObjectUtils.isEmpty((Object)billTypes)) {
            List billTypeIds = DynamicObjectHelper.getIdList((Collection)billTypes);
            filters.add(new QFilter("billtype", "in", (Object)billTypeIds));
        }
        return filters;
    }
}

