/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.report.baddebt;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.RowMeta;
import kd.bos.algox.MapFunction;
import kd.bos.algox.RowX;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.util.TransformUtil;
import kd.fi.ar.helper.BadDebtAccrualHelper;
import kd.fi.ar.report.baddebt.BadDebtRptParam;
import kd.fi.arapcommon.report.acctage.AcctageGroup;
import kd.fi.arapcommon.report.acctage.AcctageHelper;
import org.apache.commons.lang.StringUtils;

@Deprecated
public class AgingGroupAmtColMapFunc
extends MapFunction {
    private static final long serialVersionUID = -3665458614490051234L;
    private Set<String> showQtyCols;
    private RowMeta rowMeta;
    private Map<String, Integer> indexs;
    private List<AcctageGroup> groups;
    private Map<Object, Date> queryDateMap;
    private boolean showPeriodResult;
    private String dateKey;

    public AgingGroupAmtColMapFunc(RowMeta rowMeta, ReportDataCtx ctx) {
        this.rowMeta = rowMeta;
        this.showQtyCols = ctx.getShowQtyCols();
        BadDebtRptParam badDebtRptParam = (BadDebtRptParam)ctx.getParam("baddebtparam");
        this.groups = badDebtRptParam.getGroups();
        this.queryDateMap = badDebtRptParam.getQueryDateMap();
        this.showPeriodResult = badDebtRptParam.isShowPeriodResult();
        this.dateKey = this.showPeriodResult ? "org" : "period";
        this.buildIndexs();
    }

    private void buildIndexs() {
        this.indexs = new HashMap<String, Integer>(8);
        ArrayList<String> cols = new ArrayList<String>(8);
        cols.add("bizdate");
        cols.add(this.dateKey);
        cols.addAll(this.showQtyCols);
        cols.addAll(BadDebtAccrualHelper.getAgingGroupCols(this.showQtyCols, this.groups));
        this.indexs = TransformUtil.buildIndexs((RowMeta)this.rowMeta, cols);
    }

    public RowX map(RowX row) {
        Date bizDate = row.getDate(this.indexs.get("bizdate").intValue());
        Object key = row.get(this.indexs.get(this.dateKey).intValue());
        Date queryDate = this.queryDateMap.get(key);
        block0: for (String sumNumCol : this.showQtyCols) {
            if (!StringUtils.contains((String)sumNumCol, (String)"standard")) continue;
            BigDecimal amt = row.getBigDecimal(this.indexs.get(sumNumCol).intValue());
            for (AcctageGroup group : this.groups) {
                if (!AcctageHelper.match((AcctageGroup)group, (Date)queryDate, (Date)bizDate)) continue;
                String balanceField = AcctageHelper.getAmountFieldName((AcctageGroup)group, (String)sumNumCol);
                int index = this.indexs.get(balanceField);
                row.set(index, (Object)amt);
                continue block0;
            }
        }
        return row;
    }

    public RowMeta getResultRowMeta() {
        return this.rowMeta;
    }
}

