/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.report.baddebt;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.report.AbstractReportColumn;
import kd.bos.entity.report.ReportColumn;
import kd.bos.entity.report.ReportColumnGroup;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bplat.scmc.report.conf.SrcBlockConf;
import kd.bplat.scmc.report.core.ReportDataCtx;
import kd.bplat.scmc.report.core.tpl.IDataTransform;
import kd.bplat.scmc.report.core.tpl.IDataXTransform;
import kd.bplat.scmc.report.core.tpl.IReportDataHandle;
import kd.bplat.scmc.report.core.transform.plan.GroupPlan;
import kd.fi.ar.report.baddebt.BadDebtRptParam;
import kd.fi.ar.report.baddebt.HandleOrderByColumn;
import org.apache.commons.lang.StringUtils;

public class BadDebtRptHandler
implements IReportDataHandle {
    private BadDebtRptParam badDebtRptParam;

    public void setupCtx(ReportDataCtx ctx) {
        this.badDebtRptParam = (BadDebtRptParam)ctx.getParam("baddebtparam");
        ctx.setShowBlockEntity(false);
        List fixedFs = ctx.getFixedFs();
        if (fixedFs == null) {
            ctx.setFixedFs(this.getDataSourcesFilter());
        } else {
            fixedFs.addAll(this.getDataSourcesFilter());
        }
        this.setCountQtyCols(ctx);
    }

    private void handleQueryDate() {
        List<Object> orgIds = this.badDebtRptParam.getOrgIds();
        QFilter orgFilter = new QFilter("org", "in", orgIds);
        DynamicObject[] inits = BusinessDataServiceHelper.load((String)"ar_init", (String)"id,org, startperiod", (QFilter[])new QFilter[]{orgFilter});
        HashMap<Object, Date> queryDateMap = new HashMap<Object, Date>(orgIds.size());
        for (DynamicObject init : inits) {
            DynamicObject org = init.getDynamicObject("org");
            DynamicObject startPeriod = init.getDynamicObject("startperiod");
            queryDateMap.put(org.get("id"), startPeriod.getDate("enddate"));
        }
        this.badDebtRptParam.setQueryDateMap(queryDateMap);
    }

    private void setCountQtyCols(ReportDataCtx ctx) {
        Set qtyCols = ctx.getShowQtyCols();
        Set showKeyCols = ctx.getShowKeyCols();
        showKeyCols.add("org");
        if (this.badDebtRptParam.isShowByBill()) {
            qtyCols.add("recamount");
            showKeyCols.add("baddebtbillno");
            showKeyCols.add("srcid");
        }
        if (this.badDebtRptParam.isShowByBill() && this.badDebtRptParam.isHyperLink()) {
            showKeyCols.add("agingrange");
            showKeyCols.add("srcentryid");
            showKeyCols.add("entryseq");
        }
        ctx.setSumQtyCols4Count(qtyCols);
    }

    public void modifyBlocks(List<SrcBlockConf> blockCollector, ReportDataCtx ctx) {
        for (SrcBlockConf blockConf : blockCollector) {
            String entity = this.badDebtRptParam.getEntity();
            if (!"all".equals(entity)) {
                QFilter filter = new QFilter("sourcebilltype", "=", (Object)entity);
                QFilter dataFs = blockConf.getDataFs();
                blockConf.setDataFs(filter.and(dataFs));
            }
            blockConf.setAllowNotMatch(true);
        }
    }

    public void handleBigtableCols(Set<String> repoColFilter, ReportDataCtx ctx) {
        repoColFilter.add("id");
        repoColFilter.add("bizdate");
        repoColFilter.add("period");
        repoColFilter.add("org");
        if (this.badDebtRptParam.isShowByBill()) {
            repoColFilter.add("sourceentity");
            repoColFilter.add("billno");
        }
    }

    public void handleBlockDataSelectCols(Set<String> repoColFilter, SrcBlockConf blockConf, ReportDataCtx ctx) {
        Map repoColFullSrcColMap = blockConf.getRepoColFullSrcColMap();
        repoColFullSrcColMap.put("id", "id");
        repoColFullSrcColMap.put("entryseq", "entry.seq");
    }

    public void transFormAfterUnion(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
    }

    public void beforeGroupData(ReportDataCtx ctx) {
        if (this.badDebtRptParam.isShowByBill()) {
            GroupPlan groupPlan = ctx.getGroupPlan();
            Collection keyCols = groupPlan.getKeyCols();
            if (!this.badDebtRptParam.isHyperLink()) {
                keyCols.add("id");
                keyCols.add("billno");
                keyCols.add("bizdate");
                keyCols.add("sourceentity");
            } else {
                keyCols.add("id");
                keyCols.add("billno");
                keyCols.add("sourceentity");
            }
        }
    }

    public void transFormAfterGroup(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
        boolean isHasPeriod = ctx.getShowKeyCols().contains("period");
        if (isHasPeriod || this.badDebtRptParam.isShowByBill()) {
            transCollector.add(new HandleOrderByColumn(ctx));
        }
    }

    public void beforeAddSumRow(ReportDataCtx ctx) {
    }

    public void transFormAfterAddSumRow(List<IDataXTransform> transCollector, ReportDataCtx ctx) {
    }

    public void transformResult(List<IDataTransform> transCollector, ReportDataCtx ctx) {
    }

    public List<AbstractReportColumn> buildShowColumn(List<AbstractReportColumn> columns, ReportDataCtx ctx) {
        String fieldKey;
        Object column;
        ArrayList<AbstractReportColumn> showCols = new ArrayList<AbstractReportColumn>(8);
        boolean isShowLocalAmt = this.badDebtRptParam.isShowLocalAmt();
        boolean showByBill = this.badDebtRptParam.isShowByBill();
        if (showByBill) {
            for (AbstractReportColumn col : columns) {
                column = (ReportColumn)col;
                fieldKey = column.getFieldKey();
                if (!"billno".equals(fieldKey) && !"baddebtbillno".equals(fieldKey)) continue;
                column.setHyperlink(true);
            }
        }
        if (isShowLocalAmt) {
            ArrayList<AbstractReportColumn> locColumns = new ArrayList<AbstractReportColumn>(2);
            ArrayList<AbstractReportColumn> orignColumns = new ArrayList<AbstractReportColumn>(2);
            for (AbstractReportColumn col : columns) {
                ReportColumn column2 = (ReportColumn)col;
                if ("amount".equals(column2.getFieldType())) {
                    column2.setZeroShow(true);
                    if (StringUtils.endsWith((String)column2.getFieldKey(), (String)"localamt")) {
                        locColumns.add(col);
                        continue;
                    }
                    orignColumns.add(col);
                    continue;
                }
                showCols.add(col);
            }
            ReportColumnGroup columnGroup = this.createColumnGroup("orignalamtgroup", orignColumns);
            showCols.add((AbstractReportColumn)columnGroup);
            ReportColumnGroup locColumnGroup = this.createColumnGroup("localamtgroup", locColumns);
            showCols.add((AbstractReportColumn)locColumnGroup);
        } else {
            for (AbstractReportColumn col : columns) {
                column = (ReportColumn)col;
                fieldKey = column.getFieldKey();
                if (StringUtils.endsWith((String)fieldKey, (String)"localamt")) continue;
                if ("amount".equals(column.getFieldType())) {
                    column.setZeroShow(true);
                }
                if ("standardamt".equals(fieldKey)) {
                    column.setHyperlink(!this.badDebtRptParam.isShowByBill());
                }
                showCols.add((AbstractReportColumn)column);
            }
        }
        return showCols;
    }

    private ReportColumnGroup createColumnGroup(String groupKey, List<AbstractReportColumn> amtColumns) {
        String caption = ResManager.loadKDString((String)"\u539f\u5e01", (String)"AcctageRptHandle_1", (String)"fi-arapcommon", (Object[])new Object[0]);
        if (!"orignalamtgroup".equals(groupKey)) {
            caption = ResManager.loadKDString((String)"\u672c\u4f4d\u5e01", (String)"AcctageRptHandle_2", (String)"fi-arapcommon", (Object[])new Object[0]);
        }
        ReportColumnGroup columnGroup = new ReportColumnGroup();
        columnGroup.setCaption(new LocaleString(caption));
        columnGroup.setFieldKey(groupKey);
        Set<String> localAmtField = this.getLocalAmtField();
        for (AbstractReportColumn abstractReportColumn : amtColumns) {
            ReportColumn reportColumn = (ReportColumn)abstractReportColumn;
            String key = reportColumn.getFieldKey();
            if (localAmtField.contains(key)) {
                LocaleString columnCaption = reportColumn.getCaption();
                String columnName = reportColumn.getCaption().getLocaleValue();
                columnCaption.setLocaleValue(columnName.replaceAll("\\(" + caption + "\\)", ""));
            }
            if ("standardamt".equals(key)) {
                reportColumn.setHyperlink(!this.badDebtRptParam.isShowByBill());
            }
            columnGroup.getChildren().add(reportColumn);
        }
        return columnGroup;
    }

    private Set<String> getLocalAmtField() {
        HashSet<String> localAmtField = new HashSet<String>();
        localAmtField.add("reclocalamt");
        localAmtField.add("standardlocalamt");
        localAmtField.add("curaccruedlocalamt");
        localAmtField.add("lastaccruedlocalamt");
        localAmtField.add("losslocalamt");
        localAmtField.add("curaccruallocalamt");
        return localAmtField;
    }

    private List<QFilter> getDataSourcesFilter() {
        List<Object> periodIds;
        List<QFilter> filters = this.badDebtRptParam.getFilters();
        List<Object> orgIds = this.badDebtRptParam.getOrgIds();
        if (!orgIds.isEmpty()) {
            filters.add(new QFilter("org", "in", orgIds));
        }
        if (!ObjectUtils.isEmpty(periodIds = this.badDebtRptParam.getPeriodIds())) {
            filters.add(new QFilter("period", "in", periodIds));
        } else if (!this.badDebtRptParam.isShowPeriodResult()) {
            filters.add(new QFilter("period", "!=", (Object)0L));
        }
        String asstactType = this.badDebtRptParam.getAsstactType();
        if (!ObjectUtils.isEmpty((Object)asstactType)) {
            filters.add(new QFilter("asstacttype", "=", (Object)asstactType));
            List<Object> asstactPks = this.badDebtRptParam.getAsstactPks();
            if (!ObjectUtils.isEmpty(asstactPks)) {
                filters.add(new QFilter("asstact", "in", asstactPks));
            }
        } else {
            filters.add(new QFilter("asstacttype", "in", Arrays.asList("bd_supplier", "bd_customer", "bos_user")));
        }
        List<Object> currencyIds = this.badDebtRptParam.getCurrencyIds();
        if (currencyIds != null && !currencyIds.isEmpty()) {
            filters.add(new QFilter("currency", "in", currencyIds));
        }
        return filters;
    }
}

