/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.ar.report.detail;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.JoinDataSet;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.report.AbstractReportListDataPlugin;
import kd.bos.entity.report.FilterInfo;
import kd.bos.entity.report.ReportQueryParam;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.balance.BalJouMapper;
import kd.fi.arapcommon.balance.BalanceQuerier;
import kd.fi.arapcommon.balance.BalanceType;
import kd.fi.arapcommon.helper.DynamicObjectHelper;
import kd.fi.arapcommon.report.DefaultCustomSettingParser;
import kd.fi.arapcommon.report.ReportHelper;
import kd.fi.arapcommon.report.RptCustomSettingParser;
import kd.fi.arapcommon.report.SumParam;
import kd.fi.arapcommon.util.DataSetUtils;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.vo.ARAPSumParam;

public class ArDetailListDataRpt
extends AbstractReportListDataPlugin {
    private static final Log LOGGER = LogFactory.getLog(AbstractReportListDataPlugin.class);
    private static final String SUM_LEVEL = "sumlevel";
    private RptCustomSettingParser customSettingParser;
    private FilterInfo filterInfo;
    private BalJouMapper mapper;
    private ARAPSumParam param;
    private List<String> balanceDimensions;
    private List<String> journalDimensions;

    public DataSet query(ReportQueryParam queryParam, Object arg1) throws Throwable {
        try {
            return this.query(queryParam);
        }
        catch (Exception e) {
            LOGGER.error((Throwable)e);
            throw e;
        }
    }

    private DataSet query(ReportQueryParam queryParam) {
        this.prepareQueryParam(queryParam);
        DataSet detailData = this.queryDetailData();
        DataSet balanceData = this.queryPeriodBalance(detailData);
        DataSet journalBalanceRawData = detailData.union(balanceData);
        DataSet sumData = this.sum(journalBalanceRawData);
        journalBalanceRawData = journalBalanceRawData.union(sumData);
        if (this.param.isNotShowZero()) {
            journalBalanceRawData = this.filterZeroBalanceData(journalBalanceRawData, sumData);
        }
        if (this.param.isNotShowNull()) {
            journalBalanceRawData = this.filterNoBizData(journalBalanceRawData);
        }
        if (this.param.isNotShowNullAndZero()) {
            journalBalanceRawData = this.filterNotShowNullAndZero(journalBalanceRawData, sumData);
        }
        DataSet totalSumData = this.totalSum(journalBalanceRawData);
        LinkedList<String> orderByFields = new LinkedList<String>();
        for (String journalDimension : this.journalDimensions) {
            orderByFields.add(journalDimension + " desc");
        }
        orderByFields.add(SUM_LEVEL);
        orderByFields.add("bizdate asc");
        DataSet union = journalBalanceRawData.union(totalSumData).orderBy(orderByFields.toArray(new String[0]));
        return this.createResult(union);
    }

    private void prepareQueryParam(ReportQueryParam queryParam) {
        this.filterInfo = queryParam.getFilter();
        this.customSettingParser = new DefaultCustomSettingParser(queryParam);
        this.param = this.getSumParam(queryParam);
        this.mapper = BalJouMapper.getMapper((boolean)false);
        this.balanceDimensions = this.customSettingParser.getStatisticalDimensions();
        this.journalDimensions = this.balanceDimensions.stream().map(bd -> this.mapper.getJournalField(bd)).collect(Collectors.toList());
    }

    private DataSet queryDetailData() {
        List<QFilter> journalFilters = this.getJournalFilters();
        List<String> journalSelectors = this.getJournalSelectors();
        DataSet journals = QueryServiceHelper.queryDataSet((String)"commonquery", (String)"ar_journal", (String)String.join((CharSequence)",", journalSelectors), (QFilter[])journalFilters.toArray(new QFilter[0]), null);
        journals = this.param.isShowMainCurrency() ? (this.isContainsReceived() ? journals.filter("receivableamt<>0 or settleamt<>0 or recsettleamt <> 0 or receivedamt<>0 or localreceivableamt <> 0 or localsettleamt <> 0 or localrecsettleamt <> 0 or localreceivedamt <> 0") : journals.filter("(biztype <> 'recpaysettle' and biztype <> 'payrecsettle') and (receivableamt<>0 or settleamt<>0 or receivedamt<>0 or localreceivableamt <> 0 or localsettleamt <> 0 or localreceivedamt <> 0)")) : (this.isContainsReceived() ? journals.filter("receivableamt<>0 or settleamt<>0 or recsettleamt <> 0 or receivedamt<>0") : journals.filter("(biztype <> 'recpaysettle' and biztype <> 'payrecsettle') and (receivableamt<>0 or settleamt<>0 or receivedamt<>0)"));
        ArrayList<String> rawDataSelectors = new ArrayList<String>(32);
        rawDataSelectors.addAll(this.journalDimensions);
        rawDataSelectors.add("receivableamt");
        rawDataSelectors.add("localreceivableamt");
        rawDataSelectors.add("settleamt");
        rawDataSelectors.add("localsettleamt");
        rawDataSelectors.add("recsettleamt");
        rawDataSelectors.add("localrecsettleamt");
        rawDataSelectors.add("receivedamt");
        rawDataSelectors.add("localreceivedamt");
        rawDataSelectors.add("0 balance");
        rawDataSelectors.add("0 localbalance");
        rawDataSelectors.add("billno");
        rawDataSelectors.add("billstatus");
        rawDataSelectors.add("biztype");
        rawDataSelectors.add("bizdate");
        rawDataSelectors.add("0 sumlevel");
        rawDataSelectors.add("0 rowtype");
        rawDataSelectors.add("sourcebilltype type");
        rawDataSelectors.add("sourcebillid billid");
        LinkedList<String> groupbyField = new LinkedList<String>();
        groupbyField.addAll(this.journalDimensions);
        groupbyField.add("billno");
        groupbyField.add("billstatus");
        groupbyField.add("biztype");
        groupbyField.add("bizdate");
        groupbyField.add("sourcebilltype");
        groupbyField.add("sourcebillid");
        journals = journals.groupBy(groupbyField.toArray(new String[0])).sum("receivableamt").sum("localreceivableamt").sum("settleamt").sum("localsettleamt").sum("recsettleamt").sum("localrecsettleamt").sum("receivedamt").sum("localreceivedamt").finish();
        return journals.select(String.join((CharSequence)",", rawDataSelectors));
    }

    private List<QFilter> getCommonFilters(String entityKey) {
        QFilter asstactTypeFilter;
        String dateProKey = "bizdate";
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        QFilter orgFilter = new QFilter("org", "in", (Object)DynamicObjectHelper.getLongIds((Collection)this.param.getOrgs()));
        QFilter dateFilter = new QFilter(dateProKey, ">=", (Object)this.param.getStartDate()).and(new QFilter(dateProKey, "<=", (Object)this.param.getStopDate()));
        filters.add(orgFilter);
        filters.add(dateFilter);
        if (!EmptyUtils.isEmpty((Object)this.param.getAsstactType())) {
            String asstactTypeKey = "asstacttype";
            asstactTypeFilter = new QFilter(asstactTypeKey, "=", (Object)this.param.getAsstactType());
            filters.add(asstactTypeFilter);
        } else {
            filters.add(new QFilter("asstacttype", "in", Arrays.asList("bd_supplier", "bd_customer", "bos_user")));
        }
        if (!EmptyUtils.isEmpty((Object)this.param.getAsstact())) {
            String asstactKey = "asstact";
            asstactTypeFilter = new QFilter(asstactKey, "in", (Object)DynamicObjectHelper.getLongIds((Collection)this.param.getAsstact()));
            filters.add(asstactTypeFilter);
        }
        if (!EmptyUtils.isEmpty((Object)this.param.getCurrencys())) {
            String currencyKey = "currency";
            asstactTypeFilter = new QFilter(currencyKey, "in", (Object)DynamicObjectHelper.getLongIds((Collection)this.param.getCurrencys()));
            filters.add(asstactTypeFilter);
        }
        return filters;
    }

    private List<String> getJournalSelectors() {
        List balanceDimensions = this.customSettingParser.getStatisticalDimensions();
        List dimensions = balanceDimensions.stream().map(bd -> this.mapper.getJournalField(bd)).collect(Collectors.toList());
        ArrayList<String> selectors = new ArrayList<String>(8);
        selectors.addAll(dimensions);
        String receivableAmtExpression = "case when SOURCEBILLTYPE='ar_finarbill' then receivableamt when SOURCEBILLTYPE='ar_busbill' then estimatedamt else 0 end as receivableamt";
        selectors.add(receivableAmtExpression);
        String localReceivableAmtExpression = "case when SOURCEBILLTYPE='ar_finarbill' then localreceivableamt when SOURCEBILLTYPE='ar_busbill' then localestimatedamt else 0 end as localreceivableamt";
        selectors.add(localReceivableAmtExpression);
        if (this.isContainsReceived()) {
            String notCasSettleRealtionExp = "BIZTYPE<>'recpaysettle' and BIZTYPE<> 'payrecsettle' and BIZTYPE<>'payself' and BIZTYPE<>'recself'";
            String settleAmtExpression = "case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and " + notCasSettleRealtionExp + "  then 0-receivableamt else 0 end as settleamt";
            selectors.add(settleAmtExpression);
            String localSettleAmtExpression = "case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and " + notCasSettleRealtionExp + " then 0-localreceivableamt else 0 end as localsettleamt";
            selectors.add(localSettleAmtExpression);
            String casSettleRealtionExp = "BIZTYPE IN ('recsettle','recpaysettle','payrecsettle','recself','baddebtrecovery','aprecsettle','recclearing')";
            String casSettleAmtExpression = "case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and " + casSettleRealtionExp + " then 0-receivedamt else 0 end as recsettleamt";
            selectors.add(casSettleAmtExpression);
            String localCasSettleAmtExpression = "case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and " + casSettleRealtionExp + " then 0-localreceivedamt else 0 end as localrecsettleamt";
            selectors.add(localCasSettleAmtExpression);
            String receivedAmtExpression = "case when SOURCEBILLTYPE in ('cas_recbill','ar_receivedbill') then receivedamt else 0 end as receivedamt";
            selectors.add(receivedAmtExpression);
            String localReceivedAmtExpression = "case when SOURCEBILLTYPE in ('cas_recbill','ar_receivedbill') then localreceivedamt else 0 end as localreceivedamt";
            selectors.add(localReceivedAmtExpression);
        } else {
            String notCasSettleRealtionExp = "BIZTYPE<>'recpaysettle' and BIZTYPE<> 'payrecsettle' and BIZTYPE<>'recself'";
            selectors.add("case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and (" + notCasSettleRealtionExp + ") then 0-receivableamt else 0 end as settleamt");
            selectors.add("case when SOURCEBILLTYPE in ('ap_settlerecord','ar_settlerecord') and (" + notCasSettleRealtionExp + ") then 0-localreceivableamt else 0 end as localsettleamt");
            selectors.add("0 receivedamt");
            selectors.add("0 localreceivedamt");
            selectors.add("0 recsettleamt");
            selectors.add("0 localrecsettleamt");
        }
        selectors.add("case when SOURCEBILLTYPE='cas_paybill' then 'D' else 'C' end as billstatus");
        selectors.add("sourcebilltype");
        selectors.add("sourcebillid");
        selectors.add("biztype");
        selectors.add("billno");
        selectors.add("bizdate");
        return selectors;
    }

    private List<QFilter> getJournalFilters() {
        String billScope = this.filterInfo.getString("billscope");
        ArrayList<String> sourceEntityKeys = new ArrayList<String>(8);
        if ("ar_finarbill".equals(billScope)) {
            sourceEntityKeys.add("ar_finarbill");
            sourceEntityKeys.add("ar_settlerecord");
            sourceEntityKeys.add("ap_settlerecord");
        } else if ("ar_busbill".equals(billScope)) {
            sourceEntityKeys.add("ar_busbill");
        } else if ("ALL".equals(billScope)) {
            sourceEntityKeys.add("ar_finarbill");
            sourceEntityKeys.add("ar_settlerecord");
            sourceEntityKeys.add("ap_settlerecord");
            sourceEntityKeys.add("ar_busbill");
        } else {
            throw new KDBizException("Unsupported Report Data Source : " + billScope);
        }
        if (this.isContainsReceived()) {
            sourceEntityKeys.add("cas_recbill");
            sourceEntityKeys.add("ar_receivedbill");
        }
        List<QFilter> filters = this.getCommonFilters("ar_journal");
        filters.add(new QFilter("sourcebilltype", "in", sourceEntityKeys));
        filters.addAll(this.customSettingParser.getCustomFilters());
        return filters;
    }

    private DataSet queryPeriodBalance(DataSet detailData) {
        List<QFilter> balanceCustomFilters = this.getBalanceCustomFilters();
        BalanceQuerier balanceQuerier = new BalanceQuerier(this.getBalanceType());
        List orgIds = DynamicObjectHelper.getLongIds((Collection)this.param.getOrgs());
        DataSet balanceData = balanceQuerier.queryBalance(orgIds, this.param.getStartDate(), this.balanceDimensions, balanceCustomFilters);
        balanceData = this.replenishBalance(balanceData, detailData);
        ArrayList<String> balanceFields = new ArrayList<String>(20);
        balanceFields.addAll(this.balanceDimensions);
        balanceFields.add("0 receivableamt");
        balanceFields.add("0 localreceivableamt");
        balanceFields.add("0 settleamt");
        balanceFields.add("0 localsettleamt");
        balanceFields.add("0 recsettleamt");
        balanceFields.add("0 localrecsettleamt");
        balanceFields.add("0 receivedamt");
        balanceFields.add("0 localreceivedamt");
        balanceFields.add("periodamt balance");
        balanceFields.add("localperiodamt localbalance");
        balanceFields.add("'' billno");
        balanceFields.add("'' billstatus");
        balanceFields.add("'' biztype");
        balanceFields.add("null bizdate");
        balanceFields.add("-1 sumlevel");
        balanceFields.add("-1 rowtype");
        balanceFields.add("'periodbalance' type");
        balanceFields.add("0 billid");
        return balanceData.select(String.join((CharSequence)",", balanceFields));
    }

    private BalanceType getBalanceType() {
        String billScope = this.filterInfo.getString("billscope");
        if ("ar_finarbill".equals(billScope)) {
            return this.isContainsReceived() ? BalanceType.AR_FIN_RECEIVED : BalanceType.AR_FIN;
        }
        if ("ar_busbill".equals(billScope)) {
            return this.isContainsReceived() ? BalanceType.AR_BUS_RECEIVED : BalanceType.AR_BUS;
        }
        if ("ALL".equals(billScope)) {
            return this.isContainsReceived() ? BalanceType.AR_FIN_BUS_RECEIVED : BalanceType.AR_FIN_BUS;
        }
        throw new KDBizException("Unsupported Report Data Source : " + billScope);
    }

    private List<QFilter> getBalanceCustomFilters() {
        ArrayList<QFilter> filters = new ArrayList<QFilter>(8);
        if (!EmptyUtils.isEmpty((Object)this.param.getAsstactType())) {
            filters.add(new QFilter("asstacttype", "=", (Object)this.param.getAsstactType()));
        } else {
            filters.add(new QFilter("asstacttype", "in", Arrays.asList("bd_supplier", "bd_customer", "bos_user")));
        }
        if (!EmptyUtils.isEmpty((Object)this.param.getAsstact())) {
            filters.add(new QFilter("asstact", "in", (Object)DynamicObjectHelper.getLongIds((Collection)this.param.getAsstact())));
        }
        if (!EmptyUtils.isEmpty((Object)this.param.getCurrencys())) {
            filters.add(new QFilter("currency", "in", (Object)DynamicObjectHelper.getLongIds((Collection)this.param.getCurrencys())));
        }
        filters.addAll(this.customSettingParser.getCustomFilters());
        return filters;
    }

    private DataSet replenishBalance(DataSet balanceData, DataSet detailData) {
        DataSet finish = detailData.groupBy(this.journalDimensions.toArray(new String[0])).count().finish();
        List selectedFields = DataSetUtils.getSelectedFields((DataSet)balanceData, (String[])new String[0]);
        ArrayList<String> aliasExchangeExp = new ArrayList<String>(selectedFields.size());
        HashMap<String, String> balanceFieldAliasMap = new HashMap<String, String>(selectedFields.size());
        for (String f : selectedFields) {
            String alias = f + "_alias";
            balanceFieldAliasMap.put(f, alias);
            aliasExchangeExp.add(f + " " + alias);
        }
        balanceData = balanceData.select(String.join((CharSequence)",", aliasExchangeExp));
        JoinDataSet join = balanceData.join(finish, JoinType.FULL);
        for (int i = 0; i < this.balanceDimensions.size(); ++i) {
            join.on((String)balanceFieldAliasMap.get(this.balanceDimensions.get(i)), this.journalDimensions.get(i));
        }
        balanceData = join.select(balanceFieldAliasMap.values().toArray(new String[0]), this.journalDimensions.toArray(new String[0])).finish();
        ArrayList<String> noNullExp = new ArrayList<String>(this.balanceDimensions.size() + balanceFieldAliasMap.size());
        for (int i = 0; i < this.balanceDimensions.size(); ++i) {
            String balanceField2 = this.balanceDimensions.get(i);
            String balanceAlias2 = (String)balanceFieldAliasMap.remove(balanceField2);
            String journalField = this.journalDimensions.get(i);
            noNullExp.add(String.format("case when %s=null then %s else %s end as %s", balanceAlias2, journalField, balanceAlias2, balanceField2));
        }
        balanceFieldAliasMap.forEach((balanceField, balanceAlias) -> noNullExp.add(String.format("case when %s=null then 0 else %s end as %s", balanceAlias, balanceAlias, balanceField)));
        return balanceData.select(String.join((CharSequence)",", noNullExp));
    }

    private DataSet filterNoBizData(DataSet journalBalanceRawData) {
        List selectedFields = DataSetUtils.getSelectedFields((DataSet)journalBalanceRawData, (String[])new String[0]);
        DataSet finish = journalBalanceRawData.groupBy(this.journalDimensions.toArray(new String[0])).count().finish();
        JoinDataSet join = journalBalanceRawData.join(finish);
        for (String jd : this.journalDimensions) {
            join = join.on(jd, jd);
        }
        journalBalanceRawData = join.select(selectedFields.toArray(new String[0]), new String[]{"count"}).finish();
        return journalBalanceRawData.filter("count > 2 ");
    }

    private DataSet filterZeroBalanceData(DataSet journalBalanceRawData, DataSet sumData) {
        List selectedFields = DataSetUtils.getSelectedFields((DataSet)journalBalanceRawData, (String[])new String[0]);
        JoinDataSet join = journalBalanceRawData.join(sumData, JoinType.LEFT);
        for (String jd : this.journalDimensions) {
            join = join.on(jd, jd);
        }
        if (this.param.isShowMainCurrency()) {
            journalBalanceRawData = join.select(selectedFields.toArray(new String[0]), new String[]{"balance balance2", "localbalance localbalance2"}).finish();
            return journalBalanceRawData.filter("balance2 <> 0 or localbalance2 <> 0");
        }
        journalBalanceRawData = join.select(selectedFields.toArray(new String[0]), new String[]{"balance balance2"}).finish();
        return journalBalanceRawData.filter("balance2 <> 0");
    }

    private DataSet filterNotShowNullAndZero(DataSet journalBalanceRawData, DataSet sumData) {
        JoinDataSet countJoin;
        DataSet finish;
        List selectedFields = DataSetUtils.getSelectedFields((DataSet)journalBalanceRawData, (String[])new String[0]);
        JoinDataSet join = journalBalanceRawData.join(sumData, JoinType.LEFT);
        for (String jd : this.journalDimensions) {
            join = join.on(jd, jd);
        }
        if (this.param.isShowMainCurrency()) {
            journalBalanceRawData = join.select(selectedFields.toArray(new String[0]), new String[]{"balance balance3", "localbalance localbalance3"}).finish();
            finish = journalBalanceRawData.groupBy(this.journalDimensions.toArray(new String[0])).count().finish();
            countJoin = journalBalanceRawData.join(finish);
            for (String jd : this.journalDimensions) {
                countJoin = countJoin.on(jd, jd);
            }
            if (!this.param.isNotShowNull()) {
                journalBalanceRawData = countJoin.select(DataSetUtils.getSelectedFields((DataSet)journalBalanceRawData, (String[])new String[0]).toArray(new String[0]), new String[]{"count"}).finish();
            }
            return journalBalanceRawData.filter("balance3 <> 0 or localbalance3 <> 0 or count > 2");
        }
        journalBalanceRawData = join.select(selectedFields.toArray(new String[0]), new String[]{"balance balance3"}).finish();
        finish = journalBalanceRawData.groupBy(this.journalDimensions.toArray(new String[0])).count().finish();
        countJoin = journalBalanceRawData.join(finish);
        for (String jd : this.journalDimensions) {
            countJoin = countJoin.on(jd, jd);
        }
        if (!this.param.isNotShowNull()) {
            journalBalanceRawData = countJoin.select(DataSetUtils.getSelectedFields((DataSet)journalBalanceRawData, (String[])new String[0]).toArray(new String[0]), new String[]{"count"}).finish();
        }
        return journalBalanceRawData.filter("balance3 <> 0 or count > 2");
    }

    private DataSet totalSum(DataSet rawDataSet) {
        rawDataSet = rawDataSet.filter("rowtype=1");
        SumParam totalSumParam = new SumParam(SumParam.SumType.TOTAL);
        totalSumParam.addSummaryField(new String[]{"receivableamt", "localreceivableamt", "settleamt", "localsettleamt", "recsettleamt", "localrecsettleamt", "receivedamt", "localreceivedamt", "balance", "localbalance"});
        DataSet totalSumData = DataSetUtils.sum((DataSet)rawDataSet, (SumParam)totalSumParam);
        List totalSumDataSetFields = DataSetUtils.getSelectedFields((DataSet)rawDataSet, (String[])new String[0]).stream().map(f -> {
            if ("type".equalsIgnoreCase((String)f)) {
                return "'totalsum' type";
            }
            if (SUM_LEVEL.equalsIgnoreCase((String)f)) {
                return "2 sumlevel";
            }
            return f;
        }).collect(Collectors.toList());
        totalSumData = totalSumData.select(String.join((CharSequence)",", totalSumDataSetFields));
        return totalSumData;
    }

    private DataSet sum(DataSet journalBalanceRawData) {
        List<String> sumFields = Arrays.asList("receivableamt", "localreceivableamt", "receivedamt", "localreceivedamt", "settleamt", "localsettleamt", "recsettleamt", "localrecsettleamt", "balance", "localbalance");
        SumParam sumParam = new SumParam(SumParam.SumType.SUM);
        sumParam.setGroupByFields(this.journalDimensions);
        sumParam.setSummaryFields(sumFields);
        DataSet sumData = DataSetUtils.sum((DataSet)journalBalanceRawData, (SumParam)sumParam);
        List sumDataFields = DataSetUtils.getSelectedFields((DataSet)sumData, (String[])new String[0]).stream().map(f -> {
            if ("type".equalsIgnoreCase((String)f)) {
                return "'sum' type";
            }
            if (SUM_LEVEL.equalsIgnoreCase((String)f)) {
                return "1 sumlevel";
            }
            if ("balance".equalsIgnoreCase((String)f)) {
                return "balance+receivableamt-receivedamt-settleamt+recsettleamt balance";
            }
            if ("localbalance".equalsIgnoreCase((String)f)) {
                return "localbalance+localreceivableamt-localreceivedamt-localsettleamt+localrecsettleamt localbalance";
            }
            if ("rowtype".equalsIgnoreCase((String)f)) {
                return "1 rowtype";
            }
            return f;
        }).collect(Collectors.toList());
        sumData = sumData.select(String.join((CharSequence)",", sumDataFields));
        return sumData;
    }

    private boolean isContainsReceived() {
        return this.filterInfo.getBoolean("containsreceived");
    }

    private ARAPSumParam getSumParam(ReportQueryParam queryParam) {
        FilterInfo filterInfo = queryParam.getFilter();
        ARAPSumParam param = new ARAPSumParam();
        param.setOrgs(filterInfo.getDynamicObjectCollection("orgs"));
        param.setAsstactType(filterInfo.getString("q_asstacttype"));
        if (!EmptyUtils.isEmpty((Object)param.getAsstactType())) {
            DynamicObjectCollection asstacts = filterInfo.getDynamicObjectCollection(param.getAsstactType());
            param.setAsstact(ReportHelper.getBasedatas((DynamicObjectCollection)asstacts));
        }
        param.setCurrencys(filterInfo.getDynamicObjectCollection("currencys"));
        param.setStartDate(DateUtils.getDataFormat((Date)filterInfo.getDate("startdate"), (boolean)true));
        param.setStopDate(DateUtils.getDataFormat((Date)filterInfo.getDate("stopdate"), (boolean)false));
        param.setBillScope(filterInfo.getString("billscope"));
        param.setIncludUnAudit(filterInfo.getBoolean("includunaudit"));
        param.setIsdetail(filterInfo.getBoolean("isdetail"));
        param.setNotShowZero(filterInfo.getBoolean("notshowzero"));
        param.setNotShowNull(filterInfo.getBoolean("notshownull"));
        param.setNotShowNullAndZero(filterInfo.getBoolean("notshownullandzero"));
        param.setShowMainCurrency(filterInfo.getBoolean("showmaincurrency"));
        return param;
    }

    private DataSet createResult(DataSet result) {
        BigDecimal periodAmt = BigDecimal.ZERO;
        BigDecimal localPeriodAmt = BigDecimal.ZERO;
        RowMeta rowMeta = result.getRowMeta();
        int length = rowMeta.getFields().length;
        int balanceIdx = rowMeta.getFieldIndex("balance");
        int localBalanceIdx = rowMeta.getFieldIndex("localbalance");
        DataSetBuilder dataSetBuilder = Algo.create((String)"ar.detailrpt.calculatebalance").createDataSetBuilder(rowMeta);
        while (result.hasNext()) {
            Object[] rowData = new Object[length];
            Row row = result.next();
            for (int i = 0; i < length; ++i) {
                rowData[i] = row.get(i);
            }
            periodAmt = this.calculateBalance(periodAmt, row, false);
            rowData[balanceIdx] = periodAmt;
            localPeriodAmt = this.calculateBalance(localPeriodAmt, row, true);
            rowData[localBalanceIdx] = localPeriodAmt;
            dataSetBuilder.append(rowData);
        }
        return dataSetBuilder.build();
    }

    private BigDecimal calculateBalance(BigDecimal periodAmt, Row row, boolean isLocalAmt) {
        BigDecimal payAmt = row.getBigDecimal(isLocalAmt ? "localreceivableamt" : "receivableamt");
        BigDecimal settleAmt = row.getBigDecimal(isLocalAmt ? "localsettleamt" : "settleamt");
        BigDecimal recSettleAmt = row.getBigDecimal(isLocalAmt ? "localrecsettleamt" : "recsettleamt");
        BigDecimal recAmt = row.getBigDecimal(isLocalAmt ? "localreceivedamt" : "receivedamt");
        BigDecimal balanceAmt = row.getBigDecimal(isLocalAmt ? "localbalance" : "balance");
        switch (row.getInteger(SUM_LEVEL)) {
            case -1: {
                return balanceAmt;
            }
            case 0: {
                return periodAmt.add(payAmt).subtract(settleAmt).subtract(recAmt).add(recSettleAmt);
            }
        }
        return balanceAmt;
    }
}

