/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.api;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.openapi.common.custom.annotation.ApiController;
import kd.bos.openapi.common.custom.annotation.ApiParam;
import kd.bos.openapi.common.custom.annotation.ApiPostMapping;
import kd.bos.openapi.common.custom.annotation.ApiResponseBody;
import kd.bos.openapi.common.result.CustomApiResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;

@ApiController(value="CloseAccountApi", desc="")
public class CloseAccountApi
implements IBillWebApiPlugin {
    private static final Log logger = LogFactory.getLog(CloseAccountApi.class);

    @ApiPostMapping(value="/executeCloseAccount")
    public CustomApiResult<@ApiResponseBody OperationResult> executeCloseAccount(@ApiParam(value="entityNumber", required=true, example="ap_closeaccount") @ApiParam(value="entityNumber", required=true, example="ap_closeaccount") String entityNumber, @ApiParam(value="operationKey", required=true, example="closeaccount") @ApiParam(value="operationKey", required=true, example="closeaccount") String operationKey, @ApiParam(value="orgNumbers", required=true) @ApiParam(value="orgNumbers", required=true) List<String> orgNumbers, @ApiParam(value="closeDate", required=true, example="yyyy-MM-dd HH:mm:ss") @ApiParam(value="closeDate", required=true, example="yyyy-MM-dd HH:mm:ss") String closeDate) {
        try {
            OperationResult opResult = this.executeOperate(entityNumber, operationKey, orgNumbers, closeDate);
            if (opResult.isSuccess()) {
                return CustomApiResult.success((Object)opResult);
            }
            StringBuilder error = new StringBuilder();
            error.append(opResult.getMessage());
            List list = opResult.getAllErrorOrValidateInfo();
            for (IOperateInfo iOperateInfo : list) {
                error.append('\n').append(iOperateInfo.getMessage());
            }
            return CustomApiResult.fail((String)"fail", (String)error.toString());
        }
        catch (Exception e) {
            ApiResult apiResult = ApiResult.ex((Throwable)e);
            return CustomApiResult.fail((String)apiResult.getErrorCode(), (String)apiResult.getMessage());
        }
    }

    private OperationResult executeOperate(String entityNumber, String operationKey, List<String> orgNumbers, String closeDateStr) throws ParseException {
        OperationResult opResult = new OperationResult();
        if (orgNumbers.isEmpty()) {
            opResult.setSuccess(false);
            opResult.setMessage(ResManager.loadKDString((String)"orgNumbers: \u4e0d\u80fd\u4e3a\u7a7a", (String)"Api_orgNumbers", (String)"fi-arapcommon", (Object[])new Object[0]));
        } else {
            Date closeDate = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(closeDateStr);
            logger.info("---CloseAccountApi param---- entityNumber = " + entityNumber + ", operationKey = " + operationKey + ", orgNumbers = " + orgNumbers + ", closedateStr = " + closeDate);
            OperateOption option = OperateOption.create();
            option.setVariableValue("WF", "false");
            option.setVariableValue("mutex_writeback", "false");
            if ("closeaccount".equals(operationKey)) {
                option.setVariableValue("closedate", closeDateStr);
            } else {
                option.setVariableValue("anticlosedate", closeDateStr);
            }
            List closeaccountPKs = QueryServiceHelper.queryPrimaryKeys((String)entityNumber, (QFilter[])new QFilter[]{new QFilter("org.number", "in", orgNumbers)}, (String)"id", (int)-1);
            if (closeaccountPKs.isEmpty()) {
                opResult.setSuccess(false);
                opResult.setMessage(ResManager.loadKDString((String)"\u7ec4\u7ec7\u5bf9\u5e94\u7684\u6708\u672b\u5173\u8d26\u8bb0\u5f55\u4e0d\u5b58\u5728\u3002", (String)"CloseAccountApi_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            } else {
                opResult = OperationServiceHelper.executeOperate((String)operationKey, (String)entityNumber, (Object[])closeaccountPKs.toArray(), (OperateOption)option);
            }
        }
        return opResult;
    }
}

