/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.api;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.data.BusinessDataReader;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicProperty;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.botp.runtime.PushArgs;
import kd.bos.entity.botp.runtime.SourceBillReport;
import kd.bos.entity.datamodel.IRefrencedataProvider;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.operate.result.IOperateInfo;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.entity.property.AmountProp;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.DateProp;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.botp.ConvertServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.util.EntityMetadataUtils;

@KSObject
public class PushAndSaveApi
implements IBillWebApiPlugin {
    private static final Log logger = LogFactory.getLog(PushAndSaveApi.class);

    @KSMethod
    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult result = new ApiResult();
        try {
            String sourceEntity = (String)params.get("sourceEntity");
            String targetEntity = (String)params.get("targetEntity");
            String ruleId = (String)params.get("ruleId");
            Object sourceBillPk = params.get("sourceBillPk");
            logger.info("---PushAndSaveApi param---- ruleid = " + ruleId + ", srcEntity = " + sourceEntity + ", trgEntity = " + targetEntity + ", sourceBillPk = " + sourceBillPk);
            if (ObjectUtils.isEmpty((Object)sourceEntity) || ObjectUtils.isEmpty((Object)targetEntity) || ObjectUtils.isEmpty((Object)ruleId) || ObjectUtils.isEmpty((Object)sourceBillPk)) {
                result = ApiResult.fail((String)"Incomplete parameters");
            } else {
                List sourceBillPkList = new ArrayList<Long>(8);
                if (sourceBillPk instanceof String || sourceBillPk instanceof Long) {
                    sourceBillPkList.add(Long.parseLong(sourceBillPk.toString()));
                } else if (sourceBillPk instanceof List) {
                    sourceBillPkList = (List)sourceBillPk;
                }
                if (sourceBillPkList.size() == 0) {
                    result = ApiResult.fail((String)"sourceBillPk invalid");
                    return result;
                }
                ArrayList<ListSelectedRow> selectedRows = new ArrayList<ListSelectedRow>(8);
                for (Long srcPk : sourceBillPkList) {
                    ListSelectedRow row = new ListSelectedRow();
                    row.setPrimaryKeyValue((Object)srcPk);
                    selectedRows.add(row);
                }
                PushArgs args = new PushArgs();
                args.setSourceEntityNumber(sourceEntity);
                args.setTargetEntityNumber(targetEntity);
                args.setRuleId(ruleId);
                args.setSelectedRows(selectedRows);
                logger.info("invoke ConvertServiceHelper.push");
                ConvertOperationResult pushResult = ConvertServiceHelper.push((PushArgs)args);
                logger.info("ConvertServiceHelper.push finish");
                if (!pushResult.isSuccess()) {
                    logger.info("ConvertServiceHelper.push fail");
                    StringBuffer errMessage = new StringBuffer();
                    for (SourceBillReport billReport : pushResult.getBillReports()) {
                        if (billReport.isSuccess()) continue;
                        String billMessage = billReport.getFailMessage();
                        errMessage.append('\n').append(billMessage);
                    }
                    throw new KDBizException("push fail:" + errMessage);
                }
                logger.info("ConvertServiceHelper.push success");
                MainEntityType targetMainType = EntityMetadataCache.getDataEntityType((String)targetEntity);
                List targetBillObjs = pushResult.loadTargetDataObjects(new IRefrencedataProvider(){

                    public void fillReferenceData(Object[] objs, IDataEntityType dType) {
                        BusinessDataReader.loadRefence((Object[])objs, (IDataEntityType)dType);
                    }
                }, targetMainType);
                logger.info("loadTargetDataObjects success");
                this.processTargetObj(targetBillObjs, params);
                logger.info("processTargetObj success");
                OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)targetEntity, (DynamicObject[])targetBillObjs.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
                logger.info("executeOperate save finnish");
                if (!saveResult.isSuccess()) {
                    logger.info("executeOperate save fail");
                    StringBuilder errMessage = new StringBuilder();
                    errMessage.append(saveResult.getMessage());
                    for (IOperateInfo errInfo : saveResult.getAllErrorOrValidateInfo()) {
                        String detailMessage = errInfo.getMessage();
                        errMessage.append('\n').append(detailMessage);
                    }
                    throw new KDBizException("save fail\uff1a" + errMessage);
                }
                logger.info("executeOperate save success");
                pushResult.getTargetBillIds().addAll(saveResult.getSuccessPkIds());
                result = ApiResult.success((Object)pushResult);
            }
        }
        catch (Exception e) {
            logger.info("doCustomService Exception:" + e);
            result = ApiResult.ex((Throwable)e);
        }
        logger.info("return result");
        return result;
    }

    protected void processTargetObj(List<DynamicObject> targetBillObjs, Map<String, Object> params) throws Exception {
        if (!ObjectUtils.isEmpty((Object)params.get("head"))) {
            logger.info("head " + params.get("head"));
            Map headMap = (Map)params.get("head");
            Set entrySet = headMap.entrySet();
            for (DynamicObject targetBill : targetBillObjs) {
                for (Map.Entry entry : entrySet) {
                    String headKey = (String)entry.getKey();
                    if (!EntityMetadataUtils.isExistProperty(targetBill, headKey)) continue;
                    Object value = entry.getValue();
                    DynamicProperty property = targetBill.getDynamicObjectType().getProperty(headKey);
                    if (property instanceof BasedataProp) {
                        BasedataProp prop = (BasedataProp)property;
                        QFilter filter = new QFilter("number", "=", value);
                        DynamicObject baseData = BusinessDataServiceHelper.loadSingle((String)prop.getBaseEntityId(), (String)"id", (QFilter[])new QFilter[]{filter});
                        if (baseData != null) {
                            baseData = BusinessDataServiceHelper.loadSingle((Object)baseData.getPkValue(), (String)prop.getBaseEntityId());
                        } else {
                            try {
                                long basedataId = Long.parseLong(value.toString());
                                filter = new QFilter("id", "=", (Object)basedataId);
                                baseData = BusinessDataServiceHelper.loadSingle((Object)basedataId, (String)prop.getBaseEntityId());
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        targetBill.set(headKey, (Object)baseData);
                        continue;
                    }
                    if (property instanceof AmountProp) {
                        targetBill.set(headKey, (Object)new BigDecimal(value.toString()));
                        continue;
                    }
                    if (property instanceof DateProp) {
                        Date date = new SimpleDateFormat("yyyy-MM-dd").parse(value.toString());
                        targetBill.set(headKey, (Object)date);
                        continue;
                    }
                    targetBill.set(headKey, value);
                }
            }
        }
        if (!ObjectUtils.isEmpty((Object)params.get("entry"))) {
            logger.info("entry " + params.get("entry"));
            List entryList = (List)params.get("entry");
            for (Map entryMap : entryList) {
                String entryEntity = (String)entryMap.get("entryentity");
                List entryField = (List)entryMap.get("fieldvalue");
                for (DynamicObject targetBill : targetBillObjs) {
                    DynamicObjectCollection entryColl = targetBill.getDynamicObjectCollection(entryEntity);
                    for (int i = 0; i < entryField.size(); ++i) {
                        DynamicObject entry = (DynamicObject)entryColl.get(0);
                        Map entryFiledMap = (Map)entryField.get(i);
                        Set entrySet = entryFiledMap.entrySet();
                        for (Map.Entry entryFiled : entrySet) {
                            String entryKey = (String)entryFiled.getKey();
                            Object value = entryFiled.getValue();
                            if (!EntityMetadataUtils.isExistProperty(entry, entryKey)) continue;
                            DynamicProperty property = entry.getDynamicObjectType().getProperty(entryKey);
                            if (property instanceof BasedataProp) {
                                BasedataProp prop = (BasedataProp)property;
                                QFilter filter = new QFilter("number", "=", value);
                                DynamicObject baseData = BusinessDataServiceHelper.loadSingle((String)prop.getBaseEntityId(), (String)"id", (QFilter[])new QFilter[]{filter});
                                if (baseData != null) {
                                    baseData = BusinessDataServiceHelper.loadSingle((Object)baseData.getPkValue(), (String)prop.getBaseEntityId());
                                } else {
                                    try {
                                        long basedataId = Long.parseLong(value.toString());
                                        filter = new QFilter("id", "=", (Object)basedataId);
                                        baseData = BusinessDataServiceHelper.loadSingle((Object)basedataId, (String)prop.getBaseEntityId());
                                    }
                                    catch (Exception exception) {
                                        // empty catch block
                                    }
                                }
                                value = baseData;
                            } else if (property instanceof AmountProp) {
                                value = new BigDecimal(value.toString());
                            } else if (property instanceof DateProp) {
                                Date date = new SimpleDateFormat("yyyy-MM-dd").parse(value.toString());
                                value = date;
                            }
                            for (DynamicObject entryRow : entryColl) {
                                entryRow.set(entryKey, value);
                            }
                        }
                    }
                }
            }
        }
    }
}

