/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.api;

import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import kd.bos.bill.IBillWebApiPlugin;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.helper.BOTPHelper;

@KSObject
public class TrackApi
implements IBillWebApiPlugin {
    private static final Log logger = LogFactory.getLog(TrackApi.class);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @KSMethod
    public ApiResult doCustomService(Map<String, Object> params) {
        ApiResult result = new ApiResult();
        try {
            String sourceEntity = (String)params.get("sourceEntity");
            String targetEntity = (String)params.get("targetEntity");
            String trackOp = (String)params.get("trackop");
            String billId = (String)params.get("billId");
            logger.info("---TrackApi param---- trackOp = " + trackOp + ", srcEntity = " + sourceEntity + ", trgEntity = " + targetEntity + ", billId = " + billId);
            if (ObjectUtils.isEmpty((Object)sourceEntity)) return ApiResult.fail((String)"Incomplete parameters");
            if (ObjectUtils.isEmpty((Object)targetEntity)) return ApiResult.fail((String)"Incomplete parameters");
            if (ObjectUtils.isEmpty((Object)trackOp)) return ApiResult.fail((String)"Incomplete parameters");
            if (ObjectUtils.isEmpty((Object)billId)) {
                return ApiResult.fail((String)"Incomplete parameters");
            }
            DynamicObjectCollection bills = new DynamicObjectCollection();
            if ("traceup".equals(trackOp)) {
                Set<Long> souBillIds = BOTPHelper.findSouBillIds(targetEntity, Long.parseLong(billId), sourceEntity);
                if (ObjectUtils.isEmpty(souBillIds)) {
                    return ApiResult.fail((String)"traceup null");
                }
                Iterator<Long> iterator = souBillIds.iterator();
                while (iterator.hasNext()) {
                    DynamicObject tarBill = BusinessDataServiceHelper.loadSingle((Object)iterator.next(), (String)targetEntity);
                    bills.add((Object)tarBill);
                }
                return ApiResult.success((Object)bills);
            }
            if (!"tracedown".equals(trackOp)) return ApiResult.fail((String)"Incomplete trackop");
            Set<Long> tarBillIds = BOTPHelper.findTarBillIds(sourceEntity, Long.parseLong(billId), targetEntity);
            if (ObjectUtils.isEmpty(tarBillIds)) {
                return ApiResult.fail((String)"tracedown null");
            }
            Iterator<Long> iterator = tarBillIds.iterator();
            while (iterator.hasNext()) {
                DynamicObject tarBill = BusinessDataServiceHelper.loadSingle((Object)iterator.next(), (String)targetEntity);
                bills.add((Object)tarBill);
            }
            return ApiResult.success((Object)bills);
        }
        catch (Exception e) {
            return ApiResult.ex((Throwable)e);
        }
    }
}

