/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.api.freeze;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.api.freeze.AbstractBillFrezzeService;
import kd.fi.arapcommon.api.param.FreezeParam;

public class FinApBillFreezeService
extends AbstractBillFrezzeService {
    @Override
    protected String getEntryName() {
        return "planentity";
    }

    @Override
    protected DynamicObject[] loadNeedFreezeBills(List<FreezeParam> params) {
        ArrayList<Long> billIds = new ArrayList<Long>(16);
        for (FreezeParam param : params) {
            billIds.add(param.getBillId());
        }
        return BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"id,billno,org.id,asstacttype,asstact.id,freezestate,planentity.id,planentity.seq,planentity.e_freezestate", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)});
    }

    @Override
    public List<DynamicObject> upDataBillFreezeStatusAndbulidFreezeLogVo(List<FreezeParam> params, DynamicObject[] freezeBills, boolean freeze) {
        ArrayList<DynamicObject> freezeLogDys = new ArrayList<DynamicObject>(16);
        Map<Long, DynamicObject> freezeBillMap = Arrays.stream(freezeBills).collect(Collectors.toMap(v -> v.getLong("id"), v -> v));
        String userId = String.valueOf(RequestContext.get().getCurrUserId());
        for (FreezeParam param : params) {
            Long billId = param.getBillId();
            DynamicObject bill = freezeBillMap.get(billId);
            if (bill == null) continue;
            String opType = param.getOpType();
            String freezeReason = param.getFreezeReason();
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("planentity");
            String billNo = bill.getString("billno");
            Long orgId = bill.getLong("org.id");
            String asstactType = bill.getString("asstacttype");
            Long asstactId = bill.getLong("asstact.id");
            boolean isEntryFreeze = param.isEntryFreeze();
            if (isEntryFreeze) {
                Set<Long> entryIds = param.getEntryIds();
                for (DynamicObject row : entry) {
                    Long entryId = row.getLong("id");
                    if (!entryIds.contains(entryId)) continue;
                    DynamicObject freezeDyn = BusinessDataServiceHelper.newDynamicObject((String)"ap_freezelog");
                    freezeDyn.set("billstatus", (Object)"A");
                    freezeDyn.set("creator", (Object)userId);
                    freezeDyn.set("optime", (Object)new Date());
                    freezeDyn.set("billtype", (Object)"ap_finapbill");
                    freezeDyn.set("billno", (Object)billNo);
                    freezeDyn.set("asstacttype", (Object)asstactType);
                    freezeDyn.set("asstact", (Object)asstactId);
                    freezeDyn.set("org", (Object)orgId);
                    freezeDyn.set("billid", (Object)billId);
                    freezeDyn.set("businessop", (Object)(freeze ? "allfreeze" : "unfreeze"));
                    freezeDyn.set("oprange", (Object)"payplan");
                    freezeDyn.set("freezereason", (Object)freezeReason);
                    freezeDyn.set("optype", (Object)opType);
                    freezeDyn.set("billentryid", (Object)entryId);
                    freezeDyn.set("lineno", (Object)String.valueOf(row.getInt("seq")));
                    row.set("e_freezestate", (Object)(freeze ? "allfreeze" : "unfreeze"));
                    freezeLogDys.add(freezeDyn);
                }
                this.setBillFreezeStatus(bill, freeze);
                continue;
            }
            DynamicObject freezeDyn = BusinessDataServiceHelper.newDynamicObject((String)"ap_freezelog");
            freezeDyn.set("billstatus", (Object)"A");
            freezeDyn.set("creator", (Object)userId);
            freezeDyn.set("optime", (Object)new Date());
            freezeDyn.set("billtype", (Object)"ap_finapbill");
            freezeDyn.set("billno", (Object)billNo);
            freezeDyn.set("asstacttype", (Object)asstactType);
            freezeDyn.set("asstact", (Object)asstactId);
            freezeDyn.set("org", (Object)orgId);
            freezeDyn.set("billid", (Object)billId);
            freezeDyn.set("businessop", (Object)(freeze ? "allfreeze" : "unfreeze"));
            freezeDyn.set("oprange", (Object)"wholeorder");
            freezeDyn.set("freezereason", (Object)freezeReason);
            freezeDyn.set("optype", (Object)opType);
            bill.set("freezestate", (Object)(freeze ? "allfreeze" : "unfreeze"));
            for (DynamicObject row : entry) {
                row.set("e_freezestate", (Object)(freeze ? "allfreeze" : "unfreeze"));
            }
            freezeLogDys.add(freezeDyn);
        }
        return freezeLogDys;
    }
}

