/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.api.helper;

import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.exception.SettleServiceBizException;

public class ServiceCheckHelper {
    public static void checkOrg(long orgId) {
        DynamicObject org = BusinessDataServiceHelper.loadSingleFromCache((Object)orgId, (String)"bos_org");
        if (org == null) {
            throw new SettleServiceBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7ec4\u7ec7\u4e0d\u5b58\u5728\u3002", (String)"ServiceCheckHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        boolean isAccounting = org.getBoolean("fisaccounting");
        if (!isAccounting) {
            throw new SettleServiceBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7ec4\u7ec7\u5fc5\u987b\u662f\u6838\u7b97\u7ec4\u7ec7\u3002", (String)"ServiceCheckHelper_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    public static void checkOrgEqual(long orgId, String billEntity, Set<Long> billIds) {
        boolean flag = true;
        if ("cas_paybill".equals(billEntity) || "cas_recbill".equals(billEntity)) {
            String entryOrgFieldKey = "cas_paybill".equals(billEntity) ? "entry.settleorg" : "entry.e_settleorg";
            flag = QueryServiceHelper.exists((String)billEntity, (QFilter[])new QFilter[]{new QFilter("id", "in", billIds), new QFilter(entryOrgFieldKey, "=", (Object)orgId)});
        } else {
            DataSet rows = QueryServiceHelper.queryDataSet((String)"queryorg", (String)billEntity, (String)"org", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)}, (String)"");
            DataSet distinctDataSet = rows.distinct();
            for (Row row : distinctDataSet) {
                if (row.getLong("org") == orgId) continue;
                flag = false;
                break;
            }
        }
        if (!flag) {
            throw new SettleServiceBizException(ResManager.loadKDString((String)"\u5355\u636e\u7684\u7ed3\u7b97\u7ec4\u7ec7\u5fc5\u987b\u4e0e\u53c2\u6570\u4e2d\u4f20\u5165\u7ec4\u7ec7\u76f8\u540c\u3002", (String)"ServiceCheckHelper_2", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    public static long checkCurrencyEqual(String billEntity, Set<Long> billIds) {
        HashSet<Long> currencyIdSet = new HashSet<Long>(2);
        DataSet rows = QueryServiceHelper.queryDataSet((String)"querycurrency", (String)billEntity, (String)"currency", (QFilter[])new QFilter[]{new QFilter("id", "in", billIds)}, (String)"");
        for (Row row : rows) {
            currencyIdSet.add(row.getLong("currency"));
        }
        if (currencyIdSet.size() == 0 || currencyIdSet.size() > 1) {
            throw new SettleServiceBizException(ResManager.loadKDString((String)"\u540c\u4e00\u65b9\u5355\u636e\u7684\u5e01\u79cd\u5fc5\u987b\u4e00\u81f4\u3002", (String)"ServiceCheckHelper_3", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        return (Long)currencyIdSet.iterator().next();
    }
}

