/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.api.push;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.botp.runtime.ConvertOperationResult;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.script.annotations.KSMethod;
import kd.bos.script.annotations.KSObject;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.api.param.AssignBillPushParam;
import kd.fi.arapcommon.api.param.BillHeadAmtParam;
import kd.fi.arapcommon.api.param.CalculatorParam;
import kd.fi.arapcommon.api.push.IPushBillService;
import kd.fi.arapcommon.business.price.AbstractPriceCalculator;
import kd.fi.arapcommon.business.price.PriceLocalCalculator;
import kd.fi.arapcommon.business.price.PriceTaxTotalCalculator;
import kd.fi.arapcommon.business.price.PriceTotalCalculator;
import kd.fi.arapcommon.business.price.TaxUnitPriceCalculator;
import kd.fi.arapcommon.business.price.UnitPriceCalculator;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.helper.BizExtendHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.model.BillModel;
import kd.fi.arapcommon.model.BillModelFactory;
import kd.fi.arapcommon.service.helper.SettleLogHelper;
import kd.fi.arapcommon.util.EntityMetadataUtils;
import kd.fi.arapcommon.util.StringUtils;

@KSObject
public abstract class AbstractPushBillService
implements IPushBillService {
    private static final Log logger = LogFactory.getLog(AbstractPushBillService.class);
    protected BillModel billModel = this.getBillModel();

    @Override
    @KSMethod
    public List<Object> assignBillPush(String sourEntity, List<AssignBillPushParam> paramList) {
        return this.assignBillPush(sourEntity, paramList, null);
    }

    @Override
    @KSMethod
    public List<Object> assignBillPush(String sourEntity, List<AssignBillPushParam> paramList, String ruleId) {
        try {
            logger.info("assignBillPush:begin");
            this.checkParam(sourEntity, "", paramList, false);
            List<DynamicObject> targetBills = this.pushTargetBillsBySourBill(sourEntity, paramList, ruleId);
            this.setHeadFieldByParam(targetBills, paramList);
            if (this.billPushRecalculate(paramList)) {
                List<BillHeadAmtParam> billHeadAmtParams = this.reCalculateEntryField(targetBills, paramList);
                this.resetHeadAmtField(targetBills, billHeadAmtParams);
            }
            this.afterPush(sourEntity, "", paramList, ruleId, targetBills);
            List<Object> result = this.saveTargetBills(sourEntity, "", paramList, ruleId, targetBills);
            return result;
        }
        catch (Throwable e) {
            logger.info("assignBillPush:" + SettleLogHelper.getStackTraceMessage(e));
            throw e;
        }
    }

    @Override
    @KSMethod
    public List<Object> assignBillEntryPush(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList) {
        return this.assignBillEntryPush(sourEntity, sourEntryEntity, paramList, null);
    }

    @Override
    @KSMethod
    public List<Object> assignBillEntryPush(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList, String ruleId) {
        try {
            this.checkParam(sourEntity, sourEntryEntity, paramList, true);
            List<DynamicObject> targetBills = this.pushTargetBillsBySourEntry(sourEntity, sourEntryEntity, paramList, ruleId);
            this.checkAfterPush(paramList, targetBills);
            this.setHeadFieldByParam(targetBills, new ArrayList<AssignBillPushParam>(paramList));
            this.setEntryFieldByParam(targetBills, paramList);
            List<BillHeadAmtParam> billHeadAmtParams = this.reCalculateEntryField(targetBills, paramList);
            this.resetHeadAmtField(targetBills, billHeadAmtParams);
            this.afterPush(sourEntity, sourEntryEntity, paramList, ruleId, targetBills);
            return this.saveTargetBills(sourEntity, sourEntryEntity, paramList, ruleId, targetBills);
        }
        catch (Throwable e) {
            logger.info("assignBillEntryPush:" + SettleLogHelper.getStackTraceMessage(e));
            throw e;
        }
    }

    protected void checkAfterPush(List<AssignBillPushParam> paramList, List<DynamicObject> targetBills) {
    }

    protected void checkParam(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList, boolean assignEntry) {
        if (StringUtils.isEmpty(sourEntity)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u5355\u6807\u8bc6(sourEntity)\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractPushBillService_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty(paramList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8f6c\u5165\u660e\u7ec6\u4e0d\u5141\u8bb8\u4e3a\u7a7a\uff0c\u8bf7\u4fee\u6539\u3002", (String)"AbstractPushBillService_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        List billIdList = paramList.stream().filter(param -> param.getSourBillId() == 0L).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(billIdList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u5217\u8868\u4e2d\u6e90\u5355ID\u5c5e\u6027(sourBillId)\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractPushBillService_2", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        if (assignEntry) {
            if (StringUtils.isEmpty(sourEntryEntity)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6e90\u5355\u5206\u5f55\u6807\u8bc6(sourEntryEntity)\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractPushBillService_3", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            List entryIdList = paramList.stream().filter(param -> param.getSourBillEntryId() == 0L).collect(Collectors.toList());
            if (!ObjectUtils.isEmpty(entryIdList)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53c2\u6570\u5217\u8868\u4e2d\u6e90\u5355\u5206\u5f55ID\u5c5e\u6027(sourBillEntryId)\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractPushBillService_4", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        }
        List<String> canModifyFields = this.canModifyFields();
        for (AssignBillPushParam param2 : paramList) {
            Map<String, Object> tarFieldValueMap = param2.getTarFieldValueMap();
            if (tarFieldValueMap.isEmpty()) continue;
            for (Map.Entry<String, Object> entry : tarFieldValueMap.entrySet()) {
                String key = entry.getKey();
                if (canModifyFields.contains(key)) continue;
                throw new KDBizException(ResManager.loadKDString((String)"\u5b57\u6bb5%s\u4e0d\u5728\u53ef\u4fee\u6539\u7684\u5b57\u6bb5\u8303\u56f4\u5185\u3002", (String)"AbstractPushBillService_5", (String)"fi-arapcommon", (Object[])new Object[]{key}));
            }
        }
    }

    protected List<DynamicObject> pushTargetBillsBySourBill(String sourEntity, List<AssignBillPushParam> paramList, String ruleId) {
        Set billIdSet = paramList.stream().map(assignBillPushParam -> assignBillPushParam.getSourBillId()).collect(Collectors.toSet());
        Map<String, Object> pushMap = BOTPHelper.push4Result(sourEntity, this.getTargetEntity(), ruleId, new ArrayList<Long>(billIdSet), this.getPushArgsMap());
        List targetBills = null;
        ConvertOperationResult result = (ConvertOperationResult)pushMap.get("convertResult");
        if (result != null) {
            String convertReport = BOTPHelper.getConvertReport(result);
            ErrorCode ec = new ErrorCode("botp", convertReport);
            throw new KDBizException(ec, new Object[0]);
        }
        targetBills = (List)pushMap.get("trgBills");
        return targetBills;
    }

    protected List<DynamicObject> pushTargetBillsBySourEntry(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList, String ruleId) {
        HashMap<Long, List<Long>> billIdMap = new HashMap<Long, List<Long>>(8);
        for (AssignBillPushParam entryPushParam : paramList) {
            long sourBillId = entryPushParam.getSourBillId();
            long sourBillEntryId = entryPushParam.getSourBillEntryId();
            ArrayList<Long> sourBillEntryIds = (ArrayList<Long>)billIdMap.get(sourBillId);
            if (sourBillEntryIds == null) {
                sourBillEntryIds = new ArrayList<Long>(2);
            }
            sourBillEntryIds.add(sourBillEntryId);
            billIdMap.put(sourBillId, sourBillEntryIds);
        }
        return BOTPHelper.push4Result(sourEntity, sourEntryEntity, this.getTargetEntity(), ruleId, billIdMap, this.getPushArgsMap());
    }

    protected List<BillHeadAmtParam> reCalculateEntryField(List<DynamicObject> targetBills, List<AssignBillPushParam> paramList) {
        ArrayList<BillHeadAmtParam> billHeadAmtParamList = new ArrayList<BillHeadAmtParam>(targetBills.size());
        List noReCalculateParamList = paramList.stream().filter(param -> !param.isReCalculate()).collect(Collectors.toList());
        for (DynamicObject targetBill : targetBills) {
            BillHeadAmtParam billHeadAmtParam = new BillHeadAmtParam(targetBill.getLong("id"));
            DynamicObjectCollection targetBillEntries = targetBill.getDynamicObjectCollection(this.getTargetEntryEntity());
            for (DynamicObject targetBillEntry : targetBillEntries) {
                Object sourEntryIdObj = targetBillEntry.get(this.getTargetSourEntryIdKey());
                long sourEntryId = Long.parseLong(sourEntryIdObj.toString());
                Optional<AssignBillPushParam> entryNoReCalculate = noReCalculateParamList.stream().filter(param -> param.getSourBillEntryId() == sourEntryId).findAny();
                if (entryNoReCalculate.isPresent()) {
                    billHeadAmtParam.setAmount(billHeadAmtParam.getAmount().add(targetBillEntry.getBigDecimal(this.billModel.E_AMOUNT)));
                    billHeadAmtParam.setAmountLocal(billHeadAmtParam.getAmountLocal().add(targetBillEntry.getBigDecimal(this.billModel.E_LOCALAMT)));
                    billHeadAmtParam.setPriceTaxTotal(billHeadAmtParam.getPriceTaxTotal().add(targetBillEntry.getBigDecimal(this.billModel.E_PRICETAXTOTAL)));
                    billHeadAmtParam.setPriceTaxTotalLocal(billHeadAmtParam.getPriceTaxTotalLocal().add(targetBillEntry.getBigDecimal(this.billModel.E_PRICETAXTOTALLOC)));
                    billHeadAmtParam.setTaxAmt(billHeadAmtParam.getTaxAmt().add(targetBillEntry.getBigDecimal(this.billModel.E_TAX)));
                    billHeadAmtParam.setTaxAmtLocal(billHeadAmtParam.getTaxAmtLocal().add(targetBillEntry.getBigDecimal(this.billModel.E_TAXLOCALAMT)));
                    continue;
                }
                CalculatorParam calParam = this.genCalculatorParam(targetBill, targetBillEntry);
                AbstractPriceCalculator calculator = null;
                if (calParam.isIncludeTax() && !calParam.isPriceTotal()) {
                    BigDecimal taxUnitPrice = calParam.getTaxUnitPrice();
                    calculator = new TaxUnitPriceCalculator(calParam.getQty(), taxUnitPrice, calParam.getTaxRate(), calParam.getDiscountMode(), calParam.getDiscountRate(), calParam.getCurrencyPrecision(), calParam.getAdjustAmt(), calParam.getDiscountAmt());
                } else if (!calParam.isIncludeTax() && !calParam.isPriceTotal()) {
                    BigDecimal unitPrice = calParam.getUnitPrice();
                    calculator = new UnitPriceCalculator(calParam.getQty(), unitPrice, calParam.getTaxRate(), calParam.getDiscountMode(), calParam.getDiscountRate(), calParam.getCurrencyPrecision(), calParam.getAdjustAmt(), calParam.getDiscountAmt());
                } else if (!calParam.isIncludeTax() && calParam.isPriceTotal()) {
                    BigDecimal amount = calParam.getAmount();
                    calculator = new PriceTotalCalculator(calParam.getQty(), amount, calParam.getTaxRate(), calParam.getDiscountMode(), calParam.getDiscountRate(), calParam.getCurrencyPrecision(), calParam.getAdjustAmt(), calParam.getDiscountAmt());
                } else if (calParam.isIncludeTax() && calParam.isPriceTotal()) {
                    BigDecimal priceTaxTotal = calParam.getPriceTaxTotal();
                    calculator = new PriceTaxTotalCalculator(calParam.getQty(), priceTaxTotal, calParam.getTaxRate(), calParam.getDiscountMode(), calParam.getDiscountRate(), calParam.getCurrencyPrecision(), calParam.getAdjustAmt(), calParam.getDiscountAmt());
                }
                PriceLocalCalculator localCalculator = new PriceLocalCalculator(calculator, calParam.getExchangeRate(), calParam.getBaseCurrencyPrecision(), calParam.getQuotation());
                localCalculator.calculate();
                this.resetEntryAmtField(localCalculator, targetBillEntry, paramList);
                billHeadAmtParam.setAmount(billHeadAmtParam.getAmount().add(localCalculator.getAmount()));
                billHeadAmtParam.setAmountLocal(billHeadAmtParam.getAmountLocal().add(localCalculator.getAmountlocal()));
                billHeadAmtParam.setPriceTaxTotal(billHeadAmtParam.getPriceTaxTotal().add(localCalculator.getPricetaxtotal()));
                billHeadAmtParam.setPriceTaxTotalLocal(billHeadAmtParam.getPriceTaxTotalLocal().add(localCalculator.getPricetaxtotallocal()));
                billHeadAmtParam.setTaxAmt(billHeadAmtParam.getTaxAmt().add(localCalculator.getTax()));
                billHeadAmtParam.setTaxAmtLocal(billHeadAmtParam.getTaxAmtLocal().add(localCalculator.getTaxlocal()));
                billHeadAmtParam.setAdjustAmt(billHeadAmtParam.getAdjustAmt().add(localCalculator.getAdjustamt()));
                billHeadAmtParam.setAdjustAmtLocal(billHeadAmtParam.getAdjustAmtLocal().add(localCalculator.getAdjustamtlocal()));
            }
            billHeadAmtParamList.add(billHeadAmtParam);
        }
        return billHeadAmtParamList;
    }

    protected CalculatorParam genCalculatorParam(DynamicObject targetBill, DynamicObject targetBillEntry) {
        CalculatorParam calculatorParam = new CalculatorParam();
        calculatorParam.setIncludeTax(targetBill.getBoolean(this.billModel.HEAD_ISINCLUDETAX));
        calculatorParam.setPriceTotal(targetBill.getBoolean(this.billModel.HEAD_ISPRICETOTAL));
        calculatorParam.setExchangeRate(targetBill.getBigDecimal(this.billModel.HEAD_EXCHANGERATE));
        calculatorParam.setQuotation(targetBill.getString(this.billModel.HEAD_QUOTATION));
        calculatorParam.setAmount(targetBillEntry.getBigDecimal(this.billModel.E_AMOUNT));
        calculatorParam.setPriceTaxTotal(targetBillEntry.getBigDecimal(this.billModel.E_PRICETAXTOTAL));
        calculatorParam.setCurrencyPrecision(targetBill.getInt(this.billModel.HEAD_CURRENCY + ".amtprecision"));
        calculatorParam.setBaseCurrencyPrecision(targetBill.getInt(this.billModel.HEAD_BASECURRENCY + ".amtprecision"));
        calculatorParam.setTaxUnitPrice(targetBillEntry.getBigDecimal(this.billModel.E_TAXUNITPRICE));
        calculatorParam.setUnitPrice(targetBillEntry.getBigDecimal(this.billModel.E_UNITPRICE));
        calculatorParam.setQty(targetBillEntry.getBigDecimal(this.billModel.E_QUANTITY));
        calculatorParam.setTaxRate(targetBillEntry.getBigDecimal(this.billModel.E_TAXRATE));
        calculatorParam.setDiscountMode(targetBillEntry.getString(this.billModel.E_DISCOUNTMODE));
        calculatorParam.setDiscountRate(targetBillEntry.getBigDecimal(this.billModel.E_DISCOUNTRATE));
        calculatorParam.setDiscountAmt(targetBillEntry.getBigDecimal(this.billModel.E_DISCOUNTAMOUNT));
        return calculatorParam;
    }

    protected void setEntryFieldByParam(List<DynamicObject> targetBills, List<AssignBillPushParam> paramList) {
        boolean isBusAndFin = false;
        if (!ObjectUtils.isEmpty(targetBills)) {
            String entityName = targetBills.get(0).getDataEntityType().getName();
            isBusAndFin = "ap_busbill".equals(entityName) || "ar_busbill".equals(entityName) || "ap_finapbill".equals(entityName) || "ar_finarbill".equals(entityName);
        }
        for (DynamicObject targetBill : targetBills) {
            DynamicObjectCollection targetBillEntries = targetBill.getDynamicObjectCollection(this.getTargetEntryEntity());
            for (DynamicObject targetBillEntry : targetBillEntries) {
                Object sourEntryIdObj = targetBillEntry.get(this.getTargetSourEntryIdKey());
                if (sourEntryIdObj == null || StringUtils.isEmpty(sourEntryIdObj.toString()) || "0".equals(sourEntryIdObj.toString())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u7684\u4e0b\u6e38\u5355\u636e\u5206\u5f55\u7684\u6e90\u5355\u5206\u5f55ID\u5c5e\u6027\u5b58\u5728\u7a7a\u503c\uff0c\u8bf7\u68c0\u67e5\u8f6c\u6362\u89c4\u5219\u662f\u5426\u914d\u7f6e\u3002", (String)"AbstractPushBillService_6", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
                long sourEntryId = Long.parseLong(sourEntryIdObj.toString());
                Optional<AssignBillPushParam> entryParamOptional = paramList.stream().filter(entryPushParam -> sourEntryId == entryPushParam.getSourBillEntryId()).findFirst();
                BigDecimal qty = targetBillEntry.getBigDecimal(this.billModel.E_QUANTITY);
                if (!entryParamOptional.isPresent()) continue;
                AssignBillPushParam entryPushParam2 = entryParamOptional.get();
                Map<String, Object> tarFieldValueMap = entryPushParam2.getTarFieldValueMap();
                if (isBusAndFin && targetBill.getBoolean(this.billModel.HEAD_PAYPROPERTY + ".isbasedonamt")) {
                    tarFieldValueMap.remove(this.billModel.E_QUANTITY);
                }
                for (Map.Entry<String, Object> mapEntry : tarFieldValueMap.entrySet()) {
                    BigDecimal targetFieldValue;
                    BigDecimal srcFieldValue;
                    String fieldKey = mapEntry.getKey();
                    if (!EntityMetadataUtils.isExistProperty(targetBillEntry, fieldKey)) continue;
                    Object fieldValue = mapEntry.getValue();
                    if (fieldValue instanceof BigDecimal && (srcFieldValue = targetBillEntry.getBigDecimal(fieldKey)).multiply(targetFieldValue = (BigDecimal)fieldValue).compareTo(BigDecimal.ZERO) < 0) {
                        throw new KDBizException(ResManager.loadKDString((String)"\u4fee\u6539\u7684\u5b57\u6bb5\u503c\u987b\u4e0e\u76ee\u6807\u5355\u7684\u521d\u59cb\u503c\u65b9\u5411\u76f8\u540c\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractPushBillService_7", (String)"fi-arapcommon", (Object[])new Object[0]));
                    }
                    targetBillEntry.set(fieldKey, fieldValue);
                }
                if (tarFieldValueMap.get(this.billModel.E_QUANTITY) == null) continue;
                BigDecimal qtyParam = (BigDecimal)tarFieldValueMap.get(this.billModel.E_QUANTITY);
                if (qty.abs().compareTo(qtyParam.abs()) != 0) continue;
                tarFieldValueMap.put("islast", "true");
            }
        }
    }

    protected void setHeadFieldByParam(List<DynamicObject> targetBills, List<AssignBillPushParam> paramList) {
        block0: for (DynamicObject targetBill : targetBills) {
            DynamicObjectCollection targetBillEntries = targetBill.getDynamicObjectCollection(this.getTargetEntryEntity());
            for (DynamicObject targetBillEntry : targetBillEntries) {
                Object sourIdObj = targetBillEntry.get(this.getTargetSourIdKey());
                if (sourIdObj == null || StringUtils.isEmpty(sourIdObj.toString()) || "0".equals(sourIdObj.toString())) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u751f\u6210\u7684\u4e0b\u6e38\u5355\u636e\u5206\u5f55\u7684\u6e90\u5355ID\u5c5e\u6027\u5b58\u5728\u7a7a\u503c\uff0c\u8bf7\u68c0\u67e5\u8f6c\u6362\u89c4\u5219\u662f\u5426\u914d\u7f6e\u3002", (String)"AbstractPushBillService_8", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
                long sourId = Long.parseLong(sourIdObj.toString());
                Optional<AssignBillPushParam> pushBillParamOptional = paramList.stream().filter(assignBillPushParam -> sourId == assignBillPushParam.getSourBillId()).findFirst();
                if (!pushBillParamOptional.isPresent()) continue;
                AssignBillPushParam assignBillPushParam2 = pushBillParamOptional.get();
                Map<String, Object> tarFieldValueMap = assignBillPushParam2.getTarFieldValueMap();
                for (Map.Entry<String, Object> mapEntry : tarFieldValueMap.entrySet()) {
                    Object fieldValue;
                    long baseCurrencyId;
                    long currencyId;
                    String fieldKey = mapEntry.getKey();
                    if (this.billModel.HEAD_EXCHANGERATE.equals(fieldKey) && (currencyId = targetBill.getLong(this.billModel.HEAD_CURRENCY + ".id")) == (baseCurrencyId = targetBill.getLong(this.billModel.HEAD_BASECURRENCY + ".id")) || !EntityMetadataUtils.isExistProperty(targetBill, fieldKey) || ObjectUtils.isEmpty((Object)(fieldValue = mapEntry.getValue()))) continue;
                    targetBill.set(fieldKey, fieldValue);
                }
                continue block0;
            }
        }
    }

    protected void resetHeadAmtField(List<DynamicObject> targetBills, List<BillHeadAmtParam> billHeadAmtParams) {
        if (ObjectUtils.isEmpty(billHeadAmtParams)) {
            return;
        }
        for (DynamicObject targetBill : targetBills) {
            Optional<BillHeadAmtParam> billHeadAmtParamOptional = billHeadAmtParams.stream().filter(billHeadAmtParam -> targetBill.getLong("id") == billHeadAmtParam.getId()).findFirst();
            if (!billHeadAmtParamOptional.isPresent()) continue;
            this.resetHeadAmtField(targetBill, billHeadAmtParamOptional.get());
        }
    }

    protected boolean billPushRecalculate(List<AssignBillPushParam> paramList) {
        boolean billPushRecalculate = false;
        for (AssignBillPushParam assignBillPushParam : paramList) {
            Map<String, Object> tarFieldValueMap = assignBillPushParam.getTarFieldValueMap();
            if (!tarFieldValueMap.containsKey("exchangerate")) continue;
            billPushRecalculate = true;
            break;
        }
        return billPushRecalculate;
    }

    protected List<Object> saveTargetBills(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList, String ruleId, List<DynamicObject> targetBills) {
        OperationResult saveResult = OperationServiceHelper.executeOperate((String)"save", (String)this.getTargetEntity(), (DynamicObject[])targetBills.toArray(new DynamicObject[0]), (OperateOption)OperateOption.create());
        OperationHelper.assertResult(saveResult);
        return saveResult.getSuccessPkIds();
    }

    protected final BillModel getBillModel() {
        return BillModelFactory.getModel(this.getTargetEntity());
    }

    protected void afterPush(String sourEntity, String sourEntryEntity, List<AssignBillPushParam> paramList, String ruleId, List<DynamicObject> targetBills) {
    }

    protected abstract String getTargetEntity();

    protected String getTargetEntryEntity() {
        return this.billModel.ENTRY;
    }

    protected String getTargetSourIdKey() {
        return this.billModel.E_SOURCEBILLID;
    }

    protected String getTargetSourEntryIdKey() {
        return this.billModel.E_SOURCEBILLENTRYID;
    }

    protected void resetEntryAmtField(PriceLocalCalculator localCalculator, DynamicObject targetBillEntry, List<AssignBillPushParam> paramList) {
        AbstractPriceCalculator calculator = localCalculator.getCalculator();
        Object sourEntryIdObj = targetBillEntry.get(this.getTargetSourEntryIdKey());
        long sourEntryId = Long.parseLong(sourEntryIdObj.toString());
        Optional<AssignBillPushParam> entryParamOptional = paramList.stream().filter(entryPushParam -> sourEntryId == entryPushParam.getSourBillEntryId()).findFirst();
        if (entryParamOptional.isPresent()) {
            AssignBillPushParam entryPushParam2 = entryParamOptional.get();
            Map<String, Object> tarFieldValueMap = entryPushParam2.getTarFieldValueMap();
            Object amount = tarFieldValueMap.get(this.billModel.E_AMOUNT);
            Object tax = tarFieldValueMap.get(this.billModel.E_TAX);
            Object pricetaxtotal = tarFieldValueMap.get(this.billModel.E_PRICETAXTOTAL);
            if (amount != null && tax != null && pricetaxtotal != null) {
                if (new BigDecimal(amount.toString()).add(new BigDecimal(tax.toString())).compareTo(new BigDecimal(pricetaxtotal.toString())) != 0) {
                    throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u91d1\u989d\u3001\u7a0e\u989d\u3001\u4ef7\u7a0e\u5408\u8ba1\u9700\u6ee1\u8db3\u516c\u5f0f\uff1a\u91d1\u989d+\u7a0e\u989d=\u4ef7\u7a0e\u5408\u8ba1\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractPushBillService_9", (String)"fi-arapcommon", (Object[])new Object[0]));
                }
                calculator.setAmount(new BigDecimal(amount.toString()));
                calculator.setTax(new BigDecimal(tax.toString()));
                calculator.setPricetaxtotal(new BigDecimal(pricetaxtotal.toString()));
            }
            if (amount != null && tax != null && pricetaxtotal == null) {
                calculator.setAmount(new BigDecimal(amount.toString()));
                calculator.setTax(new BigDecimal(tax.toString()));
                calculator.setPricetaxtotal(calculator.getAmount().add(calculator.getTax()).add(calculator.getAdjustamt()));
            }
            if (amount != null && tax == null && pricetaxtotal != null) {
                calculator.setAmount(new BigDecimal(amount.toString()));
                calculator.setPricetaxtotal(new BigDecimal(pricetaxtotal.toString()));
                calculator.setTax(calculator.getPricetaxtotal().subtract(calculator.getAmount()).subtract(calculator.getAdjustamt()));
            }
            if (amount == null && tax != null && pricetaxtotal != null) {
                calculator.setTax(new BigDecimal(tax.toString()));
                calculator.setPricetaxtotal(new BigDecimal(pricetaxtotal.toString()));
                calculator.setAmount(calculator.getPricetaxtotal().subtract(calculator.getTax()).subtract(calculator.getAdjustamt()));
            }
            if (amount != null && tax == null && pricetaxtotal == null) {
                calculator.setAmount(new BigDecimal(amount.toString()));
                calculator.setPricetaxtotal(calculator.getAmount().add(calculator.getTax()).add(calculator.getAdjustamt()));
            }
            if (amount == null && tax != null && pricetaxtotal == null) {
                calculator.setTax(new BigDecimal(tax.toString()));
                calculator.setPricetaxtotal(calculator.getAmount().add(calculator.getTax()).add(calculator.getAdjustamt()));
            }
            if (amount == null && tax == null && pricetaxtotal != null) {
                calculator.setPricetaxtotal(new BigDecimal(pricetaxtotal.toString()));
                calculator.setAmount(calculator.getPricetaxtotal().subtract(calculator.getTax()).subtract(calculator.getAdjustamt()));
            }
            localCalculator.setCalculate(false);
            localCalculator.calculate();
        }
        targetBillEntry.set(this.billModel.E_UNITPRICE, (Object)localCalculator.getUnitprice());
        targetBillEntry.set(this.billModel.E_TAXUNITPRICE, (Object)localCalculator.getTaxunitprice());
        targetBillEntry.set(this.billModel.E_TAX, (Object)localCalculator.getTax());
        targetBillEntry.set(this.billModel.E_TAXLOCALAMT, (Object)localCalculator.getTaxlocal());
        targetBillEntry.set(this.billModel.E_DISCOUNTAMOUNT, (Object)localCalculator.getDiscountamount());
        targetBillEntry.set(this.billModel.E_ACTUNITPRICE, (Object)localCalculator.getActunitprice());
        targetBillEntry.set(this.billModel.E_ACTTAXUNITPRICE, (Object)localCalculator.getActtaxunitprice());
        targetBillEntry.set(this.billModel.E_DISCOUNTLOCALAMT, (Object)localCalculator.getDiscountamountlocal());
        targetBillEntry.set(this.billModel.E_AMOUNT, (Object)localCalculator.getAmount());
        targetBillEntry.set(this.billModel.E_LOCALAMT, (Object)localCalculator.getAmountlocal());
        targetBillEntry.set(this.billModel.E_PRICETAXTOTAL, (Object)localCalculator.getPricetaxtotal());
        targetBillEntry.set(this.billModel.E_PRICETAXTOTALLOC, (Object)localCalculator.getPricetaxtotallocal());
    }

    protected void resetHeadAmtField(DynamicObject targetBill, BillHeadAmtParam billHeadAmtParam) {
        targetBill.set(this.billModel.HEAD_AMOUNT, (Object)billHeadAmtParam.getAmount());
        targetBill.set(this.billModel.HEAD_LOCALAMT, (Object)billHeadAmtParam.getAmountLocal());
        targetBill.set(this.billModel.HEAD_TAX, (Object)billHeadAmtParam.getTaxAmt());
        targetBill.set(this.billModel.HEAD_TAXLOCAMT, (Object)billHeadAmtParam.getTaxAmtLocal());
        targetBill.set(this.billModel.HEAD_PRICETAXTOTAL, (Object)billHeadAmtParam.getPriceTaxTotal());
        targetBill.set(this.billModel.HEAD_PRICETAXTOTALLOC, (Object)billHeadAmtParam.getPriceTaxTotalLocal());
    }

    protected List<String> canModifyFields() {
        ArrayList<String> canModifyFields = new ArrayList<String>();
        canModifyFields.add(this.billModel.HEAD_BILLTYPE);
        canModifyFields.add(this.billModel.HEAD_BIZDATE);
        canModifyFields.add(this.billModel.HEAD_DUEDATE);
        canModifyFields.add(this.billModel.HEAD_ASSTACTTYPE);
        canModifyFields.add(this.billModel.HEAD_ASSTACT);
        canModifyFields.add(this.billModel.HEAD_EXCHANGERATE);
        canModifyFields.add(this.billModel.HEAD_PAYPROPERTY);
        canModifyFields.add(this.billModel.E_UNITPRICE);
        canModifyFields.add(this.billModel.E_TAXUNITPRICE);
        canModifyFields.add(this.billModel.E_QUANTITY);
        canModifyFields.add(this.billModel.E_TAX);
        canModifyFields.add(this.billModel.E_AMOUNT);
        canModifyFields.add(this.billModel.E_PRICETAXTOTAL);
        canModifyFields.add(this.billModel.E_DISCOUNTMODE);
        canModifyFields.add(this.billModel.E_DISCOUNTRATE);
        canModifyFields.add(this.billModel.E_DISCOUNTAMOUNT);
        Map<String, List<String>> sdkExtendFieldMap = BizExtendHelper.invoicePushAssignFieldCallback();
        List extendFieldList = sdkExtendFieldMap.getOrDefault(this.getServiceName(), new ArrayList(2));
        canModifyFields.addAll(extendFieldList);
        return canModifyFields;
    }

    protected Map<String, String> getPushArgsMap() {
        return new HashMap<String, String>(2);
    }
}

