/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.api.settle;

import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.api.param.SettleResult;
import kd.fi.arapcommon.api.settle.IUnSettleService;
import kd.fi.arapcommon.exception.UnSettleServiceBizException;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.util.StringUtils;

public abstract class AbstractUnSettleService
implements IUnSettleService {
    @Override
    public SettleResult unSettleByBillId(String billEntity, Set<Long> billIds) {
        if (StringUtils.isEmpty(billEntity)) {
            throw new UnSettleServiceBizException(ResManager.loadKDString((String)"\u53c2\u6570\u3010\u5355\u636e\u6807\u8bc6\u3011\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractUnSettleService_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty(billIds)) {
            throw new UnSettleServiceBizException(ResManager.loadKDString((String)"\u53c2\u6570\u3010\u5355\u636eid\u3011\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractUnSettleService_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        HashSet<Long> settleRecordIds = new HashSet<Long>(billIds.size());
        QFilter mainFilter = new QFilter("mainbillid", "in", billIds);
        mainFilter.and("billentity", "=", (Object)billEntity);
        settleRecordIds.addAll(this.getSettleRecordIds(new QFilter[]{mainFilter}));
        QFilter asstFilter = new QFilter("entry.billid", "in", billIds);
        asstFilter.and("entry.e_billentity", "=", (Object)billEntity);
        settleRecordIds.addAll(this.getSettleRecordIds(new QFilter[]{asstFilter}));
        if (settleRecordIds.isEmpty()) {
            SettleResult result = new SettleResult();
            result.setData(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u5230\u5bf9\u5e94\u7684\u7ed3\u7b97\u8bb0\u5f55\u3002", (String)"AbstractUnSettleService_5", (String)"fi-arapcommon", (Object[])new Object[0]));
            return result;
        }
        return this.unSettleBySettleRecordId(settleRecordIds);
    }

    @Override
    public SettleResult unSettleByBillNo(String billEntity, Set<String> billNos) {
        if (StringUtils.isEmpty(billEntity)) {
            throw new UnSettleServiceBizException(ResManager.loadKDString((String)"\u53c2\u6570\u3010\u5355\u636e\u6807\u8bc6\u3011\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractUnSettleService_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty(billNos)) {
            throw new UnSettleServiceBizException(ResManager.loadKDString((String)"\u53c2\u6570\u3010\u5355\u636e\u7f16\u53f7\u3011\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractUnSettleService_2", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        HashSet<Long> settleRecordIds = new HashSet<Long>(billNos.size());
        QFilter mainFilter = new QFilter("billno", "in", billNos);
        mainFilter.and("billentity", "=", (Object)billEntity);
        settleRecordIds.addAll(this.getSettleRecordIds(new QFilter[]{mainFilter}));
        QFilter asstFilter = new QFilter("entry.billnum", "in", billNos);
        asstFilter.and("entry.e_billentity", "=", (Object)billEntity);
        settleRecordIds.addAll(this.getSettleRecordIds(new QFilter[]{asstFilter}));
        if (settleRecordIds.isEmpty()) {
            SettleResult result = new SettleResult();
            result.setData(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u5230\u5bf9\u5e94\u7684\u7ed3\u7b97\u8bb0\u5f55\u3002", (String)"AbstractUnSettleService_5", (String)"fi-arapcommon", (Object[])new Object[0]));
            return result;
        }
        return this.unSettleBySettleRecordId(settleRecordIds);
    }

    @Override
    public SettleResult unSettleBySettleRecordFilter(QFilter[] settleRecordFilter) {
        if (ObjectUtils.isEmpty((Object[])settleRecordFilter)) {
            throw new UnSettleServiceBizException(ResManager.loadKDString((String)"\u53c2\u6570\u3010\u8fc7\u6ee4\u6761\u4ef6\u3011\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractUnSettleService_3", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        Set<Long> settleRecordIds = this.getSettleRecordIds(settleRecordFilter);
        if (settleRecordIds.isEmpty()) {
            SettleResult result = new SettleResult();
            result.setData(ResManager.loadKDString((String)"\u6ca1\u6709\u67e5\u5230\u5bf9\u5e94\u7684\u7ed3\u7b97\u8bb0\u5f55\u3002", (String)"AbstractUnSettleService_5", (String)"fi-arapcommon", (Object[])new Object[0]));
            return result;
        }
        return this.unSettleBySettleRecordId(settleRecordIds);
    }

    @Override
    public SettleResult unSettleBySettleRecordId(Set<Long> settleRecordIds) {
        if (ObjectUtils.isEmpty(settleRecordIds)) {
            throw new UnSettleServiceBizException(ResManager.loadKDString((String)"\u53c2\u6570\u3010\u7ed3\u7b97\u8bb0\u5f55id\u3011\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractUnSettleService_4", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        OperationResult unsettleResult = OperationServiceHelper.executeOperate((String)"unsettle", (String)this.getSettleRecordEntity(), (Object[])settleRecordIds.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult(unsettleResult);
        SettleResult result = new SettleResult();
        result.setSettleRecordPKs(unsettleResult.getSuccessPkIds());
        return null;
    }

    public abstract String getSettleRecordEntity();

    private Set<Long> getSettleRecordIds(QFilter[] settleRecordFilter) {
        HashSet<Long> settleRecordIds = new HashSet<Long>(8);
        if (ObjectUtils.isEmpty((Object[])settleRecordFilter)) {
            return settleRecordIds;
        }
        DataSet rows = QueryServiceHelper.queryDataSet((String)"querymain", (String)this.getSettleRecordEntity(), (String)"id", (QFilter[])settleRecordFilter, (String)"");
        for (Row row : rows) {
            settleRecordIds.add(row.getLong("id"));
        }
        return settleRecordIds;
    }
}

