/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.api.settle;

import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.fi.arapcommon.api.helper.ServiceCheckHelper;
import kd.fi.arapcommon.api.settle.IUpdateSettleDateService;
import kd.fi.arapcommon.helper.InitHelper;
import kd.fi.arapcommon.helper.OperationHelper;
import kd.fi.arapcommon.service.log.ServiceInvokeLog;
import kd.fi.arapcommon.util.DateUtils;

public abstract class AbstractUpdateSettleDateService
implements IUpdateSettleDateService {
    @Override
    public void updateSettleDateByBillId(long orgId, Set<Long> mainBillIds, Date settleDate) {
        if (ObjectUtils.isEmpty(mainBillIds)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7ed3\u7b97\u8bb0\u5f55\u4e3b\u65b9\u5355\u636eID\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractUpdateSettleDateService_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        DataSet rows = QueryServiceHelper.queryDataSet((String)"updateSettleDateByBillId", (String)this.getSettleRecordEntity(), (String)"id", (QFilter[])new QFilter[]{new QFilter("mainbillid", "in", mainBillIds)}, (String)"");
        HashSet<Long> settleRecordPKs = new HashSet<Long>(8);
        for (Row row : rows) {
            settleRecordPKs.add(row.getLong("id"));
        }
        this.updateSettleDate(orgId, settleRecordPKs, settleDate);
    }

    @Override
    public void updateSettleDateByBillNo(long orgId, Set<String> mainBillNos, Date settleDate) {
        if (ObjectUtils.isEmpty(mainBillNos)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u7ed3\u7b97\u8bb0\u5f55\u4e3b\u65b9\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractUpdateSettleDateService_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        DataSet rows = QueryServiceHelper.queryDataSet((String)"updateSettleDateByBillId", (String)this.getSettleRecordEntity(), (String)"id", (QFilter[])new QFilter[]{new QFilter("billno", "in", mainBillNos)}, (String)"");
        HashSet<Long> settleRecordPKs = new HashSet<Long>(8);
        for (Row row : rows) {
            settleRecordPKs.add(row.getLong("id"));
        }
        this.updateSettleDate(orgId, settleRecordPKs, settleDate);
    }

    @Override
    @ServiceInvokeLog
    public void updateSettleDate(long orgId, Set<Long> settleRecordPKs, Date settleDate) {
        this.checkParam(orgId, settleRecordPKs, settleDate);
        InitHelper init = new InitHelper(orgId, this.getInitEntity());
        Date currentDate = init.getCurrentDate();
        OperateOption option = OperateOption.create();
        option.setVariableValue("newdate", SerializationUtils.toJsonString((Object)settleDate));
        option.setVariableValue("currentdate", SerializationUtils.toJsonString((Object)currentDate));
        OperationResult result = OperationServiceHelper.executeOperate((String)"updatesettledate", (String)this.getSettleRecordEntity(), (Object[])settleRecordPKs.toArray(), (OperateOption)option);
        OperationHelper.assertResult(result);
    }

    protected void checkParam(long orgId, Set<Long> settleRecordPKs, Date settleDate) {
        Date maxBillDate;
        ServiceCheckHelper.checkOrg(orgId);
        if (ObjectUtils.isEmpty(settleRecordPKs)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9700\u8981\u66f4\u65b0\u7684\u7ed3\u7b97\u8bb0\u5f55id\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"AbstractUpdateSettleDateService_2", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        if (ObjectUtils.isEmpty((Object)settleDate)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ed3\u7b97\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"AbstractUpdateSettleDateService_3", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        InitHelper init = new InitHelper(orgId, this.getInitEntity());
        boolean finishInit = init.isFinishInit();
        if (!finishInit) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7ec4\u7ec7\u672a\u7ed3\u675f\u521d\u59cb\u5316\uff0c\u4e0d\u5141\u8bb8\u66f4\u65b0\u7ed3\u7b97\u65e5\u671f\u3002", (String)"AbstractUpdateSettleDateService_4", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        ServiceCheckHelper.checkOrgEqual(orgId, this.getSettleRecordEntity(), settleRecordPKs);
        Date currentDate = init.getCurrentDate();
        if (DateUtils.getDiffDays(settleDate, currentDate) > 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u63a5\u53e3\u6307\u5b9a\u7684\u7ed3\u7b97\u65e5\u671f\u4e0d\u80fd\u5c0f\u4e8e\u4e1a\u52a1\u7cfb\u7edf\u7684\u5f53\u524d\u65e5\u671f[%s]\u3002", (String)"AbstractUpdateSettleDateService_5", (String)"fi-arapcommon", (Object[])new Object[]{currentDate}));
        }
        OperationResult result = OperationServiceHelper.executeOperate((String)"modifysettledate", (String)this.getSettleRecordEntity(), (Object[])settleRecordPKs.toArray(), (OperateOption)OperateOption.create());
        OperationHelper.assertResult(result);
        DynamicObject[] settleRecords = BusinessDataServiceHelper.load((String)this.getSettleRecordEntity(), (String)"org,settledate,isvoucher,settleseq,mainbizdate,billentity,mainbillid,entry.billdate,entry.billid,entry.e_billentity", (QFilter[])new QFilter[]{new QFilter("id", "in", settleRecordPKs)});
        HashSet<String> settleSeq = new HashSet<String>(settleRecords.length);
        HashSet<Long> pks = new HashSet<Long>(settleRecords.length);
        for (DynamicObject settleRecord : settleRecords) {
            boolean isVoucher = settleRecord.getBoolean("isvoucher");
            if (!isVoucher) continue;
            settleSeq.add(settleRecord.getString("settleseq"));
            pks.add(settleRecord.getLong("id"));
        }
        if (!pks.isEmpty()) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7[%1$s]-\u7ed3\u7b97\u5e8f\u53f7%2$s-\u7ed3\u7b97\u8bb0\u5f55id%3$s\u5bf9\u5e94\u7684\u7ed3\u7b97\u8bb0\u5f55\u5df2\u751f\u6210\u51ed\u8bc1\uff0c\u4e0d\u5141\u8bb8\u66f4\u65b0\u7ed3\u7b97\u65e5\u671f\u3002", (String)"AbstractUpdateSettleDateService_6", (String)"fi-arapcommon", (Object[])new Object[0]), settleRecords[0].getString("org.name"), ((Object)settleSeq).toString(), ((Object)pks).toString()));
        }
        if (!ObjectUtils.isEmpty((Object)currentDate)) {
            for (DynamicObject settleRecord : settleRecords) {
                Date billSettleDate = settleRecord.getDate("settledate");
                if (DateUtils.getDiffDays(billSettleDate, currentDate) <= 0) continue;
                settleSeq.add(settleRecord.getString("settleseq"));
                pks.add(settleRecord.getLong("id"));
            }
            if (!pks.isEmpty()) {
                throw new KDBizException(String.format(ResManager.loadKDString((String)"\u7ed3\u7b97\u7ec4\u7ec7[%1$s]-\u7ed3\u7b97\u5e8f\u53f7%2$s-\u7ed3\u7b97\u8bb0\u5f55id%3$s\u5bf9\u5e94\u7684\u7ed3\u7b97\u65e5\u671f\u5df2\u7ecf\u5173\u8d26\uff0c\u4e0d\u5141\u8bb8\u4fee\u6539\u3002", (String)"AbstractUpdateSettleDateService_7", (String)"fi-arapcommon", (Object[])new Object[0]), settleRecords[0].getString("org.name"), ((Object)settleSeq).toString(), ((Object)pks).toString()));
            }
        }
        if (DateUtils.getDiffDays(maxBillDate = this.getMaxBillDate(settleRecords), settleDate) < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u6307\u5b9a\u7684\u7ed3\u7b97\u65e5\u671f\u5e94\u5927\u4e8e\u7b49\u4e8e\u7ed3\u7b97\u53cc\u65b9\u5355\u636e\u8bb0\u8d26\u6216\u4e1a\u52a1\u65e5\u671f[%s]\u3002", (String)"AbstractUpdateSettleDateService_8", (String)"fi-arapcommon", (Object[])new Object[]{maxBillDate}));
        }
    }

    private Date getMaxBillDate(DynamicObject[] settleRecords) {
        Date bookDate;
        Date maxDate = settleRecords[0].getDate("mainbizdate");
        HashSet<Long> finarBillIds = new HashSet<Long>(settleRecords.length);
        HashSet<Long> finapBillIds = new HashSet<Long>(settleRecords.length);
        for (DynamicObject settleRecord : settleRecords) {
            Date mainBizDate;
            String billEntity = settleRecord.getString("billentity");
            if ("ar_finarbill".equals(billEntity)) {
                finarBillIds.add(settleRecord.getLong("mainbillid"));
            }
            if ("ap_finapbill".equals(billEntity)) {
                finapBillIds.add(settleRecord.getLong("mainbillid"));
            }
            maxDate = maxDate.after(mainBizDate = settleRecord.getDate("mainbizdate")) ? maxDate : mainBizDate;
            DynamicObjectCollection entries = settleRecord.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                Date e_BizDate;
                String e_billentity = entry.getString("e_billentity");
                if ("ar_finarbill".equals(e_billentity)) {
                    finarBillIds.add(entry.getLong("billid"));
                }
                if ("ap_finapbill".equals(e_billentity)) {
                    finapBillIds.add(entry.getLong("billid"));
                }
                maxDate = maxDate.after(e_BizDate = entry.getDate("billdate")) ? maxDate : e_BizDate;
            }
        }
        if (!finarBillIds.isEmpty()) {
            DataSet arRows = QueryServiceHelper.queryDataSet((String)"queryarbookdate", (String)"ar_finarbill", (String)"id,bookdate", (QFilter[])new QFilter[]{new QFilter("id", "in", finarBillIds)}, (String)"");
            for (Row row : arRows) {
                bookDate = row.getDate("bookdate");
                if (bookDate == null) continue;
                maxDate = maxDate.after(bookDate) ? maxDate : bookDate;
            }
        }
        if (!finapBillIds.isEmpty()) {
            DataSet apRows = QueryServiceHelper.queryDataSet((String)"queryapbookdate", (String)"ap_finapbill", (String)"id,bookdate", (QFilter[])new QFilter[]{new QFilter("id", "in", finapBillIds)}, (String)"");
            for (Row row : apRows) {
                bookDate = row.getDate("bookdate");
                if (bookDate == null) continue;
                maxDate = maxDate.after(bookDate) ? maxDate : bookDate;
            }
        }
        return maxDate;
    }

    protected abstract String getSettleRecordEntity();

    protected abstract String getInitEntity();
}

