/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.autopush;

import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.mq.MessageAcker;
import kd.bos.mq.MessageConsumer;
import kd.fi.arapcommon.tx.AsyncTx;
import kd.fi.arapcommon.tx.AsyncTxService;

public class AutoPushConsumer
implements MessageConsumer {
    public void onMessage(Object message, String messageId, boolean resend, MessageAcker acker) {
        try (TXHandle txHandle = TX.required();){
            AsyncTx tx = (AsyncTx)message;
            AsyncTxService asyncTxService = new AsyncTxService();
            try {
                asyncTxService.execute(tx);
                asyncTxService.handleSuccess(tx);
                acker.ack(messageId);
            }
            catch (Exception e) {
                txHandle.markRollback();
                try (TXHandle txh = TX.requiresNew();){
                    asyncTxService.handleException(tx, e);
                    acker.ack(messageId);
                }
            }
        }
    }
}

