/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.balance;

import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.entity.property.AmountProp;
import kd.fi.arapcommon.balance.BalJouMappingInfo;
import kd.fi.arapcommon.util.EntityMetadataUtils;

public class BalJouMapper {
    private Map<String, BalJouMappingInfo> map = new HashMap<String, BalJouMappingInfo>();
    private String journalEntityKey;
    private String balanceEntityKey;

    public BalJouMapper(boolean isAp) {
        this.balanceEntityKey = isAp ? "ap_newbalance" : "ar_balance";
        this.journalEntityKey = isAp ? "ap_journal" : "ar_journal";
    }

    public List<String> getBalanceFields() {
        return new LinkedList<String>(this.map.keySet());
    }

    public String getJournalField(String balanceField) {
        BalJouMappingInfo balJouMappingInfo = this.map.get(balanceField);
        if (balJouMappingInfo != null) {
            return balJouMappingInfo.getJournalField();
        }
        return null;
    }

    public BalJouMappingInfo.CalculateType getCalculateType(String balanceField) {
        BalJouMappingInfo balJouMappingInfo = this.map.get(balanceField);
        if (balJouMappingInfo != null) {
            return balJouMappingInfo.getCalculateType();
        }
        return null;
    }

    public String getFormula(String balanceField) {
        BalJouMappingInfo balJouMappingInfo = this.map.get(balanceField);
        if (balJouMappingInfo != null) {
            return balJouMappingInfo.getFormula();
        }
        return null;
    }

    private void set(String balanceField, String journalField, BalJouMappingInfo.CalculateType calculateType, String formula) {
        BalJouMappingInfo balJouMappingInfo = new BalJouMappingInfo();
        balJouMappingInfo.setBalanceField(balanceField);
        balJouMappingInfo.setJournalField(journalField);
        balJouMappingInfo.setCalculateType(calculateType);
        balJouMappingInfo.setFormula(formula);
        this.map.put(balanceField, balJouMappingInfo);
    }

    public void load() {
        this.map.clear();
        this.set("org", "org", BalJouMappingInfo.CalculateType.DIMENSION, null);
        this.set("asstacttype", "asstacttype", BalJouMappingInfo.CalculateType.DIMENSION, null);
        this.set("asstact", "asstact", BalJouMappingInfo.CalculateType.DIMENSION, null);
        this.set("currency", "currency", BalJouMappingInfo.CalculateType.DIMENSION, null);
        this.set("basecurrency", "basecurrency", BalJouMappingInfo.CalculateType.DIMENSION, null);
        if ("ar_balance".equals(this.balanceEntityKey)) {
            this.set("periodfinamt", null, BalJouMappingInfo.CalculateType.FORMULA, "previous(finbalance)");
            this.set("localperiodfinamt", null, BalJouMappingInfo.CalculateType.FORMULA, "previous(localfinbalance)");
            this.set("periodbusamt", null, BalJouMappingInfo.CalculateType.FORMULA, "previous(busbalance)");
            this.set("localperiodbusamt", null, BalJouMappingInfo.CalculateType.FORMULA, "previous(localbusbalance)");
            this.set("periodbusnotaxamt", null, BalJouMappingInfo.CalculateType.FORMULA, "previous(busnotaxbalance)");
            this.set("localperiodbusnotaxamt", null, BalJouMappingInfo.CalculateType.FORMULA, "previous(localbusnotaxbalance)");
            this.set("periodreceivedamt", null, BalJouMappingInfo.CalculateType.FORMULA, "previous(receivedbalance)");
            this.set("localperiodreceivedamt", null, BalJouMappingInfo.CalculateType.FORMULA, "previous(localreceivedbalance)");
            this.set("finamt", "receivableamt", BalJouMappingInfo.CalculateType.SUM, null);
            this.set("localfinamt", "localreceivableamt", BalJouMappingInfo.CalculateType.SUM, null);
            this.set("busamt", "estimatedamt", BalJouMappingInfo.CalculateType.SUM, null);
            this.set("localbusamt", "localestimatedamt", BalJouMappingInfo.CalculateType.SUM, null);
            this.set("busnotaxamt", "estimatednotaxamt", BalJouMappingInfo.CalculateType.SUM, null);
            this.set("localbusnotaxamt", "localestimatednotaxamt", BalJouMappingInfo.CalculateType.SUM, null);
            this.set("receivedamt", "receivedamt", BalJouMappingInfo.CalculateType.SUM, null);
            this.set("localreceivedamt", "localreceivedamt", BalJouMappingInfo.CalculateType.SUM, null);
            this.set("finbalance", null, BalJouMappingInfo.CalculateType.FORMULA, "periodfinamt+finamt");
            this.set("localfinbalance", null, BalJouMappingInfo.CalculateType.FORMULA, "localperiodfinamt+localfinamt");
            this.set("busbalance", null, BalJouMappingInfo.CalculateType.FORMULA, "periodbusamt+busamt");
            this.set("localbusbalance", null, BalJouMappingInfo.CalculateType.FORMULA, "localperiodbusamt+localbusamt");
            this.set("busnotaxbalance", null, BalJouMappingInfo.CalculateType.FORMULA, "periodbusnotaxamt+busnotaxamt");
            this.set("localbusnotaxbalance", null, BalJouMappingInfo.CalculateType.FORMULA, "localperiodbusnotaxamt+localbusnotaxamt");
            this.set("receivedbalance", null, BalJouMappingInfo.CalculateType.FORMULA, "periodreceivedamt+receivedamt");
            this.set("localreceivedbalance", null, BalJouMappingInfo.CalculateType.FORMULA, "localperiodreceivedamt+localreceivedamt");
        } else {
            this.set("periodfinamt", null, BalJouMappingInfo.CalculateType.FORMULA, "previous(finbalance)");
            this.set("localperiodfinamt", null, BalJouMappingInfo.CalculateType.FORMULA, "previous(localfinbalance)");
            this.set("periodbusamt", null, BalJouMappingInfo.CalculateType.FORMULA, "previous(busbalance)");
            this.set("localperiodbusamt", null, BalJouMappingInfo.CalculateType.FORMULA, "previous(localbusbalance)");
            this.set("periodbusnotaxamt", null, BalJouMappingInfo.CalculateType.FORMULA, "previous(busnotaxbalance)");
            this.set("localperiodbusnotaxamt", null, BalJouMappingInfo.CalculateType.FORMULA, "previous(localbusnotaxbalance)");
            this.set("periodprepaidamt", null, BalJouMappingInfo.CalculateType.FORMULA, "previous(prepaidbalance)");
            this.set("localperiodprepaidamt", null, BalJouMappingInfo.CalculateType.FORMULA, "previous(localprepaidbalance)");
            this.set("finamt", "payableamt", BalJouMappingInfo.CalculateType.SUM, null);
            this.set("localfinamt", "localpayableamt", BalJouMappingInfo.CalculateType.SUM, null);
            this.set("busamt", "estimatedamt", BalJouMappingInfo.CalculateType.SUM, null);
            this.set("localbusamt", "localestimatedamt", BalJouMappingInfo.CalculateType.SUM, null);
            this.set("busnotaxamt", "estimatednotaxamt", BalJouMappingInfo.CalculateType.SUM, null);
            this.set("localbusnotaxamt", "localestimatednotaxamt", BalJouMappingInfo.CalculateType.SUM, null);
            this.set("prepaidamt", "prepaidamt", BalJouMappingInfo.CalculateType.SUM, null);
            this.set("localprepaidamt", "localprepaidamt", BalJouMappingInfo.CalculateType.SUM, null);
            this.set("finbalance", null, BalJouMappingInfo.CalculateType.FORMULA, "periodfinamt+finamt");
            this.set("localfinbalance", null, BalJouMappingInfo.CalculateType.FORMULA, "localperiodfinamt+localfinamt");
            this.set("busbalance", null, BalJouMappingInfo.CalculateType.FORMULA, "periodbusamt+busamt");
            this.set("localbusbalance", null, BalJouMappingInfo.CalculateType.FORMULA, "localperiodbusamt+localbusamt");
            this.set("busnotaxbalance", null, BalJouMappingInfo.CalculateType.FORMULA, "periodbusnotaxamt+busnotaxamt");
            this.set("localbusnotaxbalance", null, BalJouMappingInfo.CalculateType.FORMULA, "localperiodbusnotaxamt+localbusnotaxamt");
            this.set("prepaidbalance", null, BalJouMappingInfo.CalculateType.FORMULA, "periodprepaidamt+prepaidamt");
            this.set("localprepaidbalance", null, BalJouMappingInfo.CalculateType.FORMULA, "localperiodprepaidamt+localprepaidamt");
        }
    }

    public void autoBuild() {
        List<IDataEntityProperty> balanceProperties = EntityMetadataUtils.getProperties(this.balanceEntityKey);
        List<IDataEntityProperty> journalProperties = EntityMetadataUtils.getProperties(this.journalEntityKey);
        for (IDataEntityProperty bp : balanceProperties) {
            IDataEntityProperty matchedJournalProp;
            String balanceField = bp.getName();
            if (this.map.containsKey(balanceField) || "id".equals(balanceField) || balanceField.endsWith("_id") || (matchedJournalProp = this.matchProp(bp, journalProperties)) == null) continue;
            BalJouMappingInfo balJouMappingInfo = new BalJouMappingInfo();
            balJouMappingInfo.setBalanceField(balanceField);
            if (matchedJournalProp instanceof AmountProp) {
                balJouMappingInfo.setCalculateType(BalJouMappingInfo.CalculateType.SUM);
            } else {
                balJouMappingInfo.setCalculateType(BalJouMappingInfo.CalculateType.DIMENSION);
            }
            balJouMappingInfo.setJournalField(matchedJournalProp.getName());
            this.map.put(balanceField, balJouMappingInfo);
        }
    }

    private IDataEntityProperty matchProp(IDataEntityProperty prop, List<IDataEntityProperty> sourceBillProps) {
        for (IDataEntityProperty sourceProp : sourceBillProps) {
            if (!prop.getName().equals(sourceProp.getName())) continue;
            return sourceProp;
        }
        return null;
    }

    public String getJournalEntityKey() {
        return this.journalEntityKey;
    }

    public void setJournalEntityKey(String journalEntityKey) {
        this.journalEntityKey = journalEntityKey;
    }

    public String getBalanceEntityKey() {
        return this.balanceEntityKey;
    }

    public void setBalanceEntityKey(String balanceEntityKey) {
        this.balanceEntityKey = balanceEntityKey;
    }

    public static BalJouMapper getMapper(boolean isAp) {
        BalJouMapper balJouMapper = new BalJouMapper(isAp);
        balJouMapper.load();
        balJouMapper.autoBuild();
        return balJouMapper;
    }
}

