/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.balance;

import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.fi.arapcommon.balance.BalJouMapper;
import kd.fi.arapcommon.balance.BalanceCalculateParam;
import kd.fi.arapcommon.balance.BalanceCalculator;
import kd.fi.arapcommon.balance.BalanceSettingParser;
import kd.fi.arapcommon.service.CloseRecordService;
import kd.fi.arapcommon.util.DateUtils;

public class BalanceBuilder {
    private BalJouMapper balJouMapper;
    private BalanceSettingParser balanceSettingParser;
    private boolean isAp;

    public BalanceBuilder(boolean isAp) {
        this.balJouMapper = BalJouMapper.getMapper(isAp);
        this.balanceSettingParser = new BalanceSettingParser(this.balJouMapper);
        this.isAp = isAp;
    }

    private DataSet getBalanceDataSet(Long orgId, DynamicObject lastCloseRecord, Date beginDate, Date endDate) {
        BalanceCalculateParam balanceCalculateParam = new BalanceCalculateParam();
        balanceCalculateParam.setOrgId(orgId);
        balanceCalculateParam.setBalanceDimensions(this.balanceSettingParser.getBalanceDimensions());
        balanceCalculateParam.setBalanceDate(endDate);
        if (lastCloseRecord != null) {
            balanceCalculateParam.setLastCloseId(lastCloseRecord.getLong("id"));
            balanceCalculateParam.setLastCloseDate(lastCloseRecord.getDate("closedate"));
        }
        balanceCalculateParam.setBalanceFormulas(this.balanceSettingParser.getBalanceFormulas());
        BalanceCalculator balanceCalculator = new BalanceCalculator(this.balJouMapper);
        return balanceCalculator.calculateBalance(balanceCalculateParam);
    }

    public List<DynamicObject> buildBalance(Long orgId, DynamicObject curperiod) {
        Date beginDate = curperiod.getDate("begindate");
        Date endDate = curperiod.getDate("enddate");
        CloseRecordService closeRecordService = new CloseRecordService(this.isAp);
        DynamicObject lastCloseRecord = closeRecordService.queryCloseRecord(orgId, beginDate);
        DataSet balanceDataSet = this.getBalanceDataSet(orgId, lastCloseRecord, beginDate, endDate);
        DynamicObject currentCloseRecord = closeRecordService.queryCloseRecord(orgId, endDate);
        Long closeSeq = currentCloseRecord == null ? 0L : currentCloseRecord.getLong("id");
        return this.buildDynamicObjects(balanceDataSet, closeSeq, curperiod, beginDate, endDate);
    }

    public List<DynamicObject> buildBalance(Long orgId, Date beginDate, Date endDate) {
        CloseRecordService closeRecordService = new CloseRecordService(this.isAp);
        DynamicObject lastCloseRecord = closeRecordService.queryCloseRecord(orgId, beginDate);
        DataSet balanceDataSet = this.getBalanceDataSet(orgId, lastCloseRecord, beginDate, endDate);
        DynamicObject currentCloseRecord = closeRecordService.queryCloseRecord(orgId, endDate);
        Long closeSeq = currentCloseRecord == null ? 0L : currentCloseRecord.getLong("id");
        return this.buildDynamicObjects(balanceDataSet, closeSeq, beginDate, endDate);
    }

    private List<DynamicObject> buildDynamicObjects(DataSet journalDataSet, long closeSeq, DynamicObject curperiod, Date beginDate, Date endDate) {
        LinkedList<DynamicObject> result = new LinkedList<DynamicObject>();
        MainEntityType balanceEntityType = MetadataServiceHelper.getDataEntityType((String)this.balJouMapper.getBalanceEntityKey());
        List<String> balanceFields = this.balJouMapper.getBalanceFields();
        List<String> balanceAmtFields = this.balanceSettingParser.getBalanceAmtFields();
        for (Row row : journalDataSet) {
            DynamicObject balance = new DynamicObject((DynamicObjectType)balanceEntityType);
            boolean isAllAmtEmpty = true;
            for (String balanceField : balanceFields) {
                Object fieldValue = row.get(balanceField);
                if (balanceAmtFields.contains(balanceField)) {
                    isAllAmtEmpty = isAllAmtEmpty && ObjectUtils.isEmpty((Object)fieldValue);
                }
                balance.set(balanceField, fieldValue);
            }
            if (isAllAmtEmpty) continue;
            if (curperiod != null && ((MainEntityType)balance.getDynamicObjectType()).findProperty("period") != null) {
                balance.set("period", (Object)curperiod);
            }
            balance.set("startdate", (Object)beginDate);
            balance.set("stopdate", (Object)DateUtils.truncateDate(endDate));
            balance.set("closeid", (Object)closeSeq);
            result.add(balance);
        }
        return result;
    }

    private List<DynamicObject> buildDynamicObjects(DataSet journalDataSet, long closeSeq, Date beginDate, Date endDate) {
        return this.buildDynamicObjects(journalDataSet, closeSeq, null, beginDate, endDate);
    }
}

