/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.balance;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class BalanceFormula {
    private String balanceKey;
    private String formula;
    private boolean isPreviousFunc = false;

    public BalanceFormula() {
    }

    public BalanceFormula(String balanceKey, String formula) {
        this.balanceKey = balanceKey;
        this.setFormula(formula);
    }

    public String getBalanceKey() {
        return this.balanceKey;
    }

    public void setBalanceKey(String balanceKey) {
        this.balanceKey = balanceKey;
    }

    public String getFormula() {
        return this.formula;
    }

    public final void setFormula(String formula) {
        if (formula.startsWith("previous(")) {
            this.formula = formula.replace("previous(", "").replace(")", "");
            this.isPreviousFunc = true;
        } else {
            this.formula = formula;
        }
    }

    public boolean isPreviousFunc() {
        return this.isPreviousFunc;
    }

    public void setPreviousFunc(boolean isPreviousFunc) {
        this.isPreviousFunc = isPreviousFunc;
    }

    public List<String> getFormulaKeys() {
        if (this.isPreviousFunc) {
            return Collections.singletonList(this.formula);
        }
        ArrayList<String> keys = new ArrayList<String>();
        StringBuilder tem = new StringBuilder();
        char[] charArray = this.formula.toCharArray();
        for (int i = 0; i < charArray.length; ++i) {
            if (this.isOperator(charArray[i])) {
                keys.add(tem.toString().trim());
                tem = new StringBuilder();
                continue;
            }
            tem.append(charArray[i]);
        }
        if (tem.length() > 0) {
            keys.add(tem.toString().trim());
        }
        return keys;
    }

    private boolean isOperator(char c) {
        return '+' == c || '-' == c || '*' == c || '/' == c;
    }

    public String toString() {
        return this.balanceKey + "=" + this.formula;
    }
}

