/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.balance;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.fi.arapcommon.balance.BalanceBuilder;
import kd.fi.arapcommon.util.DateUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;

public class BalanceRebuildService {
    private Long orgId;
    private Date rebuildDate;
    private String closeRecordEntity;
    private String balanceEntity;
    private boolean isAp;

    public BalanceRebuildService(Long orgId, Date date, String app) {
        this.orgId = orgId;
        this.isAp = "ap".equals(app);
        this.rebuildDate = DateUtils.getDataFormat(date, true);
        if ("ap".equals(app)) {
            this.closeRecordEntity = "ap_closerecord";
            this.balanceEntity = "ap_newbalance";
        } else {
            this.closeRecordEntity = "ar_closerecord";
            this.balanceEntity = "ar_balance";
        }
    }

    public void rebuild() {
        Object[] laterCloseRecords = this.queryLaterCloseRecords();
        if (ObjectUtils.isEmpty((Object[])laterCloseRecords)) {
            return;
        }
        ArrayList<ImmutablePair> rangeList = new ArrayList<ImmutablePair>(64);
        ArrayList<Long> closeIdList = new ArrayList<Long>(64);
        if (laterCloseRecords[0].getDate("closedate").compareTo(this.rebuildDate) >= 0) {
            ImmutablePair firstDateRange = new ImmutablePair(null, (Object)DateUtils.getDataFormat(laterCloseRecords[0].getDate("closedate"), false));
            rangeList.add(firstDateRange);
            closeIdList.add(laterCloseRecords[0].getLong("id"));
        }
        for (int i = 0; i < laterCloseRecords.length - 1; ++i) {
            Date nextDay = DateUtils.getNextDay(laterCloseRecords[i].getDate("closedate"), 1);
            ImmutablePair dateRange = new ImmutablePair((Object)DateUtils.getDataFormat(nextDay, true), (Object)DateUtils.getDataFormat(laterCloseRecords[i + 1].getDate("closedate"), false));
            rangeList.add(dateRange);
            closeIdList.add(laterCloseRecords[i + 1].getLong("id"));
        }
        QFilter qFilter = new QFilter("closeid", "in", closeIdList);
        DeleteServiceHelper.delete((String)this.balanceEntity, (QFilter[])new QFilter[]{qFilter});
        for (ImmutablePair dateRange : rangeList) {
            BalanceBuilder balanceBuilder = new BalanceBuilder(this.isAp);
            List<DynamicObject> balance = balanceBuilder.buildBalance(this.orgId, (Date)dateRange.getLeft(), (Date)dateRange.getRight());
            SaveServiceHelper.save((DynamicObject[])balance.toArray(new DynamicObject[0]));
        }
    }

    private DynamicObject[] queryLaterCloseRecords() {
        Date lastCloseDate = this.queryLastCloseDate();
        QFilter dateFilter = new QFilter("closedate", ">=", (Object)DateUtils.getDataFormat(lastCloseDate, true));
        QFilter orgFilter = new QFilter("org", "=", (Object)this.orgId);
        return BusinessDataServiceHelper.load((String)this.closeRecordEntity, (String)"id,closedate", (QFilter[])new QFilter[]{dateFilter, orgFilter}, (String)"closedate asc");
    }

    private Date queryLastCloseDate() {
        QFilter dateFilter = new QFilter("closedate", "<", (Object)this.rebuildDate);
        QFilter orgFilter = new QFilter("org", "=", (Object)this.orgId);
        DynamicObject[] closeRecords = BusinessDataServiceHelper.load((String)this.closeRecordEntity, (String)"id,closedate", (QFilter[])new QFilter[]{dateFilter, orgFilter}, (String)"closedate desc", (int)1);
        if (closeRecords.length == 0) {
            return this.rebuildDate;
        }
        return closeRecords[0].getDate("closedate");
    }
}

