/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.balance;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import kd.fi.arapcommon.balance.BalJouMapper;
import kd.fi.arapcommon.balance.BalJouMappingInfo;
import kd.fi.arapcommon.balance.BalanceFormula;

public class BalanceSettingParser {
    private BalJouMapper mapper;

    public BalanceSettingParser(BalJouMapper mapper) {
        this.mapper = mapper;
    }

    public List<String> getBalanceDimensions() {
        List<String> balanceFields = this.mapper.getBalanceFields();
        ArrayList<String> dimensions = new ArrayList<String>();
        balanceFields.forEach(balanceField -> {
            BalJouMappingInfo.CalculateType calculateType = this.mapper.getCalculateType((String)balanceField);
            if (BalJouMappingInfo.CalculateType.DIMENSION == calculateType) {
                dimensions.add((String)balanceField);
            }
        });
        return dimensions;
    }

    public List<String> getBalanceAmtFields() {
        List<String> balanceFields = this.mapper.getBalanceFields();
        ArrayList<String> amtFields = new ArrayList<String>();
        balanceFields.forEach(balanceField -> {
            BalJouMappingInfo.CalculateType calculateType = this.mapper.getCalculateType((String)balanceField);
            if (BalJouMappingInfo.CalculateType.DIMENSION != calculateType) {
                amtFields.add((String)balanceField);
            }
        });
        return amtFields;
    }

    public BalanceFormula getFormula(String balanceField) {
        BalJouMappingInfo.CalculateType calculateType = this.mapper.getCalculateType(balanceField);
        if (BalJouMappingInfo.CalculateType.FORMULA == calculateType) {
            String formula = this.mapper.getFormula(balanceField);
            return new BalanceFormula(balanceField, formula);
        }
        return null;
    }

    public List<BalanceFormula> getBalanceFormulas() {
        ArrayList<BalanceFormula> balanceFormulas = new ArrayList<BalanceFormula>();
        List<String> balanceFields = this.mapper.getBalanceFields();
        for (String bf : balanceFields) {
            BalJouMappingInfo.CalculateType calculateType = this.mapper.getCalculateType(bf);
            if (BalJouMappingInfo.CalculateType.FORMULA != calculateType) continue;
            String formula = this.mapper.getFormula(bf);
            BalanceFormula balanceFormula = new BalanceFormula(bf, formula);
            balanceFormulas.add(balanceFormula);
        }
        return balanceFormulas;
    }

    public List<String> getJournalGroupByFields() {
        HashSet<String> groupByFields = new HashSet<String>();
        List<String> balanceFields = this.mapper.getBalanceFields();
        for (String bal : balanceFields) {
            BalJouMappingInfo.CalculateType calculateType = this.mapper.getCalculateType(bal);
            if (BalJouMappingInfo.CalculateType.DIMENSION != calculateType) continue;
            groupByFields.add(this.mapper.getJournalField(bal));
        }
        return new ArrayList<String>(groupByFields);
    }

    public List<String> getJournalSumFields() {
        HashSet<String> sumFields = new HashSet<String>();
        List<String> balanceFields = this.mapper.getBalanceFields();
        for (String bal : balanceFields) {
            BalJouMappingInfo.CalculateType calculateType = this.mapper.getCalculateType(bal);
            if (BalJouMappingInfo.CalculateType.SUM != calculateType) continue;
            sumFields.add(this.mapper.getJournalField(bal));
        }
        return new ArrayList<String>(sumFields);
    }

    public List<String> getBalanceFields(String journalField) {
        List<String> balanceFields = this.mapper.getBalanceFields();
        ArrayList<String> result = new ArrayList<String>();
        for (String bf : balanceFields) {
            if (!journalField.equalsIgnoreCase(this.mapper.getJournalField(bf))) continue;
            result.add(bf);
        }
        return result;
    }
}

