/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.business.piaozone.kingdee;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.arapcommon.business.piaozone.cv.JsonParseUtils;
import kd.fi.arapcommon.business.piaozone.exception.PZAuthException;
import kd.fi.arapcommon.business.piaozone.info.CompanyInfo;
import kd.fi.arapcommon.business.piaozone.info.InvoiceAttachmentVo;
import kd.fi.arapcommon.business.piaozone.info.InvoiceDetailRetrunVO;
import kd.fi.arapcommon.business.piaozone.info.InvoiceVO;
import kd.fi.arapcommon.business.piaozone.info.QueryInvoiceDetailInfo;
import kd.fi.arapcommon.business.piaozone.info.QueryInvoiceDetailParam;
import kd.fi.arapcommon.business.piaozone.kingdee.ConfigCache;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.business.piaozone.kingdee.action.AbstractAction;
import kd.fi.arapcommon.business.piaozone.kingdee.action.ApTokenAction;
import kd.fi.arapcommon.business.piaozone.kingdee.action.ApTokenActionImg;
import kd.fi.arapcommon.business.piaozone.kingdee.action.InvDownloadAction;
import kd.fi.arapcommon.business.piaozone.kingdee.action.InvDownloadByNoAction;
import kd.fi.arapcommon.business.piaozone.kingdee.action.InvoiceFilesAction;
import kd.fi.arapcommon.business.piaozone.kingdee.action.QueryBySerialNoAction;
import kd.fi.arapcommon.business.piaozone.kingdee.action.QueryXbrlBySerialNoAction;
import kd.fi.arapcommon.business.piaozone.kingdee.action.TokenAction;
import kd.fi.arapcommon.business.piaozone.kingdee.action.UserKeyAction;
import kd.fi.arapcommon.util.CollectionUtils;
import kd.fi.arapcommon.util.ErStdConfig;
import kd.fi.arapcommon.util.JsonUtils;
import kd.fi.arapcommon.util.StringUtils;

public class APIHelper {
    private static final Log logger = LogFactory.getLog(APIHelper.class);

    public static Map<?, ?> invokeAction(AbstractAction action) {
        action.setToken(APIHelper.getToken(action.getTaxRegNum()));
        String raw_response = action.execute();
        Map<?, ?> response = APIHelper.handleRawResponse(raw_response, action, false);
        return response;
    }

    public static String getToken(String taxRegNum) {
        Object errCode;
        TokenAction tokenAction = new TokenAction(taxRegNum);
        String raw_response = tokenAction.execute();
        Map response = JsonUtils.jsonToObj(raw_response, Map.class);
        if (!ObjectUtils.isEmpty((Object)response) && (errCode = response.get("errcode")) != null && "0000".equals(errCode)) {
            logger.info("\u3010\u8c03\u7528\u53d1\u7968\u4e91\u3011\u83b7\u53d6token\u6210\u529f");
            return response.get("access_token").toString();
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6token\u5931\u8d25\uff0c\u4f01\u4e1a\u7a0e\u53f7: %1$s\uff0c\u5931\u8d25\u539f\u56e0: %2$s\u3002", (String)"APIHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]), taxRegNum, response.get("description").toString()));
    }

    public static String getToken4Ap(String taxRegNum) {
        Object errCode;
        ApTokenAction tokenAction = new ApTokenAction(taxRegNum);
        String raw_response = tokenAction.execute();
        Map response = JsonUtils.jsonToObj(raw_response, Map.class);
        if (!ObjectUtils.isEmpty((Object)response) && (errCode = response.get("errcode")) != null && "0000".equals(errCode)) {
            logger.info("\u3010\u8c03\u7528\u53d1\u7968\u4e91\u3011\u83b7\u53d6token\u6210\u529f");
            return response.get("access_token").toString();
        }
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6token\u5931\u8d25\uff0c\u4f01\u4e1a\u7a0e\u53f7: %1$s\uff0c\u5931\u8d25\u539f\u56e0: %2$s\u3002", (String)"APIHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]), taxRegNum, response.get("description").toString()));
    }

    public static String getToken4Ap(Long orgId) {
        Object errCode;
        ApTokenAction tokenAction = new ApTokenAction(orgId);
        String raw_response = tokenAction.execute();
        Map response = JsonUtils.jsonToObj(raw_response, Map.class);
        if (!ObjectUtils.isEmpty((Object)response) && (errCode = response.get("errcode")) != null && "0000".equals(errCode)) {
            logger.info("\u3010\u8c03\u7528\u53d1\u7968\u4e91\u3011\u83b7\u53d6token\u6210\u529f");
            return response.get("access_token").toString();
        }
        throw new KDBizException(response.get("description").toString());
    }

    public static String getToken4ApImg(Long orgId) {
        Object errCode;
        ApTokenActionImg tokenAction = new ApTokenActionImg(orgId);
        String raw_response = tokenAction.execute();
        Map response = JsonUtils.jsonToObj(raw_response, Map.class);
        if (!ObjectUtils.isEmpty((Object)response) && (errCode = response.get("errcode")) != null && "0000".equals(errCode)) {
            logger.info("\u3010\u8c03\u7528\u53d1\u7968\u4e91\u3011\u83b7\u53d6token\u6210\u529f");
            Map data = (Map)response.get("data");
            return data.get("accessToken").toString();
        }
        throw new KDBizException(response.get("description").toString());
    }

    public static String getViewUrl(Object pk, boolean isAr) {
        Object errCode;
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", pk)};
        ArrayList<String> selectors = new ArrayList<String>();
        selectors.add("org");
        selectors.add("billno");
        selectors.add("biztype");
        selectors.add("serialno");
        selectors.add(isAr ? "sellertin" : "buyertin");
        selectors.add(isAr ? "sellername" : "buyername");
        String entityKey = isAr ? "ar_invoice" : "ap_invoice";
        DynamicObject invoice = BusinessDataServiceHelper.loadSingle((String)entityKey, (String)String.join((CharSequence)",", selectors), (QFilter[])filters);
        String serialNo = invoice.getString("serialno");
        if (StringUtils.isEmpty(serialNo)) {
            throw new KDBizException(String.format(ResManager.loadKDString((String)"\u6ca1\u6709\u5173\u8054\u6570\u636e\u3002", (String)"APIHelper_1", (String)"fi-arapcommon", (Object[])new Object[0]), new Object[0]));
        }
        String domain = KingdeeInvoiceCloudConfig.getDomain4AP();
        UserKeyAction userKeyAction = new UserKeyAction(invoice);
        String raw_response = userKeyAction.execute();
        Map response = JsonUtils.jsonToObj(raw_response, Map.class);
        if (!ObjectUtils.isEmpty((Object)response) && (errCode = response.get("errcode")) != null && "0000".equals(errCode)) {
            Map data = JsonUtils.jsonToObj(response.get("data").toString(), Map.class);
            String userKey = data.get("userKey").toString();
            String viewUrl = domain + "/m4-web/fpzs/expense/showInvoice?userKey=" + userKey + "&serialNo=" + serialNo;
            return viewUrl;
        }
        String taxRegNum = invoice.getString(isAr ? "sellertin" : "buyertin");
        ConfigCache.remove("er_bd_kdinvoicecloudcfg::taxregnum", taxRegNum);
        throw new KDBizException(String.format(ResManager.loadKDString((String)"\u83b7\u53d6userKey\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0: %s", (String)"APIHelper_2", (String)"fi-arapcommon", (Object[])new Object[0]), response.get("description").toString()));
    }

    private static Map<?, ?> handleRawResponse(String raw_response, AbstractAction action, boolean reInvoke) {
        logger.info("\u3010\u53d1\u7968\u4e91\u8fd4\u56de\u7ed3\u679c\u3011" + raw_response);
        String errMsg = ResManager.loadKDString((String)"\u539f\u56e0\u4e0d\u660e\u3002", (String)"APIHelper_3", (String)"fi-arapcommon", (Object[])new Object[0]);
        Map response = null;
        try {
            response = JsonUtils.jsonToObj(raw_response, Map.class);
            return response;
        }
        catch (Exception e) {
            errMsg = ResManager.loadKDString((String)"\u54cd\u5e94\u4fe1\u606f\u89e3\u6790\u51fa\u9519\u3002", (String)"APIHelper_4", (String)"fi-arapcommon", (Object[])new Object[0]);
            String logfmt = String.format(ResManager.loadKDString((String)"\u3010\u8c03\u7528\u53d1\u7968\u4e91\u3011\u5931\u8d25\uff0c\u9519\u8bef\u63cf\u8ff0\uff1a%1$s%2$s\u8c03\u7528\u4fe1\u606f\uff1a%3$s%4$s\u54cd\u5e94\u4fe1\u606f\uff1a%5$s\u3002", (String)"APIHelper_5", (String)"fi-arapcommon", (Object[])new Object[0]), new Object[0]);
            logger.info(String.format(logfmt, errMsg, System.lineSeparator(), action.desc(), System.lineSeparator(), raw_response));
            String msgfmt = ResManager.loadKDString((String)"\u8c03\u7528\u53d1\u7968\u4e91\u5931\u8d25\uff0c%s\u3002", (String)"APIHelper_8", (String)"fi-arapcommon", (Object[])new Object[0]);
            throw new KDBizException(String.format(msgfmt, errMsg));
        }
    }

    public static List<InvoiceVO> queryInvoiceDetailByXh(QueryInvoiceDetailInfo queryBO) {
        QueryInvoiceDetailParam param = new QueryInvoiceDetailParam();
        param.setOrgId(queryBO.getOrgId().toString());
        String taxRegnum = queryBO.getTaxNo();
        String companyName = queryBO.getCompanyName();
        List taxNoList = Arrays.stream(taxRegnum.split("=")).collect(Collectors.toList());
        List companyNameList = Arrays.stream(companyName.split("=")).collect(Collectors.toList());
        int companyInfoCount = taxNoList.size() < companyNameList.size() ? taxNoList.size() : companyNameList.size();
        ArrayList<CompanyInfo> companyInfos = new ArrayList<CompanyInfo>(companyInfoCount);
        for (int i = 0; i < companyInfoCount; ++i) {
            companyInfos.add(new CompanyInfo((String)taxNoList.get(i), (String)companyNameList.get(i)));
        }
        param.setCompanyInfo(companyInfos);
        param.setSerialNos(Arrays.asList(queryBO.getSerialNo().split(",")));
        logger.info("queryInvoiceDetailByXh\u67e5\u8be2\u53d1\u7968\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)param));
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"queryVerify", (Object[])new Object[]{JSON.toJSON((Object)param)});
        String respJson = JSON.toJSONString((Object)result);
        logger.info("queryInvoiceDetailByXh\u67e5\u8be2\u53d1\u7968\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\u7684\u8be6\u7ec6\u4fe1\u606f\uff1a{}", (Object)JSON.toJSONString((Object)param), (Object)respJson);
        InvoiceDetailRetrunVO invoiceDetailReturnVO = (InvoiceDetailRetrunVO)JSON.parseObject((String)respJson, InvoiceDetailRetrunVO.class);
        String errcode = invoiceDetailReturnVO.getErrcode();
        if ("0000".equals(errcode)) {
            logger.info("\u8c03\u7528\u53d1\u7968\u4e91\u67e5\u8be2\u8be6\u7ec6\u4fe1\u606f\u6210\u529f");
            logger.info("queryInvoiceDetailByXh\u67e5\u8be2\u53d1\u7968\u7684\u8fd4\u56de\u7ed3\u679c" + JSON.toJSONString(invoiceDetailReturnVO.getData()));
            return invoiceDetailReturnVO.getData();
        }
        logger.error("\u67e5\u8be2\u53d1\u7968\u8be6\u60c5\u8fd4\u56de\u6570\u636e\u5f02\u5e38:" + errcode);
        ErrorCode ec = new ErrorCode("query_other_exception", invoiceDetailReturnVO.getDescription());
        throw new PZAuthException(ec);
    }

    public static List<InvoiceVO> queryInvoiceDetailByPc(QueryInvoiceDetailInfo queryBO) {
        String serialNos = queryBO.getSerialNo();
        logger.info("\u67e5\u8be2\u53d1\u7968\u8be6\u7ec6, \u4f20\u9012\u8fdb\u6765\u7684\u5e8f\u5217\u53f7", (Object)serialNos);
        if (serialNos == null || serialNos.isEmpty()) {
            logger.info("\u67e5\u8be2\u53d1\u7968\u8be6\u7ec6, \u4f20\u9012\u8fdb\u6765\u7684\u5e8f\u5217\u53f7\u4e3a\u7a7a");
            return Collections.emptyList();
        }
        String taxRegNum = queryBO.getTaxNo();
        QueryBySerialNoAction queryAction = new QueryBySerialNoAction(serialNos);
        queryAction.setTaxNo(queryBO.getTaxNo());
        queryAction.setCompanyName(queryBO.getCompanyName());
        queryAction.setBxdKey(queryBO.getBxdKey());
        Long orgId = queryBO.getOrgId();
        String token = "";
        logger.info("\u53d1\u7968\u5e8f\u5217\u53f7\u67e5\u8be2\uff0c\u83b7\u53d6token");
        if (orgId != null && KingdeeInvoiceCloudConfig.isGroupPattern()) {
            token = APIHelper.getToken4Ap(orgId);
            queryAction.setOrgId(orgId);
            logger.info("InvoiceConfigPattern:\u96c6\u56e2\u6a21\u5f0f\uff0c" + orgId);
        } else {
            token = APIHelper.getToken4Ap(taxRegNum);
            logger.info("InvoiceConfigPattern:\u7ec4\u7ec7\u6a21\u5f0f");
        }
        for (int i = 0; i < 5; ++i) {
            queryAction.setToken(token);
            String apiReturnJson = queryAction.execute();
            InvoiceDetailRetrunVO invoiceDetailReturnVO = JsonParseUtils.parseInvoiceDetailReturnVO(apiReturnJson);
            String errcode = invoiceDetailReturnVO.getErrcode();
            if ("0000".equals(errcode)) {
                logger.info("APIHelper----\u8c03\u7528\u53d1\u7968\u4e91\u67e5\u8be2\u8be6\u7ec6\u4fe1\u606f\u6210\u529f" + JSON.toJSONString(invoiceDetailReturnVO.getData()));
                return invoiceDetailReturnVO.getData();
            }
            if (!"1300".equals(errcode)) {
                logger.error("\u67e5\u8be2\u53d1\u7968\u8be6\u60c5\u8fd4\u56de\u6570\u636e\u5f02\u5e38:" + apiReturnJson);
                ErrorCode ec = new ErrorCode("query_other_exception", invoiceDetailReturnVO.getDescription());
                throw new PZAuthException(ec);
            }
            logger.info("token\u8fc7\u671f, \u91cd\u65b0\u83b7\u53d6tocken\u53d1\u9001\u8bf7\u6c42");
        }
        ErrorCode ec = new ErrorCode("token_is_expired", ResManager.loadKDString((String)"Token\u4e00\u76f4\u8fc7\u671f\uff0c \u67e5\u8be2\u53d1\u7968\u8be6\u60c5\u5931\u8d25\u3002", (String)"APIHelper_9", (String)"fi-arapcommon", (Object[])new Object[0]));
        throw new KDBizException(ec, new Object[0]);
    }

    public static List<InvoiceVO> queryInvoiceDetailBySerialNo(QueryInvoiceDetailInfo queryBO) {
        return "true".equals(ErStdConfig.get("invoicecloud.invoicecloudxh")) ? APIHelper.queryInvoiceDetailByXh(queryBO) : APIHelper.queryInvoiceDetailByPc(queryBO);
    }

    public static void invDownloadPc(Map<String, Object> param, List<InvoiceVO> invoiceVOs) {
        for (int i = 0; i < 5; ++i) {
            InvDownloadAction downloadAction = new InvDownloadAction((Integer)param.get("pageNo"), (Integer)param.get("pageSize"), (Date)param.get("startTime"), (Date)param.get("endTime"), (String)param.get("invoiceTypes"), "", (String)param.get("salerTaxNo"), (String)param.get("buyerTaxNo"), (String)param.get("invoiceStatus"));
            String token = APIHelper.getToken4Ap((String)param.get("buyerTaxNo"));
            logger.info("---invDownload.token---:" + token);
            downloadAction.setToken(token);
            String apiReturnJson = downloadAction.execute();
            InvoiceDetailRetrunVO invoiceDetailReturnVO = JsonParseUtils.parseInvoiceDetailReturnVO(apiReturnJson);
            String errcode = invoiceDetailReturnVO.getErrcode();
            if ("0000".equals(errcode)) {
                logger.info("\u8c03\u7528\u53d1\u7968\u4e91\u67e5\u8be2\u8be6\u7ec6\u4fe1\u606f\u6210\u529f");
                List<InvoiceVO> data = invoiceDetailReturnVO.getData();
                if (data != null) {
                    data = data.stream().filter(invoiceVo -> "1".equals(invoiceVo.getExpendStatus())).filter(CollectionUtils.distinctByKey(InvoiceVO::getSerialNo)).collect(Collectors.toList());
                }
                if (data != null && !data.isEmpty()) {
                    Set serialNoSet = invoiceVOs.stream().map(InvoiceVO::getSerialNo).collect(Collectors.toSet());
                    data = data.stream().filter(invoiceVO -> !serialNoSet.contains(invoiceVO.getSerialNo())).collect(Collectors.toList());
                    invoiceVOs.addAll(data);
                }
                JSONObject returnJson = JSON.parseObject((String)apiReturnJson);
                Integer totalPage = returnJson.getInteger("totalPage");
                Integer currentPage = returnJson.getInteger("currentPage");
                logger.info("invDownload.returnJson:totalPage = " + totalPage + ",currentPage = " + currentPage);
                if (currentPage < totalPage) {
                    param.put("pageNo", currentPage + 1);
                    APIHelper.invDownload(param, invoiceVOs);
                    continue;
                }
                return;
            }
            if ("1300".equals(errcode)) {
                logger.info("token\u8fc7\u671f, \u91cd\u65b0\u83b7\u53d6tocken\u53d1\u9001\u8bf7\u6c42");
                continue;
            }
            logger.error("\u67e5\u8be2\u53d1\u7968\u8be6\u60c5\u8fd4\u56de\u6570\u636e\u5f02\u5e38:" + apiReturnJson);
            ErrorCode ec = new ErrorCode("query_other_exception", invoiceDetailReturnVO.getDescription());
            throw new PZAuthException(ec);
        }
        if (invoiceVOs.isEmpty()) {
            ErrorCode ec = new ErrorCode("token_is_expired", ResManager.loadKDString((String)"Token\u4e00\u76f4\u8fc7\u671f\uff0c \u67e5\u8be2\u53d1\u7968\u8be6\u60c5\u5931\u8d25\u3002", (String)"APIHelper_9", (String)"fi-arapcommon", (Object[])new Object[0]));
            throw new KDBizException(ec, new Object[0]);
        }
    }

    public static void invDownload(Map<String, Object> param, List<InvoiceVO> invoiceVOs) {
        if ("true".equals(ErStdConfig.get("invoicecloud.invoicecloudxh"))) {
            APIHelper.invDownloadByNoXh(param, invoiceVOs);
        } else {
            APIHelper.invDownloadPc(param, invoiceVOs);
        }
    }

    public static void invDownloadByNoPc(Map<String, Object> param, List<InvoiceVO> invoiceVOs) {
        for (int i = 0; i < 5; ++i) {
            InvDownloadByNoAction downloadAction = new InvDownloadByNoAction((String)param.get("invoicecode"), (String)param.get("invoiceno"), (String)param.get("buyerTaxNo"));
            String token = APIHelper.getToken4Ap((String)param.get("buyerTaxNo"));
            logger.info("---invDownload.token---:" + token);
            downloadAction.setToken(token);
            String apiReturnJson = downloadAction.execute();
            InvoiceDetailRetrunVO invoiceDetailReturnVO = JsonParseUtils.parseInvoiceDetailReturnVO(apiReturnJson);
            String errcode = invoiceDetailReturnVO.getErrcode();
            if ("0000".equals(errcode)) {
                logger.info("\u8c03\u7528\u53d1\u7968\u4e91\u67e5\u8be2\u8be6\u7ec6\u4fe1\u606f\u6210\u529f");
                List<InvoiceVO> data = invoiceDetailReturnVO.getData();
                if (!ObjectUtils.isEmpty(data)) {
                    data = data.stream().filter(invoiceVo -> "1".equals(invoiceVo.getExpendStatus())).collect(Collectors.toList());
                    invoiceVOs.addAll(data);
                }
                return;
            }
            if (!"1300".equals(errcode)) {
                if ("0601".equals(errcode)) {
                    ErrorCode ec = new ErrorCode("0601", ResManager.loadKDString((String)"\u6682\u4e0d\u652f\u6301\u5168\u7535\u53d1\u7968\uff0c\u8bf7\u8f93\u5165\u53d1\u7968\u53f7\u7801\u548c\u4ee3\u7801\u8fdb\u884c\u4e0b\u8f7d\u3002", (String)"APIHelper_10", (String)"fi-arapcommon", (Object[])new Object[0]));
                    throw new PZAuthException(ec);
                }
                logger.error("\u67e5\u8be2\u53d1\u7968\u8be6\u60c5\u8fd4\u56de\u6570\u636e\u5f02\u5e38:" + apiReturnJson);
                ErrorCode ec = new ErrorCode("query_other_exception", invoiceDetailReturnVO.getDescription());
                throw new PZAuthException(ec);
            }
            logger.info("token\u8fc7\u671f, \u91cd\u65b0\u83b7\u53d6tocken\u53d1\u9001\u8bf7\u6c42");
        }
        if (invoiceVOs.isEmpty()) {
            ErrorCode ec = new ErrorCode("token_is_expired", ResManager.loadKDString((String)"Token\u4e00\u76f4\u8fc7\u671f\uff0c \u67e5\u8be2\u53d1\u7968\u8be6\u60c5\u5931\u8d25\u3002", (String)"APIHelper_9", (String)"fi-arapcommon", (Object[])new Object[0]));
            throw new KDBizException(ec, new Object[0]);
        }
    }

    public static void invDownloadByNoXh(Map<String, Object> param, List<InvoiceVO> invoiceVOs) {
        param.put("invoiceCode", param.remove("invoicecode"));
        param.put("invoiceNo", param.remove("invoiceno"));
        param.put("expenseStatus", "1");
        logger.info("invDownloadByNoXh\u67e5\u8be2\u53d1\u7968\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", param);
        Map result = (Map)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"InputService", (String)"queryInvoice", (Object[])new Object[]{JSON.toJSON(param)});
        String respJson = JSON.toJSONString((Object)result);
        logger.info("invDownloadByNoXh\u67e5\u8be2\u53d1\u7968\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}\uff0c\u8fd4\u56de\u7684\u8be6\u7ec6\u4fe1\u606f\uff1a{}", param, (Object)respJson);
        InvoiceDetailRetrunVO invoiceDetailReturnVO = (InvoiceDetailRetrunVO)JSON.parseObject((String)respJson, InvoiceDetailRetrunVO.class);
        String errcode = invoiceDetailReturnVO.getErrcode();
        if ("0000".equals(errcode)) {
            if (invoiceDetailReturnVO.getData() != null) {
                logger.info("\u8c03\u7528\u53d1\u7968\u4e91\u67e5\u8be2\u4fe1\u606f\u6210\u529f");
                logger.info("invDownloadByNoXh\u67e5\u8be2\u53d1\u7968\u7684\u8fd4\u56de\u7ed3\u679c" + JSON.toJSONString(invoiceDetailReturnVO.getData()));
                invoiceVOs.addAll(invoiceDetailReturnVO.getData());
            } else {
                logger.error("\u67e5\u8be2\u53d1\u7968\u8be6\u60c5\u8fd4\u56de\u6570\u636e\u4e3a\u7a7a:");
            }
        } else {
            logger.error("\u67e5\u8be2\u53d1\u7968\u8be6\u60c5\u8fd4\u56de\u6570\u636e\u5f02\u5e38:" + errcode);
            ErrorCode ec = new ErrorCode("queryInvoice_exception", invoiceDetailReturnVO.getDescription());
            throw new PZAuthException(ec);
        }
    }

    public static void invDownloadByNo(Map<String, Object> param, List<InvoiceVO> invoiceVOs) {
        if ("true".equals(ErStdConfig.get("invoicecloud.invoicecloudxh"))) {
            APIHelper.invDownloadByNoXh(param, invoiceVOs);
        } else {
            APIHelper.invDownloadByNoPc(param, invoiceVOs);
        }
    }

    @Deprecated
    public static List<InvoiceAttachmentVo> getTempInoviceAttachments(DynamicObject dataEntity, long orgId) {
        List<InvoiceAttachmentVo> attachments = new ArrayList<InvoiceAttachmentVo>(2);
        String token = APIHelper.getToken4Ap(orgId);
        InvoiceFilesAction filesAction = new InvoiceFilesAction(dataEntity, token);
        String returnData = filesAction.execute();
        JSONObject resultJson = JSON.parseObject((String)returnData);
        if (resultJson != null && "0000".equals(resultJson.getString("errcode"))) {
            JSONArray attachmentJSonArray = resultJson.getJSONArray("data");
            if (attachmentJSonArray == null) {
                return attachments;
            }
            attachments = JSON.parseArray((String)attachmentJSonArray.toJSONString(), InvoiceAttachmentVo.class);
        }
        return attachments;
    }

    @Deprecated
    public static List<InvoiceVO> queryInvoiceXbrlBySerialNo(QueryInvoiceDetailInfo queryBO) {
        String serialNos = queryBO.getSerialNo();
        Long orgId = queryBO.getOrgId();
        logger.info("queryInvoiceXbrlBySerialNo-serialNos", (Object)serialNos);
        if (serialNos == null || serialNos.isEmpty()) {
            return Collections.emptyList();
        }
        QueryXbrlBySerialNoAction action = new QueryXbrlBySerialNoAction(orgId, serialNos);
        String token = APIHelper.getToken4Ap(orgId);
        for (int i = 0; i < 5; ++i) {
            action.setToken(token);
            String apiReturnJson = action.execute();
            InvoiceDetailRetrunVO invoiceDetailReturnVO = JsonParseUtils.parseInvoiceDetailReturnVO(apiReturnJson);
            String errcode = invoiceDetailReturnVO.getErrcode();
            if ("0000".equals(errcode)) {
                logger.info("APIHelper----queryInvoiceXbrlBySerialNo" + JSON.toJSONString(invoiceDetailReturnVO.getData()));
                return invoiceDetailReturnVO.getData();
            }
            if (!"1300".equals(errcode)) {
                logger.error("\u67e5\u8be2\u53d1\u7968\u8be6\u60c5\u8fd4\u56de\u6570\u636e\u5f02\u5e38:" + apiReturnJson);
                ErrorCode ec = new ErrorCode("query_other_exception", invoiceDetailReturnVO.getDescription());
                throw new PZAuthException(ec);
            }
            logger.info("token\u8fc7\u671f, \u91cd\u65b0\u83b7\u53d6tocken\u53d1\u9001\u8bf7\u6c42");
        }
        ErrorCode ec = new ErrorCode("token_is_expired", ResManager.loadKDString((String)"Token\u4e00\u76f4\u8fc7\u671f\uff0c \u67e5\u8be2\u53d1\u7968\u8be6\u60c5\u5931\u8d25\u3002", (String)"APIHelper_9", (String)"fi-arapcommon", (Object[])new Object[0]));
        throw new KDBizException(ec, new Object[0]);
    }
}

