/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.business.piaozone.kingdee.action;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.business.piaozone.kingdee.action.AbstractAction;
import kd.fi.arapcommon.helper.InvoiceCloudLocalHelper;
import kd.fi.arapcommon.util.AES128;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StringUtils;

public class InvDownloadByNoAction
extends AbstractAction {
    private String invoiceCode;
    private String invoiceNo;
    private String buyerTaxNo;

    public InvDownloadByNoAction(String invoiceCode, String invoiceNo, String buyerTaxNo) {
        this.invoiceCode = invoiceCode;
        this.invoiceNo = invoiceNo;
        this.buyerTaxNo = buyerTaxNo;
    }

    @Override
    public String execute() {
        String invoiceJson = InvoiceCloudLocalHelper.invoiceDebugJson();
        if (EmptyUtils.isNotEmpty(invoiceJson)) {
            return invoiceJson;
        }
        String domain = KingdeeInvoiceCloudConfig.getDomain4AP();
        DynamicObject clientConfig = KingdeeInvoiceCloudConfig.getClientConfig(this.buyerTaxNo);
        String encrypt_key = clientConfig.getString("encrypt_key");
        String url = domain + "/m6/bill/invoice/code/no/query?encry_type=GCM&access_token=" + this.token;
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("invoiceCode", this.invoiceCode);
        param.put("invoiceNo", this.invoiceNo);
        String jsonEncrypt = null;
        logger.info("---json.param---" + JSON.toJSONString(param));
        try {
            jsonEncrypt = AES128.encrypt4Download(JSON.toJSONString(param), encrypt_key);
            if (StringUtils.isEmpty(jsonEncrypt)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u914d\u7f6e\u4e2d\u201cencrypt_Key\u201d\u7684\u5b57\u7b26\u957f\u5ea6\u4e0d\u662f16\u4f4d\u3002", (String)"InvDownloadByNoAction_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            logger.error("---AES128.encrypt is error:" + e);
            throw new KDBizException(e.getMessage());
        }
        String raw_response = "";
        try {
            raw_response = this.doPost(url, jsonEncrypt);
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u4e0b\u8f7d\u63a5\u53e3\u4ea4\u4e92\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"InvDownloadByNoAction_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        return raw_response;
    }

    @Override
    public String desc() {
        return ResManager.loadKDString((String)"\u4e0b\u8f7d\u53d1\u7968", (String)"InvDownloadByNoAction_2", (String)"fi-arapcommon", (Object[])new Object[0]);
    }
}

