/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.business.piaozone.kingdee.action;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.Set;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.KDBizException;
import kd.bos.orm.ORM;
import kd.fi.arapcommon.business.piaozone.kingdee.APIHelper;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.business.piaozone.kingdee.action.AbstractAction;
import kd.fi.arapcommon.util.StringUtils;

public class InvoiceFilesAction
extends AbstractAction {
    private final DynamicObject dataEntity;
    private Set<String> serialNos;

    public InvoiceFilesAction(DynamicObject dataEntity, Set<String> serialNos) {
        this.dataEntity = dataEntity;
        this.serialNos = serialNos;
        this.token = APIHelper.getToken4Ap(dataEntity.getLong("org.id"));
    }

    @Deprecated
    public InvoiceFilesAction(DynamicObject dataEntity, String token) {
        this.dataEntity = dataEntity;
        this.token = token;
    }

    @Override
    public String execute() {
        String expenseId = this.getBillExpenseId(this.dataEntity);
        if (StringUtils.isEmpty(expenseId)) {
            logger.info("APIHelper.getTempInoviceFiles.expenseId \u83b7\u53d6\u5931\u8d25");
            return null;
        }
        long applierId = this.dataEntity.getLong("creator.id");
        String url = KingdeeInvoiceCloudConfig.getInvoiceAttachmentAPIURL();
        if (StringUtils.isEmpty(url)) {
            logger.info("APIHelper.getTempInoviceFiles.er_stdconfig \u672a\u914d\u7f6e\u53d1\u7968\u4e91\u9644\u4ef6api\u5730\u5740");
            return null;
        }
        url = url + "?access_token=" + this.token;
        JSONObject body = new JSONObject();
        body.put("expenseId", (Object)expenseId);
        body.put("eid", (Object)applierId);
        try {
            String result = this.doPost(url, body.toJSONString());
            logger.info("APIHelper.getTempInoviceFiles." + result);
            JSONObject resultJson = JSON.parseObject((String)result);
            String errorCode = resultJson.getString("errcode");
            if ("0000".equals(errorCode)) {
                return result;
            }
            logger.info("APIHelper.getTempInoviceFiles.\u8fd4\u56de\u7ed3\u679c\u5f02\u5e38:" + result);
            return null;
        }
        catch (Exception e) {
            logger.info("APIHelper.getTempInoviceFiles: " + e);
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u66f4\u65b0\u63a5\u53e3\u4ea4\u4e92\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"InvoiceFilesAction_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    @Override
    public String desc() {
        return "InvoiceFiles Action";
    }

    private String getBillExpenseId(DynamicObject dataEntity) {
        String entityName = dataEntity.getDynamicObjectType().getName();
        if ("ap_finapbill".equals(entityName)) {
            DynamicObjectCollection invEntries = dataEntity.getDynamicObjectCollection("inventry");
            for (DynamicObject invEntry : invEntries) {
                String iSerialNo = invEntry.getString("i_serialno");
                long invPk = invEntry.getLong("invid");
                if (ObjectUtils.isEmpty((Object)iSerialNo) || !this.serialNos.contains(iSerialNo) || invPk == 0L) continue;
                return "ap_invoice_" + invPk;
            }
        } else {
            long id = dataEntity.getLong("id");
            return "ap_invoice_" + id;
        }
        String uid = UUID.randomUUID().toString().replace("-", "");
        return entityName + "_" + uid;
    }

    @Deprecated
    public static String getBillNoCachedInCloud(DynamicObject dataEntity) {
        String entityName = dataEntity.getDynamicObjectType().getName();
        if (dataEntity.getDataEntityType().getProperties().get((Object)"id") != null) {
            Long id = dataEntity.getLong("id");
            if (id == 0L) {
                id = ORM.create().genLongId(dataEntity.getDataEntityType());
                dataEntity.set("id", (Object)id);
            }
            return entityName + "_" + id;
        }
        String uid = UUID.randomUUID().toString().replace("-", "");
        logger.info("entityName: " + entityName + ", \u4e0d\u5b58\u5728id\u5c5e\u6027, \u4ee5uuid\u4ee3\u66ff: " + uid);
        return entityName + "_" + uid;
    }
}

