/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.business.piaozone.kingdee.action;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.business.piaozone.kingdee.action.AbstractAction;
import kd.fi.arapcommon.helper.InvoiceCloudLocalHelper;
import kd.fi.arapcommon.util.EmptyUtils;
import org.apache.commons.lang3.StringUtils;

public class QueryBySerialNoAction
extends AbstractAction {
    private static final Log log = LogFactory.getLog(QueryBySerialNoAction.class);
    private String serialNo;
    private String taxNo;
    private String companyName;
    private String bxdKey;
    private Long orgId;

    public QueryBySerialNoAction(String serialNo) {
        this.serialNo = serialNo;
    }

    @Override
    public String execute() {
        String invoiceJson = InvoiceCloudLocalHelper.invoiceDebugJson();
        if (EmptyUtils.isNotEmpty(invoiceJson)) {
            return invoiceJson;
        }
        String domain = KingdeeInvoiceCloudConfig.getDomain4AP();
        String url = domain + "/m4/bill/fpzs/invoice/verificate/query?access_token=" + this.token;
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("serialNo", this.serialNo);
        if (StringUtils.isNotBlank((CharSequence)this.taxNo)) {
            param.put("taxNo", this.taxNo);
        }
        if (StringUtils.isNotBlank((CharSequence)this.companyName)) {
            param.put("companyName", this.companyName);
        }
        param.put("bxd_key", this.bxdKey);
        param.put("ticketParam", this.orgId != null ? KingdeeInvoiceCloudConfig.getTicketParam(this.orgId) : KingdeeInvoiceCloudConfig.getTicketParam(this.taxNo));
        log.info("QueryBySerialNoAction----\u53d1\u7968\u4e91\u8bf7\u6c42\u53c2\u6570\u6253\u5370:" + JSON.toJSONString(param));
        String raw_response = "";
        try {
            raw_response = this.doPost(url, JSON.toJSONString(param));
        }
        catch (Exception e) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u67e5\u8be2\u63a5\u53e3\u4ea4\u4e92\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5\u76f8\u5173\u914d\u7f6e\u3002", (String)"QueryBySerialNoAction_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        log.info("QueryBySerialNoAction----\u53d1\u7968\u4e91\u8fd4\u56de\u7684\u539f\u59cb\u6570\u636e:" + raw_response);
        return raw_response;
    }

    @Override
    public String desc() {
        String fmt = ResManager.loadKDString((String)"\u6839\u636e\u53d1\u7968\u5e8f\u5217\u53f7\u67e5\u8be2\u53d1\u7968\u8be6\u7ec6\u4fe1\u606f\uff1a{serialNo:%s}", (String)"QueryBySerialNoAction_1", (String)"fi-arapcommon", (Object[])new Object[0]);
        return String.format(fmt, this.serialNo);
    }

    public String getSerialNo() {
        return this.serialNo;
    }

    public void setSerialNo(String serialNo) {
        this.serialNo = serialNo;
    }

    public String getTaxNo() {
        return this.taxNo;
    }

    public void setTaxNo(String taxNo) {
        this.taxNo = taxNo;
    }

    public String getCompanyName() {
        return this.companyName;
    }

    public void setCompanyName(String companyName) {
        this.companyName = companyName;
    }

    public String getBxdKey() {
        return this.bxdKey;
    }

    public void setBxdKey(String bxdKey) {
        this.bxdKey = bxdKey;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
}

