/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.business.piaozone.kingdee.action;

import com.alibaba.fastjson.JSON;
import java.util.HashMap;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.fi.arapcommon.business.piaozone.info.InvoiceCloudCfg;
import kd.fi.arapcommon.business.piaozone.kingdee.KingdeeInvoiceCloudConfig;
import kd.fi.arapcommon.business.piaozone.kingdee.action.AbstractAction;
import kd.fi.arapcommon.util.AES128;
import kd.fi.arapcommon.util.StringUtils;

public class QueryXbrlBySerialNoAction
extends AbstractAction {
    private static final Log log = LogFactory.getLog(QueryXbrlBySerialNoAction.class);
    private String serialNo;
    private Long orgId;

    public QueryXbrlBySerialNoAction(Long orgId, String serialNo) {
        this.orgId = orgId;
        this.serialNo = serialNo;
    }

    @Override
    public String execute() {
        String domain = KingdeeInvoiceCloudConfig.getDomain4AP();
        String url = domain + "/m6/bill/invoice/serialnos/query?access_token=" + this.token;
        HashMap<String, String> param = new HashMap<String, String>(2);
        param.put("serialNos", this.serialNo);
        String paramStr = JSON.toJSONString(param);
        log.info("QueryXbrlBySerialNoAction----\u53d1\u7968\u4e91\u8bf7\u6c42\u53c2\u6570\u6253\u5370:" + paramStr);
        InvoiceCloudCfg config = KingdeeInvoiceCloudConfig.getConfig(this.orgId);
        log.info("InvoiceCloudCfg----:" + config);
        String jsonEncrypt = null;
        try {
            jsonEncrypt = AES128.encrypt4Download(paramStr, config.getEncryptKey());
            if (StringUtils.isEmpty(jsonEncrypt)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u4e91\u914d\u7f6e\u4e2d\u7684encrypt_Key\u957f\u5ea6\u4e0d\u662f16\u4f4d", (String)"QueryXbrlBySerialNoAction_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        }
        catch (Exception e) {
            logger.error("---AES128.encrypt is error:" + e);
            throw new KDBizException(e.getMessage());
        }
        String raw_response = this.doPost(url, jsonEncrypt);
        log.info("QueryXbrlBySerialNoAction----\u53d1\u7968\u4e91\u8fd4\u56de\u7684\u539f\u59cb\u6570\u636e:" + raw_response);
        return raw_response;
    }

    @Override
    public String desc() {
        String fmt = ResManager.loadKDString((String)"\u6839\u636e\u53d1\u7968\u5e8f\u5217\u53f7\u67e5\u8be2\u53d1\u7968\u8be6\u7ec6\u4fe1\u606f\uff1a{serialNo:%s}", (String)"QueryXbrlBySerialNoAction_1", (String)"fi-arapcommon", (Object[])new Object[0]);
        return String.format(fmt, this.serialNo);
    }

    public String getSerialNo() {
        return this.serialNo;
    }

    public void setSerialNo(String serialNo) {
        this.serialNo = serialNo;
    }

    public Long getOrgId() {
        return this.orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
}

