/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.business.piaozone.kingdee.action;

import com.alibaba.fastjson.JSON;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.fi.arapcommon.business.piaozone.info.CompanyInfo;
import kd.fi.arapcommon.business.piaozone.info.InvoiceCloudCfg;
import kd.fi.arapcommon.business.piaozone.info.InvoiceData;
import kd.fi.arapcommon.business.piaozone.info.XHUpdateInvoiceStatusParam;
import kd.fi.arapcommon.business.piaozone.kingdee.action.AbstractAction;
import kd.fi.arapcommon.business.piaozone.kingdee.action.UpdateAction;

public class UpdateActionXh
extends AbstractAction {
    private static Log logger = LogFactory.getLog(UpdateAction.class);
    private Object pk;
    private String billNo;
    private DynamicObject dataEntity;
    private String userID = String.valueOf(RequestContext.get().getCurrUserId());
    private InvoiceCloudCfg config;

    public UpdateActionXh(InvoiceCloudCfg config, Object pk, String billNo, DynamicObject dataEntity) {
        this.pk = pk;
        this.billNo = billNo;
        this.config = config;
        this.dataEntity = dataEntity;
    }

    @Override
    public String execute() {
        XHUpdateInvoiceStatusParam xhUpdateInvoiceStatusParam = new XHUpdateInvoiceStatusParam();
        xhUpdateInvoiceStatusParam.setAppId("ap");
        xhUpdateInvoiceStatusParam.setBillId(this.pk.toString());
        xhUpdateInvoiceStatusParam.setBillNo(this.billNo);
        xhUpdateInvoiceStatusParam.setBillType("ap_invoice");
        xhUpdateInvoiceStatusParam.setBillUser(this.userID);
        String taxRegnum = this.config.getTaxRegnum();
        String companyName = this.config.getFirmname();
        List taxNoList = Arrays.stream(taxRegnum.split("=")).collect(Collectors.toList());
        List companyNameList = Arrays.stream(companyName.split("=")).collect(Collectors.toList());
        int companyInfoCount = Math.min(taxNoList.size(), companyNameList.size());
        ArrayList<CompanyInfo> companyInfos = new ArrayList<CompanyInfo>(companyInfoCount);
        for (int i = 0; i < companyInfoCount; ++i) {
            companyInfos.add(new CompanyInfo((String)taxNoList.get(i), (String)companyNameList.get(i)));
        }
        xhUpdateInvoiceStatusParam.setCompanyInfo(companyInfos);
        xhUpdateInvoiceStatusParam.setEntityId("ap_invoice");
        String serialno = this.dataEntity.getString("serialno");
        ArrayList<InvoiceData> invoiceDatas = new ArrayList<InvoiceData>();
        InvoiceData invo = new InvoiceData();
        invo.setSerialNo(serialno);
        invo.setDeductionFlag(this.dataEntity.getBoolean("istaxdeduction") ? "1" : "0");
        invoiceDatas.add(invo);
        String orgId = this.dataEntity.getString("org.id");
        xhUpdateInvoiceStatusParam.setInvoiceData(invoiceDatas);
        xhUpdateInvoiceStatusParam.setOrgId(orgId);
        xhUpdateInvoiceStatusParam.setResource("4");
        xhUpdateInvoiceStatusParam.setStatus("30");
        xhUpdateInvoiceStatusParam.setVerifyFlag("0");
        xhUpdateInvoiceStatusParam.setViewPage("ap_invoice");
        Map mapParam = (Map)JSON.toJSON((Object)xhUpdateInvoiceStatusParam);
        logger.info("\u66f4\u65b0\u53d1\u7968\u4e91\u72b6\u6001\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}", (Object)JSON.toJSONString((Object)xhUpdateInvoiceStatusParam));
        Map response = (Map)DispatchServiceHelper.invokeBizService((String)"imc", (String)"rim", (String)"FpzsService", (String)"save", (Object[])new Object[]{mapParam});
        logger.info("\u66f4\u65b0\u53d1\u7968\u4e91\u72b6\u6001\uff0c\u8bf7\u6c42\u53c2\u6570\uff1a{}, \u8fd4\u56de\u7ed3\u679c\uff1a{}", (Object)JSON.toJSONString((Object)xhUpdateInvoiceStatusParam), (Object)JSON.toJSONString((Object)response));
        Object errCode = response.get("errcode");
        if ("0000".equals(errCode)) {
            logger.info("update is success!");
        } else {
            Object desc = response.get("description");
            logger.info("update is error! " + desc + "(" + errCode + ")");
        }
        return JSON.toJSONString((Object)response);
    }

    @Override
    public String desc() {
        return "Update ActionXh";
    }
}

