/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.check;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.check.base.AbstractDataCheck;
import kd.fi.arapcommon.check.base.DataCheckResult;
import kd.fi.arapcommon.util.DataCheckUtils;
import kd.fi.arapcommon.util.EmptyUtils;

public class ArApSettleBillExistsDataCheck
extends AbstractDataCheck {
    @Override
    public String getEntityName() {
        return null;
    }

    @Override
    public List<String> listSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("billno");
        selector.add("hadwrittenoff");
        selector.add("mainbillid");
        selector.add("billentity");
        selector.add("entry.id");
        selector.add("entry.seq");
        selector.add("entry.billid");
        selector.add("entry.e_billentity");
        return selector;
    }

    @Override
    public QFilter getExtendQFilter() {
        return null;
    }

    @Override
    public boolean isBatch() {
        return true;
    }

    @Override
    public void setQFilter(QFilter filter) {
        if (EmptyUtils.isEmpty(filter)) {
            return;
        }
        this.defaultFilter = DataCheckUtils.generateNewSettleQFilter(filter);
    }

    @Override
    public DataCheckResult dataCheck(DynamicObject bill) {
        return null;
    }

    @Override
    public List<DataCheckResult> dataCheck(List<DynamicObject> billList) {
        Map<String, Set<Long>> billNameToIdsMap = this.getBillNameToIdsMap(billList);
        Set<Long> existBillIds = this.listExistBillIds(billNameToIdsMap);
        ArrayList<DataCheckResult> results = new ArrayList<DataCheckResult>(16);
        for (DynamicObject bill : billList) {
            boolean writeOff = bill.getBoolean("hadwrittenoff");
            if (writeOff) {
                results.add(new DataCheckResult(ResManager.loadKDString((String)"\u7ed3\u7b97\u8bb0\u5f55\u5df2\u88ab\u7ea2\u51b2\u3002", (String)"ArApSettleBillExistsDataCheck_0", (String)"fi-arapcommon", (Object[])new Object[0])));
                continue;
            }
            long mainBillId = bill.getLong("mainbillid");
            if (!existBillIds.contains(mainBillId)) {
                results.add(new DataCheckResult(ResManager.loadKDString((String)"\u7ed3\u7b97\u8bb0\u5f55\u4e3b\u65b9\u5355\u636e\u672a\u627e\u5230\u3002", (String)"ArApSettleBillExistsDataCheck_1", (String)"fi-arapcommon", (Object[])new Object[0])));
                continue;
            }
            int errorSeq = this.getErrorSeq(bill.getDynamicObjectCollection("entry"), existBillIds);
            if (errorSeq == 0) {
                results.add(new DataCheckResult());
                continue;
            }
            results.add(new DataCheckResult(String.format(ResManager.loadKDString((String)"\u8f85\u65b9\u5355\u636e\u7b2c%s\u884c\u5355\u636e\u672a\u627e\u5230\u3002", (String)"ArApSettleBillExistsDataCheck_2", (String)"fi-arapcommon", (Object[])new Object[0]), errorSeq)));
        }
        return results;
    }

    private int getErrorSeq(DynamicObjectCollection rowCollection, Set<Long> existBillIds) {
        for (DynamicObject row : rowCollection) {
            long rowBillId = row.getLong("billid");
            if (existBillIds.contains(rowBillId)) continue;
            return row.getInt("seq");
        }
        return 0;
    }

    private Set<Long> listExistBillIds(Map<String, Set<Long>> billNameToIdsMap) {
        ArrayList billCollection = new ArrayList(16);
        for (Map.Entry<String, Set<Long>> entry : billNameToIdsMap.entrySet()) {
            DynamicObjectCollection billList = QueryServiceHelper.query((String)entry.getKey(), (String)"id", (QFilter[])new QFilter[]{new QFilter("id", "in", entry.getValue())});
            billCollection.addAll(billList);
        }
        return billCollection.stream().map(entity -> entity.getLong("id")).collect(Collectors.toSet());
    }

    private Map<String, Set<Long>> getBillNameToIdsMap(List<DynamicObject> billList) {
        HashMap<String, Set<Long>> result = new HashMap<String, Set<Long>>(16);
        for (DynamicObject bill : billList) {
            Set ids = result.getOrDefault(bill.getString("billentity"), new HashSet(16));
            ids.add(bill.getLong("mainbillid"));
            result.put(bill.getString("billentity"), ids);
            this.setEntryBillNameToIdsMap(bill.getDynamicObjectCollection("entry"), result);
        }
        return result;
    }

    private void setEntryBillNameToIdsMap(DynamicObjectCollection entryCollection, Map<String, Set<Long>> map) {
        for (DynamicObject row : entryCollection) {
            Set ids = map.getOrDefault(row.getString("e_billentity"), new HashSet(16));
            ids.add(row.getLong("billid"));
            map.put(row.getString("e_billentity"), ids);
        }
    }
}

