/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.check;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.check.base.AbstractDataCheck;
import kd.fi.arapcommon.check.base.DataCheckResult;
import kd.fi.arapcommon.enums.SettleRelationEnum;
import kd.fi.arapcommon.util.DataCheckUtils;
import kd.fi.arapcommon.util.EmptyUtils;

public class ArApSettleJournalUniqueDataCheck
extends AbstractDataCheck {
    @Override
    public String getEntityName() {
        return null;
    }

    @Override
    public List<String> listSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("billno");
        selector.add("mainbillentryid");
        selector.add("settlerelation");
        selector.add("entry.seq");
        selector.add("entry.billentryid");
        selector.add("entry.billnum");
        return selector;
    }

    @Override
    public QFilter getExtendQFilter() {
        return null;
    }

    @Override
    public void setQFilter(QFilter filter) {
        if (EmptyUtils.isEmpty(filter)) {
            return;
        }
        this.defaultFilter = DataCheckUtils.generateNewSettleQFilter(filter);
    }

    @Override
    public boolean isBatch() {
        return true;
    }

    @Override
    public DataCheckResult dataCheck(DynamicObject bill) {
        return null;
    }

    protected boolean isAr() {
        return false;
    }

    @Override
    public List<DataCheckResult> dataCheck(List<DynamicObject> billList) {
        Map<Long, Set<Long>> billIdToEntryIdsMap = this.getBillIdToEntryIdsMap(billList);
        DynamicObjectCollection journalCollection = this.listJournalCollection(billIdToEntryIdsMap);
        Map<String, Integer> journalFrequencyMap = this.getJournalFrequencyMap(journalCollection);
        ArrayList<DataCheckResult> results = new ArrayList<DataCheckResult>(16);
        for (DynamicObject bill : billList) {
            String mainKey = bill.getLong("id") + "-0";
            if (journalFrequencyMap.getOrDefault(mainKey, 0).compareTo(0) == 0) {
                results.add(new DataCheckResult(ResManager.loadKDString((String)"\u4e3b\u5355\u5206\u5f55\u672a\u751f\u6210\u6d41\u6c34\u3002", (String)"ArApSettleJournalUniqueDataCheck_0", (String)"fi-arapcommon", (Object[])new Object[0])));
                continue;
            }
            if (journalFrequencyMap.getOrDefault(mainKey, 0).compareTo(1) > 0) {
                results.add(new DataCheckResult(ResManager.loadKDString((String)"\u4e3b\u5355\u5206\u5f55\u6d41\u6c34\u4e0d\u552f\u4e00\u3002", (String)"ArApSettleJournalUniqueDataCheck_1", (String)"fi-arapcommon", (Object[])new Object[0])));
                continue;
            }
            String settleRelation = bill.getString("settlerelation");
            if (SettleRelationEnum.PAYTRANS.getValue().equals(settleRelation) || SettleRelationEnum.ARTRANSFER.getValue().equals(settleRelation) || SettleRelationEnum.PREMSETTLE.getValue().equals(settleRelation)) {
                results.add(new DataCheckResult());
                continue;
            }
            boolean entryError = false;
            for (DynamicObject asstRow : bill.getDynamicObjectCollection("entry")) {
                String asstKey = bill.getLong("id") + "-" + asstRow.getLong("billentryid");
                int seq = asstRow.getInt("seq");
                String billNo = asstRow.getString("billnum");
                if (journalFrequencyMap.getOrDefault(asstKey, 0).compareTo(0) == 0) {
                    results.add(new DataCheckResult(String.format(ResManager.loadKDString((String)"\u8f85\u5355\u5206\u5f55\u7b2c%1$s\u884c\u672a\u751f\u6210\u6d41\u6c34\uff0c\u5355\u636e\u7f16\u53f7\uff1a %2$s\u3002", (String)"ArApSettleJournalUniqueDataCheck_2", (String)"fi-arapcommon", (Object[])new Object[0]), seq, billNo)));
                    entryError = true;
                    break;
                }
                if (journalFrequencyMap.getOrDefault(asstKey, 0).compareTo(1) <= 0) continue;
                results.add(new DataCheckResult(String.format(ResManager.loadKDString((String)"\u8f85\u5355\u5206\u5f55\u7b2c%1$s\u884c\u6d41\u6c34\u4e0d\u552f\u4e00\uff0c\u5355\u636e\u7f16\u53f7: %2$s\u3002", (String)"ArApSettleJournalUniqueDataCheck_3", (String)"fi-arapcommon", (Object[])new Object[0]), seq, billNo)));
                entryError = true;
                break;
            }
            if (entryError) continue;
            results.add(new DataCheckResult());
        }
        return results;
    }

    private Map<String, Integer> getJournalFrequencyMap(DynamicObjectCollection journalCollection) {
        HashMap<String, Integer> result = new HashMap<String, Integer>(16);
        for (DynamicObject journal : journalCollection) {
            String key = journal.getLong("sourcebillid") + "-" + journal.getLong("sourceentryid");
            int frequency = result.getOrDefault(key, 0);
            result.put(key, ++frequency);
        }
        return result;
    }

    private DynamicObjectCollection listJournalCollection(Map<Long, Set<Long>> billIdToEntryIdsMap) {
        Set<Long> sourceBillIds = billIdToEntryIdsMap.keySet();
        HashSet<Long> sourceEntryIds = new HashSet<Long>(16);
        billIdToEntryIdsMap.values().forEach(sourceEntryIds::addAll);
        sourceEntryIds.add(0L);
        return QueryServiceHelper.query((String)(this.isAr() ? "ar_journal" : "ap_journal"), (String)"sourcebillid,sourceentryid", (QFilter[])new QFilter[]{new QFilter("sourcebillid", "in", sourceBillIds), new QFilter("sourceentryid", "in", sourceEntryIds), new QFilter("sourcebilltype", "=", (Object)this.getEntityName())});
    }

    private Map<Long, Set<Long>> getBillIdToEntryIdsMap(List<DynamicObject> billList) {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        for (DynamicObject bill : billList) {
            Set values = result.getOrDefault(bill.getLong("id"), new HashSet(16));
            bill.getDynamicObjectCollection("entry").forEach(asstRow -> values.add(asstRow.getLong("billentryid")));
            result.put(bill.getLong("id"), values);
        }
        return result;
    }
}

