/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.check;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.check.base.AbstractDataCheck;
import kd.fi.arapcommon.check.base.DataCheckResult;
import kd.fi.arapcommon.util.DataCheckUtils;
import kd.fi.arapcommon.util.EmptyUtils;

public class ArApSettleRecordDataCheck
extends AbstractDataCheck {
    @Override
    public String getEntityName() {
        return null;
    }

    @Override
    public List<String> listSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("billno");
        selector.add("maincurrency");
        selector.add("totalsettleamt");
        selector.add("settlerelation");
        selector.add("entry.id");
        selector.add("entry.seq");
        selector.add("entry.currency");
        selector.add("entry.settleamt");
        return selector;
    }

    @Override
    public QFilter getExtendQFilter() {
        return null;
    }

    @Override
    public boolean isBatch() {
        return false;
    }

    @Override
    public void setQFilter(QFilter filter) {
        if (EmptyUtils.isEmpty(filter)) {
            return;
        }
        this.defaultFilter = DataCheckUtils.generateNewSettleQFilter(filter);
    }

    @Override
    public DataCheckResult dataCheck(DynamicObject bill) {
        DynamicObject headCurrency = bill.getDynamicObject("maincurrency");
        if (EmptyUtils.isEmpty(headCurrency)) {
            return new DataCheckResult(ResManager.loadKDString((String)"\u4e3b\u5355\u7ed3\u7b97\u5e01\u4e3a\u7a7a\u3002", (String)"ArApSettleDataCheck_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        BigDecimal headSettleAmt = bill.getBigDecimal("totalsettleamt");
        BigDecimal totalSettleAmt = BigDecimal.ZERO;
        boolean currencyUnique = true;
        for (DynamicObject row : bill.getDynamicObjectCollection("entry")) {
            DynamicObject rowCurrency = row.getDynamicObject("currency");
            if (EmptyUtils.isEmpty(rowCurrency) || rowCurrency.getLong("id") != headCurrency.getLong("id")) {
                currencyUnique = false;
                break;
            }
            totalSettleAmt = totalSettleAmt.add(row.getBigDecimal("settleamt"));
        }
        if (!currencyUnique) {
            return new DataCheckResult();
        }
        String settleRelation = bill.getString("settlerelation");
        boolean settleAmtNormal = this.isSettleAmtNormal(settleRelation, headSettleAmt, totalSettleAmt);
        if (!settleAmtNormal) {
            return new DataCheckResult(ResManager.loadKDString((String)"\u4e3b\u5355\u672c\u6b21\u7ed3\u7b97\u91d1\u989d\u4e0e\u8f85\u5355\u5408\u8ba1\u4e0d\u76f8\u7b49\u3002", (String)"ArApSettleDataCheck_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        return new DataCheckResult();
    }

    private boolean isSettleAmtNormal(String settleRelation, BigDecimal headSettleAmt, BigDecimal entryTotalSettleAmt) {
        if (DataCheckUtils.listOppositeSettleRelation().contains(settleRelation)) {
            return headSettleAmt.add(entryTotalSettleAmt).compareTo(BigDecimal.ZERO) == 0;
        }
        if (DataCheckUtils.listSettleRelation().contains(settleRelation)) {
            return headSettleAmt.compareTo(entryTotalSettleAmt) == 0;
        }
        return true;
    }

    @Override
    public List<DataCheckResult> dataCheck(List<DynamicObject> billList) {
        return null;
    }
}

