/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.check;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.fi.arapcommon.check.base.AbstractDataCheck;
import kd.fi.arapcommon.check.base.DataCheckResult;

public class ArApVerifyMaterialDataCheck
extends AbstractDataCheck {
    protected boolean isAr() {
        return false;
    }

    @Override
    public String getEntityName() {
        return null;
    }

    @Override
    public List<String> listSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("billno");
        selector.add("material");
        selector.add("entry.id");
        selector.add("entry.seq");
        selector.add("entry.e_material");
        return selector;
    }

    @Override
    public QFilter getExtendQFilter() {
        return null;
    }

    @Override
    public boolean isBatch() {
        return false;
    }

    @Override
    public DataCheckResult dataCheck(DynamicObject bill) {
        long materialMasterId = bill.getLong("material.masterid");
        int errorSeq = this.getNonUniqueMaterielRowSeq(bill.getDynamicObjectCollection("entry"), materialMasterId);
        if (errorSeq == 0) {
            return new DataCheckResult();
        }
        return new DataCheckResult(String.format(ResManager.loadKDString((String)"\u8f85\u65b9\u5355\u636e\u7b2c%s\u884c\u7269\u6599\u4e0d\u552f\u4e00", (String)"ArApVerifyMaterialDataCheck_0", (String)"fi-arapcommon", (Object[])new Object[0]), errorSeq));
    }

    @Override
    public List<DataCheckResult> dataCheck(List<DynamicObject> billList) {
        return null;
    }

    private int getNonUniqueMaterielRowSeq(DynamicObjectCollection entryCollection, long materialMasterId) {
        Optional<DynamicObject> differentRowOptional = entryCollection.stream().filter(entity -> entity.getLong("e_material.masterid") != materialMasterId).findAny();
        return differentRowOptional.map(dynamicObject -> dynamicObject.getInt("seq")).orElse(0);
    }
}

