/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.check;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.botp.runtime.BFRowLinkDownNode;
import kd.bos.entity.botp.runtime.TableDefine;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.botp.BFTrackerServiceHelper;
import kd.fi.arapcommon.check.base.AbstractDataCheck;
import kd.fi.arapcommon.check.base.DataCheckResult;

public class BusArApSrcFinWoffDataCheck
extends AbstractDataCheck {
    protected boolean isAr() {
        return false;
    }

    @Override
    public String getEntityName() {
        return null;
    }

    @Override
    public List<String> listSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("billno");
        selector.add("srcfinbillid");
        return selector;
    }

    @Override
    public QFilter getExtendQFilter() {
        return this.getBaseFilter().and(new QFilter("srcfinbillid", "<=", (Object)0));
    }

    @Override
    public boolean isBatch() {
        return true;
    }

    @Override
    public DataCheckResult dataCheck(DynamicObject bill) {
        return null;
    }

    @Override
    public List<DataCheckResult> dataCheck(List<DynamicObject> billList) {
        ArrayList<DataCheckResult> results = new ArrayList<DataCheckResult>(billList.size());
        billList.forEach(t -> {
            DataCheckResult result = new DataCheckResult();
            result.setSuccess(true);
            results.add(result);
        });
        Long[] srcFinBillIds = (Long[])billList.stream().map(entity -> entity.getLong("id")).toArray(Long[]::new);
        String targetBill = this.isAr() ? "ar_finarbill" : "ap_finapbill";
        Map<Long, List<Long>> finTarMap = this.loadNearTarBillIds(this.getEntityName(), targetBill, srcFinBillIds);
        DynamicObjectCollection busCollection = QueryServiceHelper.query((String)this.getEntityName(), (String)"sourcebillid,srcfinbillid", (QFilter[])new QFilter[]{new QFilter("entry.e_srcbillid", "in", (Object)srcFinBillIds), new QFilter("sourcebilltype", "=", (Object)this.getEntityName())});
        for (int i = 0; i < billList.size(); ++i) {
            DataCheckResult result = (DataCheckResult)results.get(i);
            Long billId = billList.get(i).getLong("id");
            List<Long> finSet = finTarMap.get(billId);
            if (finSet == null || finSet.size() <= 0) continue;
            for (Long finId : finSet) {
                List busBills = busCollection.stream().filter(t -> t.getLong("srcfinbillid") == finId.longValue()).collect(Collectors.toList());
                if (busBills != null && busBills.size() != 0) continue;
                result.setSuccess(false);
                result.setErrorMessage(ResManager.loadKDString((String)"\u672a\u627e\u5230\u6e90\u8d22\u52a1\u5355\u3002", (String)"BusArApSrcFinWoffDataCheck_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
        }
        return results;
    }

    public Map<Long, List<Long>> loadNearTarBillIds(String entityNumber, String tarEntityNumber, Long[] ids) {
        HashMap<Long, List<Long>> resultMap = new HashMap<Long, List<Long>>(ids.length);
        TableDefine tableDefine = EntityMetadataCache.loadTableDefine((String)tarEntityNumber, (String)tarEntityNumber);
        Long upTableId = tableDefine.getTableId();
        List bfRowLinkDownNodes = BFTrackerServiceHelper.loadLinkDownNodes((String)entityNumber, (String)"", (Long[])ids);
        if (bfRowLinkDownNodes == null || bfRowLinkDownNodes.size() < 1) {
            return resultMap;
        }
        for (Long id : ids) {
            List nodes = bfRowLinkDownNodes.stream().filter(bfRowLinkUpNode -> bfRowLinkUpNode.getRowId().getBillId().compareTo(id) == 0).collect(Collectors.toList());
            ArrayList srcPks = new ArrayList(10);
            for (BFRowLinkDownNode node : nodes) {
                List<BFRowLinkDownNode> sourceNodes = this.findSourceNodes(node, upTableId, id);
                List pkList = sourceNodes.stream().map(srcNode -> srcNode.getRowId().getBillId()).collect(Collectors.toList());
                srcPks.addAll(pkList);
            }
            if (srcPks.isEmpty()) continue;
            resultMap.put(id, srcPks);
        }
        return resultMap;
    }

    private List<BFRowLinkDownNode> findSourceNodes(BFRowLinkDownNode node, Long sMainTableId, Long id) {
        ArrayList<BFRowLinkDownNode> nodes = new ArrayList<BFRowLinkDownNode>(10);
        if (node.getRowId().getMainTableId().compareTo(sMainTableId) == 0 && node.getRowId().getBillId().compareTo(id) != 0) {
            nodes.add(node);
        } else {
            for (BFRowLinkDownNode sNode : node.getTNodes().values()) {
                nodes.addAll(this.findSourceNodes(sNode, sMainTableId, id));
            }
        }
        return nodes;
    }
}

