/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.check;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.check.base.AbstractDataCheck;
import kd.fi.arapcommon.check.base.DataCheckResult;
import kd.fi.arapcommon.helper.BOTPHelper;
import kd.fi.arapcommon.util.EmptyUtils;

public class FinArApAutoSettleCheck
extends AbstractDataCheck {
    protected boolean isAr() {
        return false;
    }

    @Override
    public String getEntityName() {
        return "ap_finapbill";
    }

    @Override
    public List<String> listSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("billno");
        return selector;
    }

    @Override
    public QFilter getExtendQFilter() {
        return this.getBaseFilter();
    }

    @Override
    public boolean isBatch() {
        return true;
    }

    @Override
    public DataCheckResult dataCheck(DynamicObject bill) {
        return null;
    }

    @Override
    public List<DataCheckResult> dataCheck(List<DynamicObject> billList) {
        ArrayList<DataCheckResult> result = new ArrayList<DataCheckResult>(16);
        List<Long> billIds = billList.stream().map(entity -> entity.getLong("id")).collect(Collectors.toList());
        Map<String, HashSet<Long>> targetResultMap = this.getTargetResultMap(billIds);
        HashSet<Long> sourceBillIds = this.listSourceBillId(targetResultMap);
        HashSet<Long> targetBillIds = this.listTargetBillIds(targetResultMap);
        DataSet settleRecordCollection = QueryServiceHelper.queryDataSet((String)"querySettle", (String)(this.isAr() ? "ar_settlerecord" : "ap_settlerecord"), (String)"mainbillid", (QFilter[])new QFilter[]{new QFilter("mainbillid", "in", sourceBillIds), new QFilter("entry.billid", "in", targetBillIds)}, null);
        HashSet settleRecordIds = new HashSet(16);
        settleRecordCollection.forEach(row -> settleRecordIds.add(row.getLong("mainbillid")));
        for (DynamicObject bill : billList) {
            long billId = bill.getLong("id");
            if (!sourceBillIds.contains(billId)) {
                result.add(new DataCheckResult());
                continue;
            }
            if (settleRecordIds.contains(billId)) {
                result.add(new DataCheckResult());
                continue;
            }
            result.add(new DataCheckResult(ResManager.loadKDString((String)"\u5b58\u5728\u6ca1\u6709\u7ed3\u7b97\u7684\u4e0b\u6e38\u5355\u636e\u3002", (String)"FinArApAutoSettleCheck_0", (String)"fi-arapcommon", (Object[])new Object[0])));
        }
        return result;
    }

    private HashSet<Long> listTargetBillIds(Map<String, HashSet<Long>> targetResultMap) {
        HashSet<Long> sourceBillIds = new HashSet<Long>(16);
        for (HashSet<Long> targetBillIds : targetResultMap.values()) {
            sourceBillIds.addAll(targetBillIds);
        }
        return sourceBillIds;
    }

    private HashSet<Long> listSourceBillId(Map<String, HashSet<Long>> targetResultMap) {
        HashSet<Long> sourceBillIds = new HashSet<Long>(16);
        for (Map.Entry<String, HashSet<Long>> entry : targetResultMap.entrySet()) {
            Map<String, HashSet<Long>> sourceBillsMap = BOTPHelper.findSourceBills(entry.getKey(), entry.getValue().toArray(new Long[0]));
            if (EmptyUtils.isEmpty(sourceBillsMap.get(this.getEntityName()))) continue;
            sourceBillIds.addAll((Collection<Long>)sourceBillsMap.get(this.getEntityName()));
        }
        return sourceBillIds;
    }

    private Map<String, HashSet<Long>> getTargetResultMap(List<Long> billIds) {
        Map<String, HashSet<Long>> targetResultMap = BOTPHelper.findTargetBills(this.getEntityName(), billIds.toArray(new Long[0]));
        HashMap<String, HashSet<Long>> resultMap = new HashMap<String, HashSet<Long>>(16);
        List<String> entityList = Arrays.asList("ar_finarbill", "ap_finapbill", "ap_liquidation", "cas_paybill", "cas_recbill");
        for (Map.Entry<String, HashSet<Long>> entry : targetResultMap.entrySet()) {
            DynamicObjectCollection collection;
            String entityName = entry.getKey();
            if (!entityList.contains(entityName) || EmptyUtils.isEmpty(collection = QueryServiceHelper.query((String)entityName, (String)"id", (QFilter[])this.getQFilterByEntityName(entityName, (Set<Long>)entry.getValue()).toArray()))) continue;
            resultMap.put(entityName, new HashSet(collection.stream().map(entity -> entity.getLong("id")).collect(Collectors.toList())));
        }
        return resultMap;
    }

    private QFilter getQFilterByEntityName(String entityName, Set<Long> billIds) {
        QFilter common = new QFilter("id", "in", billIds);
        if ("ar_finarbill".equals(entityName) || "ap_finapbill".equals(entityName) || "ap_liquidation".equals(entityName)) {
            common.and(new QFilter("billstatus", "=", (Object)"C"));
        }
        if ("cas_paybill".equals(entityName)) {
            common.and(new QFilter("billstatus", "=", (Object)"D"));
        }
        if ("cas_recbill".equals(entityName)) {
            common.and(new QFilter("billstatus", "=", (Object)"D"));
        }
        return common;
    }
}

