/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.check;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.check.base.AbstractDataCheck;
import kd.fi.arapcommon.check.base.DataCheckResult;

public class FinArApVoucherDataCheck
extends AbstractDataCheck {
    @Override
    public String getEntityName() {
        return "ap_finapbill";
    }

    @Override
    public List<String> listSelector() {
        ArrayList<String> selector = new ArrayList<String>(16);
        selector.add("id");
        selector.add("billno");
        selector.add("isvoucher");
        return selector;
    }

    @Override
    public QFilter getExtendQFilter() {
        return this.getBaseFilter();
    }

    @Override
    public boolean isBatch() {
        return true;
    }

    @Override
    public DataCheckResult dataCheck(DynamicObject bill) {
        return null;
    }

    @Override
    public List<DataCheckResult> dataCheck(List<DynamicObject> billList) {
        ArrayList<DataCheckResult> results = new ArrayList<DataCheckResult>(16);
        List arBillIds = billList.stream().map(t -> t.getLong("id")).collect(Collectors.toList());
        QFilter filter = new QFilter("sourcebill", "in", arBillIds).and("sourcebilltype.number", "=", (Object)"ar_finarbill");
        QFilter[] filters = new QFilter[]{filter};
        DynamicObject[] vouChers = BusinessDataServiceHelper.load((String)"gl_voucher", (String)"id,sourcebill,sourcebilltype.number", (QFilter[])filters);
        for (DynamicObject bill : billList) {
            DataCheckResult result = new DataCheckResult();
            boolean isVouCher = bill.getBoolean("isvoucher");
            List tarVouChers = Arrays.stream(vouChers).filter(v -> v.getLong("sourcebill") == bill.getLong("id")).collect(Collectors.toList());
            if (isVouCher && tarVouChers.size() == 1) {
                result.setSuccess(true);
            } else {
                String billName = (String)bill.getDynamicObjectType().getDisplayName().get((Object)"zh_CN");
                result.setSuccess(false);
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u201c%1$s\u201d\u7684%2$s\u672a\u751f\u6210\u51ed\u8bc1\u6216\u91cd\u590d\u751f\u6210\u51ed\u8bc1\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"FinArApVoucherDataCheck_0", (String)"fi-arapcommon", (Object[])new Object[0]), bill.getString("billno"), billName);
                result.setErrorMessage(msg);
            }
            results.add(result);
        }
        return results;
    }
}

