/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.check.base;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.fi.arapcommon.check.base.AbnormalBillInfo;
import kd.fi.arapcommon.check.base.CheckResult;
import kd.fi.arapcommon.check.base.DataCheckResult;
import kd.fi.arapcommon.check.base.DataCheckService;
import kd.fi.arapcommon.util.EmptyUtils;
import kd.fi.arapcommon.util.StdConfig;

public abstract class AbstractDataCheck
implements DataCheckService {
    protected QFilter defaultFilter;
    private static int QUERY_COUNT_LIMIT;
    private static int MAX_ERROR_LIMIT;
    private CheckResult checkResult = new CheckResult();

    public abstract String getEntityName();

    public abstract List<String> listSelector();

    public abstract QFilter getExtendQFilter();

    public abstract boolean isBatch();

    public abstract DataCheckResult dataCheck(DynamicObject var1);

    public abstract List<DataCheckResult> dataCheck(List<DynamicObject> var1);

    private List<Long> listAllTargetBillId() {
        QFilter filter = this.getExtendQFilter();
        if (EmptyUtils.isEmpty(filter)) {
            filter = this.getBaseFilter();
        }
        if (EmptyUtils.isNotEmpty(this.defaultFilter)) {
            filter.and(this.defaultFilter);
        }
        DynamicObjectCollection result = QueryServiceHelper.query((String)this.getEntityName(), (String)"id", (QFilter[])filter.toArray());
        return result.stream().map(entity -> entity.getLong("id")).collect(Collectors.toList());
    }

    private List<DynamicObject> listTargetBill(List<Long> billIds) {
        DynamicObject[] result = BusinessDataServiceHelper.load((String)this.getEntityName(), (String)this.getSelectFields(), (QFilter[])new QFilter("id", "in", billIds).toArray());
        if (EmptyUtils.isEmpty(result)) {
            return Collections.emptyList();
        }
        return Arrays.asList(result);
    }

    public String getSelectFields() {
        return String.join((CharSequence)",", this.listSelector());
    }

    @Override
    public CheckResult getCheckResult() {
        List<Long> allTargetBillIds = this.listAllTargetBillId();
        if (EmptyUtils.isEmpty(allTargetBillIds)) {
            return this.checkResult;
        }
        this.checkResult.setTotal(allTargetBillIds.size());
        int index = allTargetBillIds.size() / QUERY_COUNT_LIMIT;
        for (int i = 0; i <= index && this.checkResult.getBills().size() <= MAX_ERROR_LIMIT; ++i) {
            int startIndex = i * QUERY_COUNT_LIMIT;
            int endIndex = (i + 1) * QUERY_COUNT_LIMIT > allTargetBillIds.size() ? allTargetBillIds.size() : (i + 1) * QUERY_COUNT_LIMIT;
            List<Long> subTargetBillIds = allTargetBillIds.subList(startIndex, endIndex);
            List<AbnormalBillInfo> abnormalBillInfoList = this.listAbnormalBillInfo(subTargetBillIds);
            this.checkResult.getBills().addAll(abnormalBillInfoList);
        }
        return this.checkResult;
    }

    @Override
    public void setQFilter(QFilter filter) {
        this.defaultFilter = filter;
    }

    private List<AbnormalBillInfo> listAbnormalBillInfo(List<Long> subTargetBillIds) {
        List<DynamicObject> subTargetBillList = this.listTargetBill(subTargetBillIds);
        if (EmptyUtils.isEmpty(subTargetBillList)) {
            return Collections.emptyList();
        }
        if (this.isBatch()) {
            return this.listAbnormalBillInfoWithBatch(subTargetBillList);
        }
        return this.listAbnormalBillInfoWithSingle(subTargetBillList);
    }

    private List<AbnormalBillInfo> listAbnormalBillInfoWithSingle(List<DynamicObject> subTargetBillList) {
        ArrayList<AbnormalBillInfo> abnormalBillInfoList = new ArrayList<AbnormalBillInfo>(16);
        for (int i = 0; i < subTargetBillList.size(); ++i) {
            DynamicObject entity = subTargetBillList.get(i);
            DataCheckResult dataCheckResult = this.dataCheck(entity);
            if (dataCheckResult.isSuccess()) continue;
            abnormalBillInfoList.add(new AbnormalBillInfo(entity.getLong("id"), entity.getString("billno"), this.getEntityName(), dataCheckResult.getErrorMessage()));
        }
        return abnormalBillInfoList;
    }

    private List<AbnormalBillInfo> listAbnormalBillInfoWithBatch(List<DynamicObject> subTargetBillList) {
        ArrayList<AbnormalBillInfo> abnormalBillInfoList = new ArrayList<AbnormalBillInfo>(16);
        List<DataCheckResult> dataCheckResultList = this.dataCheck(subTargetBillList);
        Set uniqueBillIds = this.checkResult.getBills().stream().map(AbnormalBillInfo::getBillId).collect(Collectors.toSet());
        for (int i = 0; i < subTargetBillList.size(); ++i) {
            DynamicObject entity = subTargetBillList.get(i);
            DataCheckResult dataCheckResult = dataCheckResultList.get(i);
            if (dataCheckResult.isSuccess() || uniqueBillIds.contains(entity.getLong("id"))) continue;
            abnormalBillInfoList.add(new AbnormalBillInfo(entity.getLong("id"), entity.getString("billno"), this.getEntityName(), dataCheckResult.getErrorMessage()));
            uniqueBillIds.add(entity.getLong("id"));
        }
        return abnormalBillInfoList;
    }

    protected QFilter getBaseFilter() {
        return new QFilter("billstatus", "=", (Object)"C");
    }

    static {
        String countLimit;
        QUERY_COUNT_LIMIT = 1000;
        MAX_ERROR_LIMIT = 1000;
        String errorLimit = StdConfig.get("dataCheck.errorLimit");
        if (EmptyUtils.isNotEmpty(errorLimit)) {
            MAX_ERROR_LIMIT = Integer.parseInt(errorLimit);
        }
        if (EmptyUtils.isNotEmpty(countLimit = StdConfig.get("dataCheck.countLimit"))) {
            QUERY_COUNT_LIMIT = Integer.parseInt(countLimit);
        }
    }
}

