/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.check.helper;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.dlock.DLock;
import kd.bos.entity.cache.CacheKeyUtil;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.api.MessageInfo;
import kd.bos.schedule.api.ObjectFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.schedule.message.MessageCreator;
import kd.bos.schedule.server.ScheduleService;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.bos.threads.ThreadPool;
import kd.bos.threads.ThreadPools;
import kd.fi.arapcommon.check.base.AbnormalBillInfo;
import kd.fi.arapcommon.check.interf.IDataCheckService;
import kd.fi.arapcommon.check.param.DataCheckExecStatusEnum;
import kd.fi.arapcommon.check.param.DataCheckResult;
import kd.fi.arapcommon.check.param.DataCheckResultEnum;
import kd.fi.arapcommon.check.param.DataCheckTaskParam;
import kd.fi.arapcommon.consts.DBRouteConst;
import kd.fi.arapcommon.service.helper.SettleLogHelper;
import kd.fi.arapcommon.util.DateUtils;
import kd.fi.arapcommon.util.StdConfig;
import kd.fi.arapcommon.util.StringUtils;

public class DataCheckHelper {
    private static final ThreadPool threadPool = ThreadPools.newFixedThreadPool((String)"arap-datacheck", (int)8, (String)"ap");

    public static DynamicObject genUnExecCheckResult(long orgId, String bizObj, List<DynamicObject> checkItems, Date bizBeginDate) {
        DynamicObject checkResult = BusinessDataServiceHelper.newDynamicObject((String)"ap_datacheckresult");
        checkResult.set("billno", (Object)(System.currentTimeMillis() + DB.genGlobalLongId()));
        checkResult.set("billstatus", (Object)"C");
        checkResult.set("org", (Object)orgId);
        checkResult.set("bizobj", (Object)bizObj);
        checkResult.set("bizbegindate", (Object)bizBeginDate);
        checkResult.set("bizenddate", (Object)new Date());
        checkResult.set("execstatus", (Object)DataCheckExecStatusEnum.WAIT.getValue());
        checkResult.set("checkdate", (Object)new Date());
        checkResult.set("traceid", (Object)RequestContext.get().getTraceId());
        DynamicObjectCollection entries = checkResult.getDynamicObjectCollection("entry");
        DynamicObjectType type = entries.getDynamicObjectType();
        for (DynamicObject checkItem : checkItems) {
            DynamicObject checkEntry = new DynamicObject(type);
            checkEntry.set("e_checkitem", (Object)checkItem);
            checkEntry.set("e_execstatus", (Object)DataCheckExecStatusEnum.WAIT.getValue());
            entries.add((Object)checkEntry);
        }
        return checkResult;
    }

    public static List<DataCheckTaskParam> convertTaskParam(DynamicObject[] results) {
        ArrayList<DataCheckTaskParam> taskParamList = new ArrayList<DataCheckTaskParam>(10);
        if (ObjectUtils.isEmpty((Object[])results)) {
            return taskParamList;
        }
        for (DynamicObject result : results) {
            DynamicObjectCollection entries = result.getDynamicObjectCollection("entry");
            for (DynamicObject entry : entries) {
                DataCheckTaskParam taskParam = new DataCheckTaskParam();
                taskParam.setResultId(result.getLong("id"));
                taskParam.setEntity(result.get("bizobj") instanceof String ? result.getString("bizobj") : result.getString("bizobj.id"));
                taskParam.setResultEntryId(entry.getLong("id"));
                taskParam.setCheckItemId(entry.getLong("e_checkitem.id"));
                taskParam.setCheckType(entry.getString("e_checkitem.checktype"));
                taskParam.setPlugin(entry.getString("e_checkitem.plugin"));
                taskParam.setOrgId(result.get("org") instanceof Long ? result.getLong("org") : result.getLong("org.id"));
                taskParam.setBeginDate(result.getDate("bizbegindate"));
                taskParam.setEndDate(result.getDate("bizenddate"));
                taskParamList.add(taskParam);
            }
        }
        List customTasks = taskParamList.stream().filter(p -> "custom".equals(p.getCheckType())).collect(Collectors.toList());
        if (!ObjectUtils.isEmpty(customTasks)) {
            Set checkItemIds = customTasks.stream().map(DataCheckTaskParam::getCheckItemId).collect(Collectors.toSet());
            Map customCheckItems = BusinessDataServiceHelper.loadFromCache((String)"ap_datacheck_item", (String)"customfilter,customfilter_tag,tips", (QFilter[])new QFilter[]{new QFilter("id", "in", checkItemIds)});
            for (DataCheckTaskParam taskParam : customTasks) {
                long checkItemId = taskParam.getCheckItemId();
                DynamicObject checkItem = (DynamicObject)customCheckItems.get(checkItemId);
                if (checkItem == null) continue;
                taskParam.setCustomFilterDesc(checkItem.getString("customfilter_tag"));
                taskParam.setCustomTip(checkItem.getLocaleString("tips").toString());
            }
        }
        return taskParamList;
    }

    public static void batchExecTask(List<DataCheckTaskParam> taskParamList) {
        DataCheckHelper.batchExecTask(taskParamList, null, null);
    }

    public static void batchExecTask(List<DataCheckTaskParam> taskParamList, AbstractTask job, String taskId) {
        if (ObjectUtils.isEmpty(taskParamList)) {
            return;
        }
        int size = taskParamList.size();
        LinkedHashMap<DataCheckTaskParam, Future> futureMap = new LinkedHashMap<DataCheckTaskParam, Future>(taskParamList.size());
        ArrayList<DataCheckResult> resultList = new ArrayList<DataCheckResult>(size);
        for (DataCheckTaskParam taskParam : taskParamList) {
            Future future = threadPool.submit(() -> DataCheckHelper.execute(taskParam), RequestContext.get());
            futureMap.put(taskParam, future);
        }
        ArrayList failDataCheckParams = new ArrayList(futureMap.keySet());
        try {
            int executedSize = 0;
            for (Map.Entry entry : futureMap.entrySet()) {
                DataCheckTaskParam taskParam = (DataCheckTaskParam)entry.getKey();
                Future future = (Future)entry.getValue();
                try {
                    DataCheckResult dataCheckResult = (DataCheckResult)future.get(DataCheckHelper.getTimeOut(), TimeUnit.SECONDS);
                    resultList.add(dataCheckResult);
                    DataCheckHelper.feedbackProgress(job, taskId, size, ++executedSize);
                    failDataCheckParams.remove(taskParam);
                }
                catch (Throwable e) {
                    String stackTraceMessage = SettleLogHelper.getStackTraceMessage(e.getCause() != null ? e.getCause() : e);
                    DataCheckResult dataCheckResult = DataCheckHelper.genCheckResultByParam(taskParam);
                    dataCheckResult.setExecStatus(DataCheckExecStatusEnum.FAIL.getValue());
                    dataCheckResult.setException(e.getMessage() == null ? stackTraceMessage.substring(0, 200) : e.getMessage());
                    dataCheckResult.setExceptionTag(stackTraceMessage);
                    DataCheckHelper.updateResultEntryExecFail(dataCheckResult);
                    resultList.add(dataCheckResult);
                    future.cancel(true);
                    DataCheckHelper.feedbackProgress(job, taskId, size, ++executedSize);
                    failDataCheckParams.remove(taskParam);
                }
            }
            if (!resultList.isEmpty()) {
                DataCheckHelper.feedbackProgress(job, taskId, size, size);
            }
        }
        catch (Throwable e) {
            for (DataCheckTaskParam dataCheckTaskParam : failDataCheckParams) {
                Future future = (Future)futureMap.get(dataCheckTaskParam);
                if (!future.isDone()) {
                    future.cancel(true);
                }
                String stackTraceMessage = SettleLogHelper.getStackTraceMessage(e.getCause() != null ? e.getCause() : e);
                DataCheckResult dataCheckResult = DataCheckHelper.genCheckResultByParam(dataCheckTaskParam);
                dataCheckResult.setExecStatus(DataCheckExecStatusEnum.FAIL.getValue());
                dataCheckResult.setException(e.getMessage() == null ? stackTraceMessage.substring(0, 200) : e.getMessage());
                dataCheckResult.setExceptionTag(stackTraceMessage);
                DataCheckHelper.updateResultEntryExecFail(dataCheckResult);
            }
            DataCheckHelper.feedbackProgress(job, taskId, size, size);
        }
    }

    private static void feedbackProgress(AbstractTask job, String taskId, int size, int executedSize) {
        if (job == null || StringUtils.isEmpty(taskId)) {
            return;
        }
        ObjectFactory objectFactory = job.getMessageHandler().getObjFactory();
        if (objectFactory == null) {
            objectFactory = ScheduleService.getInstance().getObjectFactory();
        }
        int process = executedSize * 100 / size;
        if (executedSize == size) {
            process = 100;
        }
        MessageInfo message = MessageCreator.createProgressMessage((String)taskId, (int)process);
        objectFactory.getMessageSender().send(message);
    }

    public static Set<Long> getInitOrgIds(String appId) {
        String initEntity = "ap".equals(appId) ? "ap_init" : "ar_init";
        HashSet<Long> orgIds = new HashSet<Long>(8);
        DataSet initDataSet = QueryServiceHelper.queryDataSet((String)"getInitOrgIds", (String)initEntity, (String)"org", (QFilter[])new QFilter[]{new QFilter("isfinishinit", "=", (Object)Boolean.TRUE)}, (String)"");
        for (Row row : initDataSet) {
            orgIds.add(row.getLong("org"));
        }
        return orgIds;
    }

    public static Date getCheckBeginDate() {
        Date now = new Date();
        int day = DateUtils.getDay(now);
        if (day > 10) {
            return DateUtils.getMinMonthDate(now);
        }
        Calendar cal = Calendar.getInstance();
        cal.add(2, -1);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        return cal.getTime();
    }

    public static void updateResultExecuting(DataCheckTaskParam param) {
        if (param == null || param.getResultId() == 0L || param.getResultEntryId() == 0L) {
            return;
        }
        long resultId = param.getResultId();
        long resultEntryId = param.getResultEntryId();
        Date now = new Date();
        String traceId = RequestContext.get().getTraceId();
        try (TXHandle tx = TX.requiresNew((String)"updateCheckBeginTime");){
            try {
                String headSql = "update t_ap_checkresult set fcheckbegintime=?,fexecstatus=? where fid=? and fcheckbegintime is null and fexecstatus=?";
                DB.execute((DBRoute)DBRouteConst.AP, (String)headSql, (Object[])new Object[]{now, DataCheckExecStatusEnum.EXECUTING.getValue(), resultId, DataCheckExecStatusEnum.WAIT.getValue()});
                String entrySql = "update t_ap_checkresultentry set fexecbegintime=?,fexecstatus=?,ftraceid=? where fid=? and fentryid=?";
                DB.execute((DBRoute)DBRouteConst.AP, (String)entrySql, (Object[])new Object[]{now, DataCheckExecStatusEnum.EXECUTING.getValue(), traceId, resultId, resultEntryId});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
    }

    public static void updateResultEntryExecuted(DataCheckResult result) {
        if (result == null || result.getResultId() == 0L || result.getResultEntryId() == 0L) {
            return;
        }
        long resultId = result.getResultId();
        long resultEntryId = result.getResultEntryId();
        List<AbnormalBillInfo> entries = result.getEntries();
        String checkResult = entries.isEmpty() ? "normal" : "abnormal";
        result.setCheckStatus(checkResult);
        int billCount = result.getBillCount();
        int errorCount = result.getErrorCount();
        Date execEndTime = new Date();
        long costMs = execEndTime.getTime() - result.getExecBeginTime().getTime();
        double cost = (double)costMs / 1000.0;
        try (TXHandle tx = TX.requiresNew((String)"updateResultEntryExecuted");){
            try {
                String entrySql = "update t_ap_checkresultentry set fexecendtime=?,fexecstatus=?,fcost=?,fcheckresult=?,fbillcount=?,ferrorcount=? where fid=? and fentryid=?";
                DB.execute((DBRoute)DBRouteConst.AP, (String)entrySql, (Object[])new Object[]{execEndTime, DataCheckExecStatusEnum.SUCCESS.getValue(), cost, checkResult, billCount, errorCount, resultId, resultEntryId});
                if (!entries.isEmpty()) {
                    long[] subEntryPks = DB.genLongIds((String)"t_ap_checkresultsubentry", (int)entries.size());
                    ArrayList<Object[]> paramList = new ArrayList<Object[]>(entries.size());
                    for (int i = 0; i < entries.size(); ++i) {
                        AbnormalBillInfo info = entries.get(i);
                        long detailId = subEntryPks[i];
                        Object[] param = new Object[]{resultEntryId, detailId, i + 1, info.getBillNo(), info.getBillId(), info.getErrorMessage()};
                        paramList.add(param);
                    }
                    String subSql = "insert into t_ap_checkresultsubentry (fentryid,fdetailid,fseq,fbillno,fbillid,ferrormsg) values (?,?,?,?,?,?);";
                    DB.executeBatch((DBRoute)DBRouteConst.AP, (String)subSql, paramList);
                }
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
        DataCheckHelper.updateHead(result);
    }

    public static void updateResultEntryExecFail(DataCheckResult result) {
        if (result == null || result.getResultId() == 0L || result.getResultEntryId() == 0L) {
            return;
        }
        long resultId = result.getResultId();
        long resultEntryId = result.getResultEntryId();
        Date execEndTime = new Date();
        try (TXHandle tx = TX.requiresNew((String)"updateResultEntryExecFail");){
            try {
                String entrySql = "update t_ap_checkresultentry set fexecendtime=?,fexecstatus=?,fexception=?,fexception_tag=? where fid=? and fentryid=?";
                DB.execute((DBRoute)DBRouteConst.AP, (String)entrySql, (Object[])new Object[]{execEndTime, DataCheckExecStatusEnum.FAIL.getValue(), result.getException(), result.getExceptionTag(), resultId, resultEntryId});
            }
            catch (Throwable e) {
                tx.markRollback();
                throw e;
            }
        }
        DataCheckHelper.updateHead(result);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void updateHead(DataCheckResult result) {
        if (result == null || result.getResultId() == 0L) {
            return;
        }
        long resultId = result.getResultId();
        String dLockKey = "datacheck-" + CacheKeyUtil.getAcctId();
        DLock lock = DLock.createReentrant((String)(dLockKey + "-" + resultId));
        lock.fastMode();
        lock.lock();
        try {
            DynamicObject checkResultDym = BusinessDataServiceHelper.loadSingle((String)"ap_datacheckresult", (String)"checktime,checkendtime,execstatus,checkresult,e_execstatus,e_checkresult", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)resultId)});
            if (checkResultDym == null) {
                return;
            }
            DynamicObjectCollection entries = checkResultDym.getDynamicObjectCollection("entry");
            int execSuccessCount = 0;
            int checkNormalCount = 0;
            boolean execComplete = true;
            for (DynamicObject entry : entries) {
                String execStatus = entry.getString("e_execstatus");
                String checkResult = entry.getString("e_checkresult");
                if (DataCheckExecStatusEnum.WAIT.getValue().equals(execStatus) || DataCheckExecStatusEnum.EXECUTING.getValue().equals(execStatus)) {
                    execComplete = false;
                }
                if (DataCheckExecStatusEnum.FAIL.getValue().equals(execStatus)) {
                    checkResultDym.set("execstatus", (Object)DataCheckExecStatusEnum.FAIL.getValue());
                }
                if (DataCheckResultEnum.ABNORMAL.getValue().equals(checkResult)) {
                    checkResultDym.set("checkresult", (Object)DataCheckResultEnum.ABNORMAL.getValue());
                }
                if (DataCheckExecStatusEnum.SUCCESS.getValue().equals(execStatus)) {
                    ++execSuccessCount;
                }
                if (!DataCheckResultEnum.NORMAL.getValue().equals(checkResult)) continue;
                ++checkNormalCount;
            }
            if (execSuccessCount == entries.size()) {
                checkResultDym.set("execstatus", (Object)DataCheckExecStatusEnum.SUCCESS.getValue());
            }
            if (checkNormalCount == entries.size()) {
                checkResultDym.set("checkresult", (Object)DataCheckResultEnum.NORMAL.getValue());
            }
            if (execComplete) {
                checkResultDym.set("checkendtime", (Object)new Date());
            }
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{checkResultDym});
        }
        finally {
            lock.unlock();
        }
    }

    public static DataCheckResult genCheckResultByParam(DataCheckTaskParam param) {
        DataCheckResult result = new DataCheckResult();
        result.setResultId(param.getResultId());
        result.setResultEntryId(param.getResultEntryId());
        result.setOrgId(param.getOrgId());
        result.setCheckItemId(param.getCheckItemId());
        result.setBeginDate(param.getBeginDate());
        result.setEndDate(param.getEndDate());
        result.setExecBeginTime(new Date());
        return result;
    }

    private static void processTaskResult(List<DataCheckResult> resultList) {
        if (ObjectUtils.isEmpty(resultList)) {
            return;
        }
        Map<Long, List<DataCheckResult>> resultMap = resultList.stream().collect(Collectors.groupingBy(DataCheckResult::getResultId));
        ArrayList<Object[]> paramList = new ArrayList<Object[]>(resultMap.size());
        for (Map.Entry<Long, List<DataCheckResult>> entry : resultMap.entrySet()) {
            Long resultId = entry.getKey();
            List<DataCheckResult> value = entry.getValue();
            Optional<DataCheckResult> executeFailResult = value.stream().filter(result -> DataCheckExecStatusEnum.FAIL.getValue().equals(result.getExecStatus())).findAny();
            Object[] param = null;
            if (executeFailResult.isPresent()) {
                param = new Object[]{DataCheckExecStatusEnum.FAIL.getValue(), DataCheckResultEnum.ABNORMAL.getValue(), resultId};
            } else {
                boolean execSuccess = true;
                for (DataCheckResult result2 : value) {
                    if (DataCheckExecStatusEnum.SUCCESS.getValue().equals(result2.getExecStatus())) continue;
                    execSuccess = false;
                    break;
                }
                if (execSuccess) {
                    Optional<DataCheckResult> abnormalResult = value.stream().filter(result -> DataCheckResultEnum.ABNORMAL.getValue().equals(result.getCheckStatus())).findAny();
                    if (abnormalResult.isPresent()) {
                        param = new Object[]{DataCheckExecStatusEnum.SUCCESS.getValue(), DataCheckResultEnum.ABNORMAL.getValue(), resultId};
                    } else {
                        boolean checkNormal = true;
                        for (DataCheckResult result3 : value) {
                            if (DataCheckResultEnum.NORMAL.getValue().equals(result3.getCheckStatus())) continue;
                            checkNormal = false;
                            break;
                        }
                        if (checkNormal) {
                            param = new Object[]{DataCheckExecStatusEnum.SUCCESS.getValue(), DataCheckResultEnum.NORMAL.getValue(), resultId};
                        }
                    }
                }
            }
            if (param == null) continue;
            paramList.add(param);
        }
        if (!paramList.isEmpty()) {
            try (TXHandle tx = TX.requiresNew((String)"updateResultstatus");){
                try {
                    String headSql = "update t_ap_checkresult set fexecstatus=?,fcheckresult=? where fid=?;";
                    DB.executeBatch((DBRoute)DBRouteConst.AP, (String)headSql, paramList);
                }
                catch (Throwable e) {
                    tx.markRollback();
                    throw e;
                }
            }
        }
    }

    private static DataCheckResult execute(DataCheckTaskParam taskParam) {
        String plugin = taskParam.getPlugin();
        try {
            Class<?> taskClass = Class.forName(plugin);
            IDataCheckService task = (IDataCheckService)taskClass.newInstance();
            return task.dataCheck(taskParam);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private static int getTimeOut() {
        int timeout = 100;
        String timeoutcfg = StdConfig.get("datacheck_timeout");
        if (!StringUtils.isEmpty(timeoutcfg)) {
            timeout = Integer.parseInt(timeoutcfg);
        }
        return timeout;
    }
}

