/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.check.helper;

import java.math.BigDecimal;
import java.util.HashMap;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.check.helper.AmountCompareHelper;
import kd.fi.arapcommon.exception.AmountCheckExecption;
import kd.fi.arapcommon.helper.ArApHelper;

public class FinApBillCheckHelper {
    public static void checkLockAndSettleField(Set<Long> ids) {
        if (ObjectUtils.isEmpty(ids)) {
            return;
        }
        Object[] bills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"billno,org,pricetaxtotal,unsettleamount,settleamount,settlestatus,e_pricetaxtotal,lockedamt,unlockamt,settledamt,unsettleamt,planpricetax,planlockedamt,unplanlockamt,plansettledamt,unplansettleamt", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        if (ObjectUtils.isEmpty((Object[])bills)) {
            return;
        }
        HashMap<Long, Integer> apSettleParamMap = new HashMap<Long, Integer>(8);
        for (Object bill : bills) {
            Long orgId = bill.getLong("org.id");
            int apSettleParam = 0;
            if (ObjectUtils.isEmpty(apSettleParamMap.get(orgId))) {
                apSettleParam = ArApHelper.getApSettleParam(orgId);
                apSettleParamMap.put(orgId, apSettleParam);
            } else {
                apSettleParam = (Integer)apSettleParamMap.get(orgId);
            }
            FinApBillCheckHelper.checkLockAndSettleField((DynamicObject)bill, apSettleParam);
        }
    }

    public static void checkLockAndSettleField(DynamicObject bill, int apSettleParam) {
        String billno = bill.getString("billno");
        String settleStatus = bill.getString("settlestatus");
        if ("unsettle".equals(settleStatus) || "settled".equals(settleStatus)) {
            AmountCompareHelper.compare(billno, bill, "pricetaxtotal", "unsettleamount", ResManager.loadKDString((String)"\u5355\u636e\u5934\u672a\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, bill, "pricetaxtotal", "settleamount", ResManager.loadKDString((String)"\u5355\u636e\u5934\u5df2\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
        DynamicObjectCollection detailEntrys = bill.getDynamicObjectCollection("detailentry");
        BigDecimal detailEntryUnLockSum = BigDecimal.ZERO;
        BigDecimal detailEntryUnSettleSum = BigDecimal.ZERO;
        for (DynamicObject detailEntry : detailEntrys) {
            if (1 == apSettleParam) {
                AmountCompareHelper.compare(billno, detailEntry, "e_pricetaxtotal", "unsettleamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u672a\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_2", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, detailEntry, "e_pricetaxtotal", "settledamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u5df2\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_3", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, detailEntry, "e_pricetaxtotal", "unsettleamt", "settledamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55(\u672a\u7ed3\u7b97\u91d1\u989d+\u5df2\u7ed3\u7b97\u91d1\u989d)\u4e0d\u7b49\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_4", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, detailEntry, "e_pricetaxtotal", "unlockamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u672a\u9501\u5b9a\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_5", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, detailEntry, "e_pricetaxtotal", "lockedamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u5df2\u9501\u5b9a\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_6", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, detailEntry, "e_pricetaxtotal", "unlockamt", "lockedamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55(\u672a\u9501\u5b9a\u91d1\u989d+\u5df2\u9501\u5b9a\u91d1\u989d)\u4e0d\u7b49\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_7", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            detailEntryUnLockSum = detailEntryUnLockSum.add(detailEntry.getBigDecimal("unlockamt"));
            detailEntryUnSettleSum = detailEntryUnSettleSum.add(detailEntry.getBigDecimal("unsettleamt"));
        }
        DynamicObjectCollection planEntrys = bill.getDynamicObjectCollection("planentity");
        BigDecimal planEntryUnLockSum = BigDecimal.ZERO;
        BigDecimal planEntryUnSettleSum = BigDecimal.ZERO;
        for (DynamicObject planEntry : planEntrys) {
            if (2 == apSettleParam) {
                AmountCompareHelper.compare(billno, planEntry, "planpricetax", "unplansettleamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55\u672a\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_10", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, planEntry, "planpricetax", "plansettledamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55\u5df2\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_11", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, planEntry, "planpricetax", "unplansettleamt", "plansettledamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55(\u672a\u7ed3\u7b97\u91d1\u989d+\u5df2\u7ed3\u7b97\u91d1\u989d)\u4e0d\u7b49\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_12", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, planEntry, "planpricetax", "unplanlockamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55\u672a\u9501\u5b9a\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_13", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, planEntry, "planpricetax", "planlockedamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55\u5df2\u9501\u5b9a\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_14", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, planEntry, "planpricetax", "unplanlockamt", "planlockedamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55(\u672a\u9501\u5b9a\u91d1\u989d+\u5df2\u9501\u5b9a\u91d1\u989d)\u4e0d\u7b49\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_15", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, planEntry, "planlockedamt", "plansettledamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5df2\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5df2\u9501\u5b9a\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5df2\u9501\u5b9a\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_16", (String)"fi-arapcommon", (Object[])new Object[0]));
                AmountCompareHelper.compare(billno, planEntry, "unplansettleamt", "unplanlockamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u672a\u9501\u5b9a\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5c0f\u4e8e\u672a\u9501\u5b9a\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_17", (String)"fi-arapcommon", (Object[])new Object[0]));
            }
            planEntryUnLockSum = planEntryUnLockSum.add(planEntry.getBigDecimal("unplanlockamt"));
            planEntryUnSettleSum = planEntryUnSettleSum.add(planEntry.getBigDecimal("unplansettleamt"));
        }
        if ("unsettle".equals(settleStatus) || "settled".equals(settleStatus)) {
            AmountCompareHelper.compare(billno, detailEntryUnLockSum, planEntryUnLockSum, ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u672a\u9501\u5b9a\u91d1\u989d\u5408\u8ba1\u4e0e\u8ba1\u5212\u884c\u672a\u9501\u5b9a\u91d1\u989d\u5408\u8ba1\u4e0d\u4e00\u81f4\u3002", (String)"FinApBillCheckHelper_18", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, detailEntryUnSettleSum, planEntryUnSettleSum, ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u672a\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u4e0e\u8ba1\u5212\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u4e0d\u4e00\u81f4\u3002", (String)"FinApBillCheckHelper_19", (String)"fi-arapcommon", (Object[])new Object[0]));
        }
    }

    public static void checkLockAndSettleField(DynamicObject bill) {
        String billno = bill.getString("billno");
        AmountCompareHelper.compare(billno, bill, "pricetaxtotal", "unsettleamount", ResManager.loadKDString((String)"\u5355\u636e\u5934\u672a\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]));
        AmountCompareHelper.compare(billno, bill, "pricetaxtotal", "settleamount", ResManager.loadKDString((String)"\u5355\u636e\u5934\u5df2\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_1", (String)"fi-arapcommon", (Object[])new Object[0]));
        DynamicObjectCollection detailEntrys = bill.getDynamicObjectCollection("detailentry");
        BigDecimal detailEntryUnLockSum = BigDecimal.ZERO;
        BigDecimal detailEntryUnSettleSum = BigDecimal.ZERO;
        for (DynamicObject detailEntry : detailEntrys) {
            AmountCompareHelper.compare(billno, detailEntry, "e_pricetaxtotal", "unsettleamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u672a\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_2", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, detailEntry, "e_pricetaxtotal", "settledamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u5df2\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_3", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, detailEntry, "e_pricetaxtotal", "unsettleamt", "settledamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55(\u672a\u7ed3\u7b97\u91d1\u989d+\u5df2\u7ed3\u7b97\u91d1\u989d)\u4e0d\u7b49\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_4", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, detailEntry, "e_pricetaxtotal", "unlockamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u672a\u9501\u5b9a\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_5", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, detailEntry, "e_pricetaxtotal", "lockedamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55\u5df2\u9501\u5b9a\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_6", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, detailEntry, "e_pricetaxtotal", "unlockamt", "lockedamt", ResManager.loadKDString((String)"\u660e\u7ec6\u5206\u5f55(\u672a\u9501\u5b9a\u91d1\u989d+\u5df2\u9501\u5b9a\u91d1\u989d)\u4e0d\u7b49\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_7", (String)"fi-arapcommon", (Object[])new Object[0]));
            detailEntryUnLockSum = detailEntryUnLockSum.add(detailEntry.getBigDecimal("unlockamt"));
            detailEntryUnSettleSum = detailEntryUnSettleSum.add(detailEntry.getBigDecimal("unsettleamt"));
        }
        DynamicObjectCollection planEntrys = bill.getDynamicObjectCollection("planentity");
        BigDecimal planEntryUnLockSum = BigDecimal.ZERO;
        BigDecimal planEntryUnSettleSum = BigDecimal.ZERO;
        for (DynamicObject planEntry : planEntrys) {
            AmountCompareHelper.compare(billno, planEntry, "planpricetax", "unplansettleamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55\u672a\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_10", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, planEntry, "planpricetax", "plansettledamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55\u5df2\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_11", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, planEntry, "planpricetax", "unplansettleamt", "plansettledamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55(\u672a\u7ed3\u7b97\u91d1\u989d+\u5df2\u7ed3\u7b97\u91d1\u989d)\u4e0d\u7b49\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_12", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, planEntry, "planpricetax", "unplanlockamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55\u672a\u9501\u5b9a\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_13", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, planEntry, "planpricetax", "planlockedamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55\u5df2\u9501\u5b9a\u91d1\u989d\u987b\u540c\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_14", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, planEntry, "planpricetax", "unplanlockamt", "planlockedamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5206\u5f55(\u672a\u9501\u5b9a\u91d1\u989d+\u5df2\u9501\u5b9a\u91d1\u989d)\u4e0d\u7b49\u4e8e\u5e94\u4ed8\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_15", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, planEntry, "planlockedamt", "plansettledamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u5df2\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u5df2\u9501\u5b9a\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5927\u4e8e\u5df2\u9501\u5b9a\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_16", (String)"fi-arapcommon", (Object[])new Object[0]));
            AmountCompareHelper.compare(billno, planEntry, "unplansettleamt", "unplanlockamt", ResManager.loadKDString((String)"\u8ba1\u5212\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u987b\u540c\u672a\u9501\u5b9a\u91d1\u989d\u65b9\u5411\u4e00\u81f4\u4e14\u4e0d\u80fd\u5c0f\u4e8e\u672a\u9501\u5b9a\u91d1\u989d\u3002", (String)"FinApBillCheckHelper_17", (String)"fi-arapcommon", (Object[])new Object[0]));
            planEntryUnLockSum = planEntryUnLockSum.add(planEntry.getBigDecimal("unplanlockamt"));
            planEntryUnSettleSum = planEntryUnSettleSum.add(planEntry.getBigDecimal("unplansettleamt"));
        }
        AmountCompareHelper.compare(billno, detailEntryUnLockSum, planEntryUnLockSum, ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u672a\u9501\u5b9a\u91d1\u989d\u5408\u8ba1\u4e0e\u8ba1\u5212\u884c\u672a\u9501\u5b9a\u91d1\u989d\u5408\u8ba1\u4e0d\u4e00\u81f4\u3002", (String)"FinApBillCheckHelper_18", (String)"fi-arapcommon", (Object[])new Object[0]));
        AmountCompareHelper.compare(billno, detailEntryUnSettleSum, planEntryUnSettleSum, ResManager.loadKDString((String)"\u7269\u6599\u660e\u7ec6\u672a\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u4e0e\u8ba1\u5212\u884c\u672a\u7ed3\u7b97\u91d1\u989d\u5408\u8ba1\u4e0d\u4e00\u81f4\u3002", (String)"FinApBillCheckHelper_19", (String)"fi-arapcommon", (Object[])new Object[0]));
    }

    public static void checkInvoiceAmountField(Set<Long> ids) {
        if (ObjectUtils.isEmpty(ids)) {
            return;
        }
        Object[] bills = BusinessDataServiceHelper.load((String)"ap_finapbill", (String)"billno,pricetaxtotal,uninvoicedamt,detailentry.seq,e_pricetaxtotal,e_invoicedamt,e_uninvoicedamt", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        if (ObjectUtils.isEmpty((Object[])bills)) {
            return;
        }
        for (Object bill : bills) {
            String billNo = bill.getString("billno");
            BigDecimal sumEunInvoicedAmt = BigDecimal.ZERO;
            DynamicObjectCollection detailEntry = bill.getDynamicObjectCollection("detailentry");
            for (DynamicObject row : detailEntry) {
                int seq = row.getInt("seq");
                BigDecimal e_pricetaxtotal = row.getBigDecimal("e_pricetaxtotal");
                BigDecimal e_uninvoicedamt = row.getBigDecimal("e_uninvoicedamt");
                BigDecimal e_invoicedamt = row.getBigDecimal("e_invoicedamt");
                if (e_pricetaxtotal.multiply(e_uninvoicedamt).compareTo(BigDecimal.ZERO) < 0) {
                    ErrorCode errorCode = new ErrorCode("ExecCtrlHelper_0", String.format(ResManager.loadKDString((String)"%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\u53cd\u5199\u5f02\u5e38\uff0c\u672a\u5f00\u7968\u5e94\u4ed8\u91d1\u989d\u4e0e\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e0d\u4e00\u81f4\u6216\u8d85\u8fc7\u5e94\u4ed8\u91d1\u989d\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"FinApBillCheckHelper_20", (String)"fi-arapcommon", (Object[])new Object[0]), billNo, seq));
                    throw new AmountCheckExecption(errorCode);
                }
                if (e_pricetaxtotal.multiply(e_invoicedamt).compareTo(BigDecimal.ZERO) < 0) {
                    ErrorCode errorCode = new ErrorCode("ExecCtrlHelper_0", String.format(ResManager.loadKDString((String)"%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\u53cd\u5199\u5f02\u5e38\uff0c\u5df2\u5f00\u7968\u5e94\u4ed8\u91d1\u989d\u4e0e\u5e94\u4ed8\u91d1\u989d\u65b9\u5411\u4e0d\u4e00\u81f4\u6216\u8d85\u8fc7\u5e94\u4ed8\u91d1\u989d\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"FinApBillCheckHelper_21", (String)"fi-arapcommon", (Object[])new Object[0]), billNo, seq));
                    throw new AmountCheckExecption(errorCode);
                }
                if (e_pricetaxtotal.compareTo(e_uninvoicedamt.add(e_invoicedamt)) != 0) {
                    ErrorCode errorCode = new ErrorCode("ExecCtrlHelper_0", String.format(ResManager.loadKDString((String)"%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\u53cd\u5199\u5f02\u5e38\uff0c\u672a\u5f00\u7968\u5e94\u4ed8\u91d1\u989d+\u5df2\u5f00\u7968\u5e94\u4ed8\u91d1\u989d\u4e0d\u7b49\u4e8e\u5e94\u4ed8\u91d1\u989d\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"FinApBillCheckHelper_22", (String)"fi-arapcommon", (Object[])new Object[0]), billNo, seq));
                    throw new AmountCheckExecption(errorCode);
                }
                sumEunInvoicedAmt = sumEunInvoicedAmt.add(e_uninvoicedamt);
            }
            if (bill.getBigDecimal("uninvoicedamt").compareTo(sumEunInvoicedAmt) == 0) continue;
            ErrorCode errorCode = new ErrorCode("ExecCtrlHelper_0", String.format(ResManager.loadKDString((String)"%1$s\uff1a\u53cd\u5199\u5f02\u5e38\uff0c\u660e\u7ec6\u672a\u5f00\u7968\u5e94\u4ed8\u91d1\u989d\u6c47\u603b\u4e0d\u7b49\u4e8e\u672a\u5f00\u7968\u8868\u5934\u5e94\u4ed8\u91d1\u989d\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"FinApBillCheckHelper_23", (String)"fi-arapcommon", (Object[])new Object[0]), billNo));
            throw new AmountCheckExecption(errorCode);
        }
    }
}

