/*
 * Decompiled with CFR 0.152.
 */
package kd.fi.arapcommon.check.helper;

import java.math.BigDecimal;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.exception.ErrorCode;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.fi.arapcommon.exception.AmountCheckExecption;

public class InvoiceBillCheckHelper {
    public static void checkRelateAmountField(Set<Long> ids) {
        if (ObjectUtils.isEmpty(ids)) {
            return;
        }
        Object[] bills = BusinessDataServiceHelper.load((String)"ap_invoice", (String)"billno,pricetaxtotal,unrelatedamt,entry.seq,e_pricetaxtotal,e_relatedamt,e_unrelatedamt", (QFilter[])new QFilter[]{new QFilter("id", "in", ids)});
        if (ObjectUtils.isEmpty((Object[])bills)) {
            return;
        }
        for (Object bill : bills) {
            String billNo = bill.getString("billno");
            BigDecimal sumEunRelatedAmt = BigDecimal.ZERO;
            DynamicObjectCollection entry = bill.getDynamicObjectCollection("entry");
            for (DynamicObject row : entry) {
                int seq = row.getInt("seq");
                BigDecimal e_pricetaxtotal = row.getBigDecimal("e_pricetaxtotal");
                BigDecimal e_relatedamt = row.getBigDecimal("e_relatedamt");
                BigDecimal e_unrelatedamt = row.getBigDecimal("e_unrelatedamt");
                if (e_pricetaxtotal.multiply(e_relatedamt).compareTo(BigDecimal.ZERO) < 0) {
                    ErrorCode errorCode = new ErrorCode("ExecCtrlHelper_0", String.format(ResManager.loadKDString((String)"%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\u53cd\u5199\u5f02\u5e38\uff0c\u5df2\u5173\u8054\u91d1\u989d\u4e0e\u4ef7\u7a0e\u5408\u8ba1\u65b9\u5411\u4e0d\u4e00\u81f4\u6216\u8d85\u8fc7\u4ef7\u7a0e\u5408\u8ba1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"InvoiceBillCheckHelper_0", (String)"fi-arapcommon", (Object[])new Object[0]), billNo, seq));
                    throw new AmountCheckExecption(errorCode);
                }
                if (e_pricetaxtotal.multiply(e_unrelatedamt).compareTo(BigDecimal.ZERO) < 0) {
                    ErrorCode errorCode = new ErrorCode("ExecCtrlHelper_0", String.format(ResManager.loadKDString((String)"%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\u53cd\u5199\u5f02\u5e38\uff0c\u672a\u5173\u8054\u91d1\u989d\u4e0e\u4ef7\u7a0e\u5408\u8ba1\u65b9\u5411\u4e0d\u4e00\u81f4\u6216\u8d85\u8fc7\u4ef7\u7a0e\u5408\u8ba1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"InvoiceBillCheckHelper_1", (String)"fi-arapcommon", (Object[])new Object[0]), billNo, seq));
                    throw new AmountCheckExecption(errorCode);
                }
                if (e_pricetaxtotal.compareTo(e_relatedamt.add(e_unrelatedamt)) != 0) {
                    ErrorCode errorCode = new ErrorCode("ExecCtrlHelper_0", String.format(ResManager.loadKDString((String)"%1$s\uff1a\u660e\u7ec6\u7b2c%2$s\u884c\u53cd\u5199\u5f02\u5e38\uff0c\u672a\u5173\u8054\u91d1\u989d+\u5df2\u5173\u8054\u91d1\u989d\u4e0d\u7b49\u4e8e\u4ef7\u7a0e\u5408\u8ba1\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"InvoiceBillCheckHelper_2", (String)"fi-arapcommon", (Object[])new Object[0]), billNo, seq));
                    throw new AmountCheckExecption(errorCode);
                }
                sumEunRelatedAmt = sumEunRelatedAmt.add(e_unrelatedamt);
            }
            if (bill.getBigDecimal("unrelatedamt").compareTo(sumEunRelatedAmt) == 0) continue;
            ErrorCode errorCode = new ErrorCode("ExecCtrlHelper_0", String.format(ResManager.loadKDString((String)"%1$s\uff1a\u53cd\u5199\u5f02\u5e38\uff0c\u660e\u7ec6\u672a\u5173\u8054\u91d1\u989d\u6c47\u603b\u4e0d\u7b49\u4e8e\u8868\u5934\u672a\u5173\u8054\u91d1\u989d\uff0c\u64cd\u4f5c\u5931\u8d25\u3002", (String)"InvoiceBillCheckHelper_3", (String)"fi-arapcommon", (Object[])new Object[0]), billNo));
            throw new AmountCheckExecption(errorCode);
        }
    }
}

